/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.entity.ResourcesEntity;

@Path(value="/resources")
@Api(value="/resources", description="Provides the resources in this NiFi that can have access/authorization policies.")
public class ResourceResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeResource() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable resource = lookup.getResource();
            resource.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the available resources that support access/authorization policies", response=ResourcesEntity.class, authorizations={@Authorization(value="Read - /resources")})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request.")})
    public Response getResources() {
        this.authorizeResource();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        List resources = this.serviceFacade.getResources();
        ResourcesEntity entity = new ResourcesEntity();
        entity.setResources(resources);
        return this.generateOkResponse((Object)entity).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

