/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.exception.AuthenticationNotSupportedException;
import org.apache.nifi.authentication.exception.IdentityAccessException;
import org.apache.nifi.authentication.exception.InvalidLoginCredentialsException;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.AccessConfigurationDTO;
import org.apache.nifi.web.api.dto.AccessStatusDTO;
import org.apache.nifi.web.api.dto.AccessTokenExpirationDTO;
import org.apache.nifi.web.api.entity.AccessConfigurationEntity;
import org.apache.nifi.web.api.entity.AccessStatusEntity;
import org.apache.nifi.web.api.entity.AccessTokenExpirationEntity;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.LogoutException;
import org.apache.nifi.web.security.UntrustedProxyException;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.jwt.revocation.JwtLogoutListener;
import org.apache.nifi.web.security.kerberos.KerberosService;
import org.apache.nifi.web.security.knox.KnoxService;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.apache.nifi.web.security.x509.X509AuthenticationProvider;
import org.apache.nifi.web.security.x509.X509AuthenticationRequestToken;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

@Path(value="/access")
@Api(value="/access", description="Endpoints for obtaining an access token or checking access status.")
public class AccessResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(AccessResource.class);
    protected static final String AUTHENTICATION_NOT_ENABLED_MSG = "User authentication/authorization is only supported when running over HTTPS.";
    private X509CertificateExtractor certificateExtractor;
    private X509AuthenticationProvider x509AuthenticationProvider;
    private X509PrincipalExtractor principalExtractor;
    private LoginIdentityProvider loginIdentityProvider;
    private JwtAuthenticationProvider jwtAuthenticationProvider;
    private JwtLogoutListener jwtLogoutListener;
    private JwtDecoder jwtDecoder;
    private BearerTokenProvider bearerTokenProvider;
    private BearerTokenResolver bearerTokenResolver;
    private KnoxService knoxService;
    private KerberosService kerberosService;
    private LogoutRequestManager logoutRequestManager;

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @ApiOperation(value="Retrieves the access configuration for this NiFi", response=AccessConfigurationEntity.class)
    public Response getLoginConfig(@Context HttpServletRequest httpServletRequest) {
        AccessConfigurationDTO accessConfiguration = new AccessConfigurationDTO();
        accessConfiguration.setSupportsLogin(Boolean.valueOf(this.loginIdentityProvider != null && httpServletRequest.isSecure()));
        AccessConfigurationEntity entity = new AccessConfigurationEntity();
        entity.setConfig(accessConfiguration);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="knox/request")
    @ApiOperation(value="Initiates a request to authenticate through Apache Knox.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void knoxRequest(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, AUTHENTICATION_NOT_ENABLED_MSG);
            return;
        }
        if (!this.knoxService.isKnoxEnabled()) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, "Apache Knox SSO support is not configured.");
            return;
        }
        String originalUri = this.generateResourceUri(new String[]{"access", "knox", "callback"});
        URI authorizationUri = UriBuilder.fromUri((String)this.knoxService.getKnoxUrl()).queryParam("originalUrl", new Object[]{originalUri}).build(new Object[0]);
        httpServletResponse.sendRedirect(authorizationUri.toString());
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="knox/callback")
    @ApiOperation(value="Redirect/callback URI for processing the result of the Apache Knox login sequence.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void knoxCallback(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, AUTHENTICATION_NOT_ENABLED_MSG);
            return;
        }
        if (!this.knoxService.isKnoxEnabled()) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, "Apache Knox SSO support is not configured.");
            return;
        }
        httpServletResponse.sendRedirect(this.getNiFiUri());
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="knox/logout")
    @ApiOperation(value="Performs a logout in the Apache Knox.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void knoxLogout(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        String redirectPath = this.generateResourceUri(new String[]{"..", "nifi", "login"});
        httpServletResponse.sendRedirect(redirectPath);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="")
    @ApiOperation(value="Gets the status the client's access", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=AccessStatusEntity.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Unable to determine access status because the client could not be authenticated."), @ApiResponse(code=403, message="Unable to determine access status because the client is not authorized to make this request."), @ApiResponse(code=409, message="Unable to determine access status because NiFi is not in the appropriate state."), @ApiResponse(code=500, message="Unable to determine access status because an unexpected error occurred.")})
    public Response getAccessStatus(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) {
        AccessStatusDTO accessStatus;
        block10: {
            if (!httpServletRequest.isSecure()) {
                throw new AuthenticationNotSupportedException(AUTHENTICATION_NOT_ENABLED_MSG);
            }
            accessStatus = new AccessStatusDTO();
            try {
                X509Certificate[] certificates = this.certificateExtractor.extractClientCertificate(httpServletRequest);
                if (certificates == null) {
                    String bearerToken = this.bearerTokenResolver.resolve(httpServletRequest);
                    if (bearerToken == null) {
                        accessStatus.setStatus(AccessStatusDTO.Status.UNKNOWN.name());
                        accessStatus.setMessage("Access Unknown: Certificate and Token not found.");
                        break block10;
                    }
                    try {
                        BearerTokenAuthenticationToken authenticationToken = new BearerTokenAuthenticationToken(bearerToken);
                        Authentication authentication = this.jwtAuthenticationProvider.authenticate((Authentication)authenticationToken);
                        NiFiUserDetails userDetails = (NiFiUserDetails)authentication.getPrincipal();
                        String identity = userDetails.getUsername();
                        accessStatus.setIdentity(identity);
                        accessStatus.setStatus(AccessStatusDTO.Status.ACTIVE.name());
                        accessStatus.setMessage("Access Granted: Token authenticated.");
                        break block10;
                    }
                    catch (AuthenticationException iae) {
                        this.applicationCookieService.removeCookie(this.getCookieResourceUri(), httpServletResponse, ApplicationCookieName.AUTHORIZATION_BEARER);
                        throw iae;
                    }
                }
                try {
                    String proxiedEntitiesChain = httpServletRequest.getHeader("X-ProxiedEntitiesChain");
                    String proxiedEntityGroups = httpServletRequest.getHeader("X-ProxiedEntityGroups");
                    X509AuthenticationRequestToken x509Request = new X509AuthenticationRequestToken(proxiedEntitiesChain, proxiedEntityGroups, this.principalExtractor, certificates, httpServletRequest.getRemoteAddr());
                    Authentication authenticationResponse = this.x509AuthenticationProvider.authenticate((Authentication)x509Request);
                    NiFiUser nifiUser = ((NiFiUserDetails)authenticationResponse.getDetails()).getNiFiUser();
                    accessStatus.setIdentity(nifiUser.getIdentity());
                    accessStatus.setStatus(AccessStatusDTO.Status.ACTIVE.name());
                    accessStatus.setMessage("Access Granted: Certificate authenticated.");
                }
                catch (IllegalArgumentException iae) {
                    throw new InvalidAuthenticationException(iae.getMessage(), (Throwable)iae);
                }
            }
            catch (UntrustedProxyException upe) {
                throw new AccessDeniedException(upe.getMessage(), (Throwable)upe);
            }
            catch (AuthenticationServiceException ase) {
                throw new AdministrationException(ase.getMessage(), (Throwable)ase);
            }
        }
        AccessStatusEntity entity = new AccessStatusEntity();
        entity.setAccessStatus(accessStatus);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/kerberos")
    @ApiOperation(value="Creates a token for accessing the REST API via Kerberos ticket exchange / SPNEGO negotiation", notes="The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. The token can be used in the Authorization header in the format 'Authorization: Bearer <token>'. It is also stored in the browser as a cookie.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="NiFi was unable to complete the request because it did not contain a valid Kerberos ticket in the Authorization header. Retry this request after initializing a ticket with kinit and ensuring your browser is configured to support SPNEGO."), @ApiResponse(code=409, message="Unable to create access token because NiFi is not in the appropriate state. (i.e. may not be configured to support Kerberos login."), @ApiResponse(code=500, message="Unable to create access token because an unexpected error occurred.")})
    public Response createAccessTokenFromTicket(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) {
        if (!httpServletRequest.isSecure()) {
            throw new AuthenticationNotSupportedException("Access tokens are only issued over HTTPS.");
        }
        if (!this.properties.isKerberosSpnegoSupportEnabled() || this.kerberosService == null) {
            String message = "Kerberos ticket login not supported by this NiFi.";
            logger.debug("Kerberos ticket login not supported by this NiFi.");
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Kerberos ticket login not supported by this NiFi.").build();
        }
        String authorizationHeaderValue = httpServletRequest.getHeader("Authorization");
        if (!this.kerberosService.isValidKerberosHeader(authorizationHeaderValue)) {
            return this.generateNotAuthorizedResponse().header("WWW-Authenticate", (Object)"Negotiate").build();
        }
        try {
            Authentication authentication = this.kerberosService.validateKerberosTicket(httpServletRequest);
            if (authentication == null) {
                throw new IllegalArgumentException("Request is not HTTPS or Kerberos ticket missing or malformed");
            }
            String expirationFromProperties = this.properties.getKerberosAuthenticationExpiration();
            long expirationDuration = Math.round(FormatUtils.getPreciseTimeDuration((String)expirationFromProperties, (TimeUnit)TimeUnit.MILLISECONDS));
            Instant expiration = Instant.now().plusMillis(expirationDuration);
            String rawIdentity = authentication.getName();
            String mappedIdentity = IdentityMappingUtil.mapIdentity((String)rawIdentity, (List)IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(mappedIdentity, expiration, Collections.emptySet());
            String token = this.bearerTokenProvider.getBearerToken(loginAuthenticationToken);
            URI uri = URI.create(this.generateResourceUri(new String[]{"access", "kerberos"}));
            this.setBearerToken(httpServletResponse, token);
            return this.generateCreatedResponse(uri, (Object)token).build();
        }
        catch (AuthenticationException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @Path(value="/token")
    @ApiOperation(value="Creates a token for accessing the REST API via username/password", notes="The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. It is stored in the browser as a cookie, but also returned inthe response body to be stored/used by third party client scripts.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="Unable to create access token because NiFi is not in the appropriate state. (i.e. may not be configured to support username/password login."), @ApiResponse(code=500, message="Unable to create access token because an unexpected error occurred.")})
    public Response createAccessToken(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        LoginAuthenticationToken loginAuthenticationToken;
        if (!httpServletRequest.isSecure()) {
            throw new AuthenticationNotSupportedException("Access tokens are only issued over HTTPS.");
        }
        if (this.loginIdentityProvider == null) {
            throw new IllegalStateException("Username/Password login not supported by this NiFi.");
        }
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("The username and password must be specified.");
        }
        try {
            AuthenticationResponse authenticationResponse = this.loginIdentityProvider.authenticate(new LoginCredentials(username, password));
            String rawIdentity = authenticationResponse.getIdentity();
            String mappedIdentity = IdentityMappingUtil.mapIdentity((String)rawIdentity, (List)IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            long expirationDuration = authenticationResponse.getExpiration();
            Instant expiration = Instant.now().plusMillis(expirationDuration);
            loginAuthenticationToken = new LoginAuthenticationToken(mappedIdentity, expiration, Collections.emptySet());
        }
        catch (InvalidLoginCredentialsException ilce) {
            throw new IllegalArgumentException("The supplied username and password are not valid.", ilce);
        }
        catch (IdentityAccessException iae) {
            throw new AdministrationException(iae.getMessage(), (Throwable)iae);
        }
        String bearerToken = this.bearerTokenProvider.getBearerToken(loginAuthenticationToken);
        URI uri = URI.create(this.generateResourceUri(new String[]{"access", "token"}));
        this.setBearerToken(httpServletResponse, bearerToken);
        return this.generateCreatedResponse(uri, (Object)bearerToken).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/token/expiration")
    @ApiOperation(value="Get expiration for current Access Token", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=AccessTokenExpirationEntity.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Access Token Expiration found"), @ApiResponse(code=401, message="Access Token not authorized"), @ApiResponse(code=409, message="Access Token not resolved")})
    public Response getAccessTokenExpiration() {
        String bearerToken = this.bearerTokenResolver.resolve(this.httpServletRequest);
        if (bearerToken == null) {
            throw new IllegalStateException("Access Token not found");
        }
        Jwt jwt = this.jwtDecoder.decode(bearerToken);
        Instant expiration = jwt.getExpiresAt();
        AccessTokenExpirationDTO accessTokenExpiration = new AccessTokenExpirationDTO();
        accessTokenExpiration.setExpiration(expiration);
        AccessTokenExpirationEntity accessTokenExpirationEntity = new AccessTokenExpirationEntity();
        accessTokenExpirationEntity.setAccessTokenExpiration(accessTokenExpiration);
        return Response.ok((Object)accessTokenExpirationEntity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/logout")
    @ApiOperation(value="Performs a logout for other providers that have been issued a JWT.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    @ApiResponses(value={@ApiResponse(code=200, message="User was logged out successfully."), @ApiResponse(code=401, message="Authentication token provided was empty or not in the correct JWT format."), @ApiResponse(code=500, message="Client failed to log out.")})
    public Response logOut(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException(AUTHENTICATION_NOT_ENABLED_MSG);
        }
        String mappedUserIdentity = NiFiUserUtils.getNiFiUserIdentity();
        if (StringUtils.isBlank((CharSequence)mappedUserIdentity)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication token provided was empty or not in the correct JWT format.").build();
        }
        try {
            String requestIdentifier = UUID.randomUUID().toString();
            logger.info("Logout Request [{}] Identity [{}] started", (Object)requestIdentifier, (Object)mappedUserIdentity);
            this.applicationCookieService.removeCookie(this.getCookieResourceUri(), httpServletResponse, ApplicationCookieName.AUTHORIZATION_BEARER);
            String bearerToken = this.bearerTokenResolver.resolve(httpServletRequest);
            this.jwtLogoutListener.logout(bearerToken);
            LogoutRequest logoutRequest = new LogoutRequest(requestIdentifier, mappedUserIdentity);
            this.logoutRequestManager.start(logoutRequest);
            this.applicationCookieService.addCookie(this.getCookieResourceUri(), httpServletResponse, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER, logoutRequest.getRequestIdentifier());
            return this.generateOkResponse().build();
        }
        catch (LogoutException e) {
            logger.error("Logout Failed Identity [{}]", (Object)mappedUserIdentity, (Object)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/logout/complete")
    @ApiOperation(value="Completes the logout sequence by removing the cached Logout Request and Cookie if they existed and redirects to /nifi/login.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    @ApiResponses(value={@ApiResponse(code=200, message="User was logged out successfully."), @ApiResponse(code=401, message="Authentication token provided was empty or not in the correct JWT format."), @ApiResponse(code=500, message="Client failed to log out.")})
    public void logOutComplete(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException(AUTHENTICATION_NOT_ENABLED_MSG);
        }
        this.completeLogoutRequest(httpServletResponse);
        httpServletResponse.sendRedirect(this.getNiFiLogoutCompleteUri());
    }

    private LogoutRequest completeLogoutRequest(HttpServletResponse httpServletResponse) {
        LogoutRequest logoutRequest = null;
        Optional cookieValue = this.getLogoutRequestIdentifier();
        if (cookieValue.isPresent()) {
            String logoutRequestIdentifier = (String)cookieValue.get();
            logoutRequest = this.logoutRequestManager.complete(logoutRequestIdentifier);
            logger.info("Logout Request [{}] Completed [{}]", (Object)logoutRequestIdentifier, (Object)logoutRequest.getMappedUserIdentity());
        } else {
            logger.warn("Logout Request Cookie [{}] not found", (Object)ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName());
        }
        this.removeLogoutRequestCookie(httpServletResponse);
        return logoutRequest;
    }

    private String getNiFiLogoutCompleteUri() {
        return this.getNiFiUri() + "logout-complete";
    }

    private void removeLogoutRequestCookie(HttpServletResponse httpServletResponse) {
        this.applicationCookieService.removeCookie(this.getCookieResourceUri(), httpServletResponse, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
    }

    private Optional<String> getLogoutRequestIdentifier() {
        return this.applicationCookieService.getCookieValue(this.httpServletRequest, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
    }

    public void setLoginIdentityProvider(LoginIdentityProvider loginIdentityProvider) {
        this.loginIdentityProvider = loginIdentityProvider;
    }

    public void setBearerTokenProvider(BearerTokenProvider bearerTokenProvider) {
        this.bearerTokenProvider = bearerTokenProvider;
    }

    public void setBearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }

    public void setJwtAuthenticationProvider(JwtAuthenticationProvider jwtAuthenticationProvider) {
        this.jwtAuthenticationProvider = jwtAuthenticationProvider;
    }

    public void setJwtDecoder(JwtDecoder jwtDecoder) {
        this.jwtDecoder = jwtDecoder;
    }

    public void setJwtLogoutListener(JwtLogoutListener jwtLogoutListener) {
        this.jwtLogoutListener = jwtLogoutListener;
    }

    public void setKerberosService(KerberosService kerberosService) {
        this.kerberosService = kerberosService;
    }

    public void setX509AuthenticationProvider(X509AuthenticationProvider x509AuthenticationProvider) {
        this.x509AuthenticationProvider = x509AuthenticationProvider;
    }

    public void setPrincipalExtractor(X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }

    public void setCertificateExtractor(X509CertificateExtractor certificateExtractor) {
        this.certificateExtractor = certificateExtractor;
    }

    public void setKnoxService(KnoxService knoxService) {
        this.knoxService = knoxService;
    }

    public void setLogoutRequestManager(LogoutRequestManager logoutRequestManager) {
        this.logoutRequestManager = logoutRequestManager;
    }
}

