/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthorizeParameterReference {
    public static void authorizeParameterReferences(Map<String, String> proposedProperties, Authorizer authorizer, Authorizable parameterContextAuthorizable, NiFiUser user) {
        if (proposedProperties == null || parameterContextAuthorizable == null) {
            return;
        }
        ExpressionLanguageAgnosticParameterParser parameterParser = new ExpressionLanguageAgnosticParameterParser();
        boolean referencesParameter = false;
        for (String proposedPropertyValue : proposedProperties.values()) {
            ParameterTokenList tokenList = parameterParser.parseTokens(proposedPropertyValue);
            if (tokenList.toReferenceList().isEmpty()) continue;
            referencesParameter = true;
            break;
        }
        if (referencesParameter) {
            parameterContextAuthorizable.authorize(authorizer, RequestAction.READ, user);
        }
    }

    public static void authorizeParameterReferences(ComponentAuthorizable authorizable, Authorizer authorizer, Authorizable parameterContextAuthorizable, NiFiUser user) {
        if (parameterContextAuthorizable == null) {
            return;
        }
        ExpressionLanguageAgnosticParameterParser parameterParser = new ExpressionLanguageAgnosticParameterParser();
        boolean referencesParameter = false;
        for (PropertyDescriptor propertyDescriptor : authorizable.getPropertyDescriptors()) {
            String rawValue = authorizable.getRawValue(propertyDescriptor);
            ParameterTokenList tokenList = parameterParser.parseTokens(rawValue);
            if (tokenList.toReferenceList().isEmpty()) continue;
            referencesParameter = true;
            break;
        }
        if (referencesParameter) {
            parameterContextAuthorizable.authorize(authorizer, RequestAction.READ, user);
        }
    }

    public static void authorizeParameterReferences(FlowSnippetDTO flowSnippet, Authorizer authorizer, Authorizable parameterContextAuthorizable, NiFiUser user) {
        for (ProcessorDTO processorDto : flowSnippet.getProcessors()) {
            ProcessorConfigDTO configDto = processorDto.getConfig();
            if (configDto == null) continue;
            AuthorizeParameterReference.authorizeParameterReferences((Map)configDto.getProperties(), (Authorizer)authorizer, (Authorizable)parameterContextAuthorizable, (NiFiUser)user);
        }
        for (ControllerServiceDTO serviceDto : flowSnippet.getControllerServices()) {
            AuthorizeParameterReference.authorizeParameterReferences((Map)serviceDto.getProperties(), (Authorizer)authorizer, (Authorizable)parameterContextAuthorizable, (NiFiUser)user);
        }
    }

    public static void authorizeParameterReferences(ProcessGroup destinationGroup, ComponentAuthorizable component, Authorizer authorizer, NiFiUser user) {
        ParameterContext destinationContext;
        ExpressionLanguageAgnosticParameterParser parameterParser = new ExpressionLanguageAgnosticParameterParser();
        boolean referencesParameter = false;
        for (PropertyDescriptor propertyDescriptor : component.getPropertyDescriptors()) {
            String rawValue = component.getRawValue(propertyDescriptor);
            ParameterTokenList tokenList = parameterParser.parseTokens(rawValue);
            if (tokenList.toReferenceList().isEmpty()) continue;
            referencesParameter = true;
            break;
        }
        if (referencesParameter && (destinationContext = destinationGroup.getParameterContext()) != null) {
            destinationContext.authorize(authorizer, RequestAction.READ, user);
        }
    }

    public static void authorizeParameterContextAddition(VersionedParameterContext versionedParameterContext, NiFiServiceFacade serviceFacade, Authorizer authorizer, AuthorizableLookup lookup, NiFiUser user) {
        ParameterContext parameterContext = serviceFacade.getParameterContextByName(versionedParameterContext.getName(), user);
        if (parameterContext == null) {
            lookup.getParameterContexts().authorize(authorizer, RequestAction.WRITE, user);
            return;
        }
        parameterContext.authorize(authorizer, RequestAction.READ, user);
        Set existingParameterNames = parameterContext.getParameters().keySet().stream().map(ParameterDescriptor::getName).collect(Collectors.toSet());
        List existingParameterContextNames = parameterContext.getInheritedParameterContextNames();
        boolean requiresAddition = false;
        for (VersionedParameter versionedParameter : versionedParameterContext.getParameters()) {
            String versionedParameterName;
            if (versionedParameter == null || existingParameterNames.contains(versionedParameterName = versionedParameter.getName())) continue;
            requiresAddition = true;
            break;
        }
        if (requiresAddition || !existingParameterContextNames.equals(versionedParameterContext.getInheritedParameterContexts())) {
            parameterContext.authorize(authorizer, RequestAction.WRITE, user);
        }
    }
}

