/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.util.Optional;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;

public class AffectedComponentUtils {
    public static AffectedComponentEntity updateEntity(AffectedComponentEntity componentEntity, NiFiServiceFacade serviceFacade, DtoFactory dtoFactory) {
        switch (componentEntity.getComponent().getReferenceType()) {
            case "PROCESSOR": {
                ProcessorEntity procEntity = serviceFacade.getProcessor(componentEntity.getId());
                return dtoFactory.createAffectedComponentEntity(procEntity);
            }
            case "INPUT_PORT": {
                PortEntity portEntity = serviceFacade.getInputPort(componentEntity.getId());
                return dtoFactory.createAffectedComponentEntity(portEntity, "INPUT_PORT");
            }
            case "OUTPUT_PORT": {
                PortEntity portEntity = serviceFacade.getOutputPort(componentEntity.getId());
                return dtoFactory.createAffectedComponentEntity(portEntity, "OUTPUT_PORT");
            }
            case "CONTROLLER_SERVICE": {
                ControllerServiceEntity serviceEntity = serviceFacade.getControllerService(componentEntity.getId(), false);
                return dtoFactory.createAffectedComponentEntity(serviceEntity);
            }
            case "REMOTE_INPUT_PORT": {
                RemoteProcessGroupEntity remoteGroupEntity = serviceFacade.getRemoteProcessGroup(componentEntity.getComponent().getProcessGroupId());
                RemoteProcessGroupContentsDTO remoteGroupContents = remoteGroupEntity.getComponent().getContents();
                Optional<RemoteProcessGroupPortDTO> portDtoOption = remoteGroupContents.getInputPorts().stream().filter(port -> port.getId().equals(componentEntity.getId())).findFirst();
                if (!portDtoOption.isPresent()) break;
                RemoteProcessGroupPortDTO portDto = portDtoOption.get();
                return dtoFactory.createAffectedComponentEntity(portDto, "REMOTE_INPUT_PORT", remoteGroupEntity);
            }
            case "REMOTE_OUTPUT_PORT": {
                RemoteProcessGroupEntity remoteGroupEntity = serviceFacade.getRemoteProcessGroup(componentEntity.getComponent().getProcessGroupId());
                RemoteProcessGroupContentsDTO remoteGroupContents = remoteGroupEntity.getComponent().getContents();
                Optional<RemoteProcessGroupPortDTO> portDtoOption = remoteGroupContents.getOutputPorts().stream().filter(port -> port.getId().equals(componentEntity.getId())).findFirst();
                if (!portDtoOption.isPresent()) break;
                RemoteProcessGroupPortDTO portDto = portDtoOption.get();
                return dtoFactory.createAffectedComponentEntity(portDto, "REMOTE_OUTPUT_PORT", remoteGroupEntity);
            }
        }
        return null;
    }
}

