/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.nifi.web.api.dto.search.ComponentSearchResultDTO;
import org.apache.nifi.web.search.ComponentMatcher;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class AttributeBasedComponentMatcher<T>
implements ComponentMatcher<T> {
    private final List<AttributeMatcher<T>> attributeMatchers = new ArrayList();
    private final Function<T, String> getComponentIdentifier;
    private final Function<T, String> getComponentName;

    public AttributeBasedComponentMatcher(List<AttributeMatcher<T>> attributeMatchers, Function<T, String> getComponentIdentifier, Function<T, String> getComponentName) {
        this.getComponentIdentifier = getComponentIdentifier;
        this.getComponentName = getComponentName;
        this.attributeMatchers.addAll(attributeMatchers);
    }

    public final Optional<ComponentSearchResultDTO> match(T component, SearchQuery query) {
        LinkedList matches = new LinkedList();
        this.attributeMatchers.forEach(matcher -> matcher.match(component, query, matches));
        return matches.isEmpty() ? Optional.empty() : Optional.of(this.generateResult(component, matches));
    }

    private ComponentSearchResultDTO generateResult(T component, List<String> matches) {
        ComponentSearchResultDTO result = new ComponentSearchResultDTO();
        result.setId((String)this.getComponentIdentifier.apply(component));
        result.setName((String)this.getComponentName.apply(component));
        result.setMatches(matches);
        return result;
    }
}

