/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.StandardFlowSnippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.TemplateUtils;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.dao.TemplateDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.util.SnippetUtils;

public class StandardTemplateDAO
extends ComponentDAO
implements TemplateDAO {
    private FlowController flowController;
    private SnippetUtils snippetUtils;

    private Template locateTemplate(String templateId) {
        Template template = this.flowController.getFlowManager().getRootGroup().findTemplate(templateId);
        if (template == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate template with id '%s'.", templateId));
        }
        return template;
    }

    public void verifyCanAddTemplate(String name, String groupId) {
        ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(groupId);
        if (processGroup == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + groupId);
        }
        processGroup.verifyCanAddTemplate(name);
    }

    public void verifyCanInstantiate(String groupId, FlowSnippetDTO snippetDTO) {
        ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(groupId);
        if (processGroup == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + groupId);
        }
        this.verifyComponentTypes(snippetDTO);
        this.verifyParameterReferences(snippetDTO, processGroup.getParameterContext());
    }

    private void verifyParameterReferences(FlowSnippetDTO snippet, ParameterContext parameterContext) {
        ConfigurableComponent component;
        BundleCoordinate bundleCoordinate;
        BundleDTO bundleDto;
        if (parameterContext == null) {
            return;
        }
        ExpressionLanguageAwareParameterParser parameterParser = new ExpressionLanguageAwareParameterParser();
        for (ProcessorDTO processor : snippet.getProcessors()) {
            bundleDto = processor.getBundle();
            bundleCoordinate = new BundleCoordinate(bundleDto.getGroup(), bundleDto.getArtifact(), bundleDto.getVersion());
            component = this.flowController.getExtensionManager().getTempComponent(processor.getType(), bundleCoordinate);
            ProcessorConfigDTO config = processor.getConfig();
            for (Map.Entry entry : config.getProperties().entrySet()) {
                String propertyName = (String)entry.getKey();
                ParameterTokenList references = parameterParser.parseTokens((String)entry.getValue());
                PropertyDescriptor descriptor = component.getPropertyDescriptor(propertyName);
                this.verifyParameterReference(descriptor, references, parameterContext);
            }
        }
        for (ControllerServiceDTO service : snippet.getControllerServices()) {
            bundleDto = service.getBundle();
            bundleCoordinate = new BundleCoordinate(bundleDto.getGroup(), bundleDto.getArtifact(), bundleDto.getVersion());
            component = this.flowController.getExtensionManager().getTempComponent(service.getType(), bundleCoordinate);
            for (Map.Entry entry : service.getProperties().entrySet()) {
                String propertyName = (String)entry.getKey();
                ParameterTokenList references = parameterParser.parseTokens((String)entry.getValue());
                PropertyDescriptor descriptor = component.getPropertyDescriptor(propertyName);
                this.verifyParameterReference(descriptor, references, parameterContext);
            }
        }
    }

    private void verifyParameterReference(PropertyDescriptor descriptor, ParameterTokenList parameterTokenList, ParameterContext parameterContext) {
        if (descriptor == null || parameterTokenList == null) {
            return;
        }
        List references = parameterTokenList.toReferenceList();
        for (ParameterReference reference : references) {
            String parameterName = reference.getParameterName();
            Optional parameter = parameterContext.getParameter(parameterName);
            if (!parameter.isPresent()) continue;
            boolean parameterSensitive = ((Parameter)parameter.get()).getDescriptor().isSensitive();
            if (descriptor.isSensitive() && !parameterSensitive) {
                throw new IllegalStateException("Cannot instantiate template within this Process Group because template references the '" + parameterName + "' Parameter in a sensitive property, but the Parameter is not sensitive");
            }
            if (descriptor.isSensitive() || !parameterSensitive) continue;
            throw new IllegalStateException("Cannot instantiate template within this Process Group because template references the '" + parameterName + "' Parameter in a non-sensitive property, but the Parameter is sensitive");
        }
    }

    private void verifyComponentTypes(FlowSnippetDTO snippetDto) {
        StandardFlowSnippet flowSnippet = new StandardFlowSnippet(snippetDto, this.flowController.getExtensionManager());
        flowSnippet.verifyComponentTypesInSnippet();
    }

    public Template importTemplate(TemplateDTO templateDTO, String groupId) {
        return this.createTemplate(templateDTO, groupId);
    }

    public Template createTemplate(TemplateDTO templateDTO, String groupId) {
        ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(groupId);
        if (processGroup == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + groupId);
        }
        this.verifyCanAddTemplate(templateDTO.getName(), groupId);
        TemplateUtils.scrubTemplate((TemplateDTO)templateDTO);
        TemplateUtils.escapeParameterReferences((TemplateDTO)templateDTO);
        Template template = new Template(templateDTO);
        processGroup.addTemplate(template);
        return template;
    }

    public FlowSnippetDTO instantiateTemplate(String groupId, Double originX, Double originY, String encodingVersion, FlowSnippetDTO requestSnippet, String idGenerationSeed) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        try {
            FlowSnippetDTO snippet = this.snippetUtils.copy(requestSnippet, group, idGenerationSeed, false);
            FlowEncodingVersion templateEncodingVersion = FlowEncodingVersion.parse((String)encodingVersion);
            int templateEncodingMajorVersion = templateEncodingVersion != null ? templateEncodingVersion.getMajorVersion() : 0;
            double factorX = templateEncodingMajorVersion < 1 ? 1.5 : 1.0;
            double factorY = templateEncodingMajorVersion < 1 ? 1.34 : 1.0;
            org.apache.nifi.util.SnippetUtils.moveAndScaleSnippet((FlowSnippetDTO)snippet, (Double)originX, (Double)originY, (double)factorX, (double)factorY);
            List childProcessGroups = org.apache.nifi.util.SnippetUtils.findAllProcessGroups((FlowSnippetDTO)snippet);
            childProcessGroups.forEach(processGroup -> org.apache.nifi.util.SnippetUtils.scaleSnippet((FlowSnippetDTO)processGroup.getContents(), (double)factorX, (double)factorY));
            this.flowController.getFlowManager().instantiateSnippet(group, snippet);
            return snippet;
        }
        catch (ProcessorInstantiationException pie) {
            throw new NiFiCoreException(String.format("Unable to instantiate template because processor type '%s' is unknown to this NiFi.", StringUtils.substringAfterLast((String)pie.getMessage(), (String)".")));
        }
    }

    public void deleteTemplate(String templateId) {
        Template template = this.locateTemplate(templateId);
        template.getProcessGroup().removeTemplate(template);
    }

    public Template getTemplate(String templateId) {
        return this.locateTemplate(templateId);
    }

    public Set<Template> getTemplates() {
        HashSet<Template> templates = new HashSet<Template>();
        templates.addAll(this.flowController.getFlowManager().getRootGroup().findAllTemplates());
        return templates;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setSnippetUtils(SnippetUtils snippetUtils) {
        this.snippetUtils = snippetUtils;
    }
}

