/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.metrics.jmx;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.api.dto.JmxMetricsResultDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMetricsFilter.class);
    private static final String MATCH_NOTHING = "~^";
    private static final String NAME_SEPARATOR = "\\|";
    private static final String REPLACE_CHARACTERS = "[\\^$.*()]";
    private static final String EMPTY = "";
    private final Pattern allowedNameFilter;
    private final Set<String> beanNameFilters;

    public JmxMetricsFilter(String allowedNameFilter, String beanNameFilter) {
        this.allowedNameFilter = this.createPattern(allowedNameFilter);
        this.beanNameFilters = this.createBeanNameFilters(beanNameFilter);
    }

    private Pattern createPattern(String filter) {
        try {
            if (filter == null || filter.isEmpty()) {
                return Pattern.compile(MATCH_NOTHING);
            }
            return Pattern.compile(filter);
        }
        catch (PatternSyntaxException e) {
            LOGGER.warn("Invalid JMX MBean filter pattern ignored [{}]", (Object)filter);
            return Pattern.compile(MATCH_NOTHING);
        }
    }

    private Set<String> createBeanNameFilters(String filter) {
        if (filter == null || filter.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(filter.split(NAME_SEPARATOR)).map(name -> name.replaceAll(REPLACE_CHARACTERS, EMPTY)).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public Collection<JmxMetricsResultDTO> filter(Collection<JmxMetricsResultDTO> results) {
        return results.stream().filter((? super T result) -> this.allowedNameFilter.asPredicate().test(result.getBeanName())).filter((? super T result) -> {
            boolean included;
            if (this.beanNameFilters.isEmpty()) {
                included = true;
            } else {
                String beanName = result.getBeanName();
                included = this.beanNameFilters.stream().anyMatch(beanName::contains);
            }
            return included;
        }).collect(Collectors.toList());
    }
}

