/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.api.metrics.FilteringMetricFamilySamplesEnumeration;
import org.apache.nifi.web.api.metrics.PrometheusMetricsWriter;

public abstract class AbstractPrometheusMetricsWriter
implements PrometheusMetricsWriter {
    private final Pattern sampleNamePattern;
    private final Pattern sampleLabelValuePattern;
    private final boolean filteringDisabled;

    public AbstractPrometheusMetricsWriter(String sampleName, String sampleLabelValue) {
        this.sampleNamePattern = StringUtils.isBlank((CharSequence)sampleName) ? null : Pattern.compile(sampleName);
        this.sampleLabelValuePattern = StringUtils.isBlank((CharSequence)sampleLabelValue) ? null : Pattern.compile(sampleLabelValue);
        this.filteringDisabled = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{sampleName, sampleLabelValue});
    }

    Enumeration<Collector.MetricFamilySamples> getSamples(CollectorRegistry registry) {
        Enumeration samples = registry.metricFamilySamples();
        return this.filteringDisabled ? samples : new FilteringMetricFamilySamplesEnumeration(samples, this.sampleNamePattern, this.sampleLabelValuePattern);
    }
}

