/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/labels")
@Api(value="/labels", description="Endpoint for managing a Label.")
public class LabelResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<LabelEntity> populateRemainingLabelEntitiesContent(Set<LabelEntity> labelEntities) {
        for (LabelEntity labelEntity : labelEntities) {
            this.populateRemainingLabelEntityContent(labelEntity);
        }
        return labelEntities;
    }

    public LabelEntity populateRemainingLabelEntityContent(LabelEntity labelEntity) {
        labelEntity.setUri(this.generateResourceUri(new String[]{"labels", labelEntity.getId()}));
        return labelEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a label", response=LabelEntity.class, authorizations={@Authorization(value="Read - /labels/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getLabel(@ApiParam(value="The label id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable label = lookup.getLabel(id);
            label.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        LabelEntity entity = this.serviceFacade.getLabel(id);
        this.populateRemainingLabelEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a label", response=LabelEntity.class, authorizations={@Authorization(value="Write - /labels/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateLabel(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The label id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The label configuration details.", required=true) LabelEntity requestLabelEntity) {
        if (requestLabelEntity == null || requestLabelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Label details must be specified.");
        }
        if (requestLabelEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        LabelDTO requestLabelDTO = requestLabelEntity.getComponent();
        if (!id.equals(requestLabelDTO.getId())) {
            throw new IllegalArgumentException(String.format("The label id (%s) in the request body does not equal the label id of the requested resource (%s).", requestLabelDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestLabelDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestLabelEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestLabelEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestLabelEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestLabelEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getLabel(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, labelEntity) -> {
            LabelDTO labelDTO = labelEntity.getComponent();
            LabelEntity entity = this.serviceFacade.updateLabel(revision, labelDTO);
            this.populateRemainingLabelEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a label", response=LabelEntity.class, authorizations={@Authorization(value="Write - /labels/{uuid}"), @Authorization(value="Write - Parent Process Group - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeLabel(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The label id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        LabelEntity requestLabelEntity = new LabelEntity();
        requestLabelEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestLabelEntity, requestRevision, lookup -> {
            Authorizable label = lookup.getLabel(id);
            label.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            label.getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, labelEntity) -> {
            LabelEntity entity = this.serviceFacade.deleteLabel(revision, labelEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

