/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.dao.UserGroupDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class UserGroupAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(UserGroupAuditor.class);
    private static final String NAME = "Name";
    private static final String USERS = "Users";

    @Around(value="within(org.apache.nifi.web.dao.UserGroupDAO+) && execution(org.apache.nifi.authorization.Group createUserGroup(org.apache.nifi.web.api.dto.UserGroupDTO))")
    public Group createUserGroupAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Group userGroup = (Group)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(userGroup, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return userGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.UserGroupDAO+) && execution(org.apache.nifi.authorization.Group updateUserGroup(org.apache.nifi.web.api.dto.UserGroupDTO)) && args(userGroupDTO) && target(userGroupDAO)")
    public Group updateUserAdvice(ProceedingJoinPoint proceedingJoinPoint, UserGroupDTO userGroupDTO, UserGroupDAO userGroupDAO) throws Throwable {
        Group user = userGroupDAO.getUserGroup(userGroupDTO.getId());
        Map values = this.extractConfiguredPropertyValues(user, userGroupDTO);
        Group updatedUserGroup = (Group)proceedingJoinPoint.proceed();
        user = userGroupDAO.getUserGroup(updatedUserGroup.getIdentifier());
        NiFiUser niFiUser = NiFiUserUtils.getNiFiUser();
        if (niFiUser != null) {
            Map updatedValues = this.extractConfiguredPropertyValues(user, userGroupDTO);
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(niFiUser.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(user.getIdentifier());
                configurationAction.setSourceName(user.getName());
                configurationAction.setSourceType(Component.UserGroup);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedUserGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.UserGroupDAO+) && execution(org.apache.nifi.authorization.Group deleteUserGroup(java.lang.String)) && args(userGroupId) && target(userGroupDAO)")
    public Group removeUserAdvice(ProceedingJoinPoint proceedingJoinPoint, String userGroupId, UserGroupDAO userGroupDAO) throws Throwable {
        Group userGroup = userGroupDAO.getUserGroup(userGroupId);
        Group removedUserGroup = (Group)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(userGroup, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return removedUserGroup;
    }

    public Action generateAuditRecord(Group userGroup, Operation operation) {
        return this.generateAuditRecord(userGroup, operation, null);
    }

    public Action generateAuditRecord(Group userGroup, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser niFiUser = NiFiUserUtils.getNiFiUser();
        if (niFiUser != null) {
            action = new FlowChangeAction();
            action.setUserIdentity(niFiUser.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(userGroup.getIdentifier());
            action.setSourceName(userGroup.getName());
            action.setSourceType(Component.UserGroup);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Map<String, String> extractConfiguredPropertyValues(Group group, UserGroupDTO userGroupDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (userGroupDTO.getIdentity() != null) {
            values.put(NAME, group.getName());
        }
        if (userGroupDTO.getUsers() != null) {
            ArrayList currentUsers = new ArrayList(group.getUsers());
            Collections.sort(currentUsers, Collator.getInstance(Locale.US));
            values.put(USERS, StringUtils.join(currentUsers, (String)", "));
        }
        return values;
    }
}

