/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.dao.ParameterProviderDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ParameterProviderAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ParameterProviderAuditor.class);
    private static final String NAME = "Name";
    private static final String ANNOTATION_DATA = "Annotation Data";
    private static final String EXTENSION_VERSION = "Extension Version";

    @Around(value="within(org.apache.nifi.web.dao.ParameterProviderDAO+) && execution(org.apache.nifi.controller.ParameterProviderNode createParameterProvider(org.apache.nifi.web.api.dto.ParameterProviderDTO))")
    public ParameterProviderNode createParameterProviderAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ParameterProviderNode parameterProvider = (ParameterProviderNode)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(parameterProvider, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return parameterProvider;
    }

    @Around(value="within(org.apache.nifi.web.dao.ParameterProviderDAO+) && execution(org.apache.nifi.controller.ParameterProviderNode updateParameterProvider(org.apache.nifi.web.api.dto.ParameterProviderDTO)) && args(parameterProviderDTO) && target(parameterProviderDAO)")
    public Object updateParameterProviderAdvice(ProceedingJoinPoint proceedingJoinPoint, ParameterProviderDTO parameterProviderDTO, ParameterProviderDAO parameterProviderDAO) throws Throwable {
        ParameterProviderNode parameterProvider = parameterProviderDAO.getParameterProvider(parameterProviderDTO.getId());
        Map values = this.extractConfiguredPropertyValues(parameterProvider, parameterProviderDTO);
        ParameterProviderNode updatedParameterProvider = (ParameterProviderNode)proceedingJoinPoint.proceed();
        parameterProvider = parameterProviderDAO.getParameterProvider(updatedParameterProvider.getIdentifier());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            Map updatedValues = this.extractConfiguredPropertyValues(parameterProvider, parameterProviderDTO);
            FlowChangeExtensionDetails providerDetails = new FlowChangeExtensionDetails();
            providerDetails.setType(parameterProvider.getComponentType());
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                PropertyDescriptor propertyDescriptor = parameterProvider.getParameterProvider().getPropertyDescriptor(property);
                if (propertyDescriptor != null && propertyDescriptor.isSensitive()) {
                    if (newValue != null) {
                        newValue = "********";
                    }
                    if (oldValue != null) {
                        oldValue = "********";
                    }
                } else if (ANNOTATION_DATA.equals(property)) {
                    if (newValue != null) {
                        newValue = "<annotation data not shown>";
                    }
                    if (oldValue != null) {
                        oldValue = "<annotation data not shown>";
                    }
                }
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(parameterProvider.getIdentifier());
                configurationAction.setSourceName(parameterProvider.getName());
                configurationAction.setSourceType(Component.ParameterProvider);
                configurationAction.setComponentDetails((ComponentDetails)providerDetails);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedParameterProvider;
    }

    @Around(value="within(org.apache.nifi.web.dao.ParameterProviderDAO+) && execution(void deleteParameterProvider(java.lang.String)) && args(parameterProviderId) && target(parameterProviderDAO)")
    public void removeParameterProviderAdvice(ProceedingJoinPoint proceedingJoinPoint, String parameterProviderId, ParameterProviderDAO parameterProviderDAO) throws Throwable {
        ParameterProviderNode parameterProvider = parameterProviderDAO.getParameterProvider(parameterProviderId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(parameterProvider, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(ParameterProviderNode parameterProvider, Operation operation) {
        return this.generateAuditRecord(parameterProvider, operation, null);
    }

    public Action generateAuditRecord(ParameterProviderNode parameterProvider, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeExtensionDetails taskDetails = new FlowChangeExtensionDetails();
            taskDetails.setType(parameterProvider.getComponentType());
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(parameterProvider.getIdentifier());
            action.setSourceName(parameterProvider.getName());
            action.setSourceType(Component.ParameterProvider);
            action.setComponentDetails((ComponentDetails)taskDetails);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Map<String, String> extractConfiguredPropertyValues(ParameterProviderNode parameterProvider, ParameterProviderDTO parameterProviderDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (parameterProviderDTO.getName() != null) {
            values.put(NAME, parameterProvider.getName());
        }
        if (parameterProviderDTO.getAnnotationData() != null) {
            values.put(ANNOTATION_DATA, parameterProvider.getAnnotationData());
        }
        if (parameterProviderDTO.getBundle() != null) {
            BundleCoordinate bundle = parameterProvider.getBundleCoordinate();
            values.put(EXTENSION_VERSION, this.formatExtensionVersion(parameterProvider.getComponentType(), bundle));
        }
        if (parameterProviderDTO.getProperties() != null) {
            Map properties = parameterProviderDTO.getProperties();
            Map configuredProperties = parameterProvider.getRawPropertyValues();
            for (String propertyName : properties.keySet()) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor.Builder().name(propertyName).build();
                String configuredPropertyValue = (String)configuredProperties.get(propertyDescriptor);
                if (configuredPropertyValue == null) {
                    propertyDescriptor = this.locatePropertyDescriptor(configuredProperties.keySet(), propertyDescriptor);
                    configuredPropertyValue = propertyDescriptor.getDefaultValue();
                }
                values.put(propertyName, configuredPropertyValue);
            }
        }
        return values;
    }

    private PropertyDescriptor locatePropertyDescriptor(Set<PropertyDescriptor> propertyDescriptors, PropertyDescriptor specDescriptor) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.equals((Object)specDescriptor)) continue;
            return propertyDescriptor;
        }
        return specDescriptor;
    }
}

