/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.metrics;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.nifi.web.api.metrics.AbstractPrometheusMetricsWriter;

public class JsonFormatPrometheusMetricsWriter
extends AbstractPrometheusMetricsWriter {
    private final String rootFieldName;

    public JsonFormatPrometheusMetricsWriter(String sampleName, String sampleLabelValue, String rootFieldName) {
        super(sampleName, sampleLabelValue);
        this.rootFieldName = rootFieldName == null ? "samples" : rootFieldName;
    }

    public void write(Collection<CollectorRegistry> registries, OutputStream outputStream) throws IOException {
        JsonFactory factory = new JsonFactory();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
             JsonGenerator generator = factory.createGenerator((Writer)writer);){
            generator.setCodec((ObjectCodec)new ObjectMapper());
            generator.writeStartObject();
            generator.writeFieldName(this.rootFieldName);
            generator.writeStartArray();
            for (CollectorRegistry collectorRegistry : registries) {
                Enumeration samples = this.getSamples(collectorRegistry);
                while (samples.hasMoreElements()) {
                    Collector.MetricFamilySamples samples2 = (Collector.MetricFamilySamples)samples.nextElement();
                    for (Collector.MetricFamilySamples.Sample sample : samples2.samples) {
                        generator.writeObject((Object)sample);
                        generator.flush();
                    }
                    generator.flush();
                }
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.flush();
        }
    }
}

