/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.util.List;
import javax.servlet.Filter;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.StandardAuthenticationEntryPoint;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationFilter;
import org.apache.nifi.web.security.csrf.CsrfCookieRequestMatcher;
import org.apache.nifi.web.security.csrf.SkipReplicatedCsrfFilter;
import org.apache.nifi.web.security.csrf.StandardCookieCsrfTokenRepository;
import org.apache.nifi.web.security.knox.KnoxAuthenticationFilter;
import org.apache.nifi.web.security.log.AuthenticationUserFilter;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2LocalLogoutFilter;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2SingleLogoutFilter;
import org.apache.nifi.web.security.x509.X509AuthenticationFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationFilter;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2WebSsoAuthenticationRequestFilter;
import org.springframework.security.saml2.provider.service.web.Saml2MetadataFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class NiFiWebApiSecurityConfiguration {
    @Bean
    public AuthenticationManager authenticationManager(List<AuthenticationProvider> authenticationProviders) {
        return new ProviderManager(authenticationProviders);
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, NiFiProperties properties, StandardAuthenticationEntryPoint authenticationEntryPoint, X509AuthenticationFilter x509AuthenticationFilter, BearerTokenAuthenticationFilter bearerTokenAuthenticationFilter, KnoxAuthenticationFilter knoxAuthenticationFilter, NiFiAnonymousAuthenticationFilter anonymousAuthenticationFilter, Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter, Saml2WebSsoAuthenticationRequestFilter saml2WebSsoAuthenticationRequestFilter, Saml2MetadataFilter saml2MetadataFilter, Saml2LogoutRequestFilter saml2LogoutRequestFilter, Saml2LogoutResponseFilter saml2LogoutResponseFilter, Saml2SingleLogoutFilter saml2SingleLogoutFilter, Saml2LocalLogoutFilter saml2LocalLogoutFilter) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.logout().disable()).anonymous().disable()).requestCache().disable()).rememberMe().disable()).sessionManagement().disable()).headers().disable()).servletApi().disable()).securityContext().disable()).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.antMatchers(new String[]{"/access", "/access/config", "/access/token", "/access/kerberos", "/access/knox/callback", "/access/knox/request", "/access/logout/complete", "/access/oidc/exchange", "/access/oidc/request", "/access/oidc/callback", "/access/oidc/logoutCallback"})).permitAll().anyRequest()).authenticated()).addFilterBefore((Filter)new SkipReplicatedCsrfFilter(), CsrfFilter.class).csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)new StandardCookieCsrfTokenRepository()).requireCsrfProtectionMatcher((RequestMatcher)new AndRequestMatcher(new RequestMatcher[]{CsrfFilter.DEFAULT_CSRF_MATCHER, new CsrfCookieRequestMatcher()}))).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)authenticationEntryPoint)).addFilterBefore((Filter)x509AuthenticationFilter, AnonymousAuthenticationFilter.class).addFilterBefore((Filter)bearerTokenAuthenticationFilter, AnonymousAuthenticationFilter.class).addFilterBefore((Filter)new AuthenticationUserFilter(), ExceptionTranslationFilter.class);
        if (properties.isKnoxSsoEnabled()) {
            http.addFilterBefore((Filter)knoxAuthenticationFilter, AnonymousAuthenticationFilter.class);
        }
        if (properties.isAnonymousAuthenticationAllowed().booleanValue() || properties.isHttpEnabled()) {
            http.addFilterAfter((Filter)anonymousAuthenticationFilter, AnonymousAuthenticationFilter.class);
        }
        if (properties.isSamlEnabled()) {
            http.addFilterBefore((Filter)saml2WebSsoAuthenticationFilter, AnonymousAuthenticationFilter.class);
            http.addFilterBefore((Filter)saml2WebSsoAuthenticationRequestFilter, AnonymousAuthenticationFilter.class);
            http.addFilterBefore((Filter)saml2MetadataFilter, CsrfFilter.class);
            http.addFilterBefore((Filter)saml2LocalLogoutFilter, CsrfFilter.class);
            if (properties.isSamlSingleLogoutEnabled()) {
                http.addFilterBefore((Filter)saml2SingleLogoutFilter, CsrfFilter.class);
                http.addFilterBefore((Filter)saml2LogoutRequestFilter, CsrfFilter.class);
                http.addFilterBefore((Filter)saml2LogoutResponseFilter, CsrfFilter.class);
            }
        }
        return (SecurityFilterChain)http.build();
    }
}

