/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.dao.SnippetDAO;
import org.apache.nifi.web.util.SnippetUtils;

public class StandardSnippetDAO
implements SnippetDAO {
    private FlowController flowController;
    private SnippetUtils snippetUtils;

    private StandardSnippet locateSnippet(String snippetId) {
        StandardSnippet snippet = this.flowController.getSnippetManager().getSnippet(snippetId);
        if (snippet == null) {
            throw new ResourceNotFoundException(String.format("Unable to find snippet with id '%s'.", snippetId));
        }
        return snippet;
    }

    public FlowSnippetDTO copySnippet(String groupId, String snippetId, Double originX, Double originY, String idGenerationSeed) {
        try {
            ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(groupId);
            if (processGroup == null) {
                throw new IllegalArgumentException("The specified parent process group could not be found");
            }
            Snippet existingSnippet = this.getSnippet(snippetId);
            ProcessGroup existingSnippetProcessGroup = this.flowController.getFlowManager().getGroup(existingSnippet.getParentGroupId());
            if (existingSnippetProcessGroup == null) {
                throw new IllegalStateException("The parent process group for the existing snippet could not be found.");
            }
            FlowSnippetDTO snippetContents = this.snippetUtils.populateFlowSnippet(existingSnippet, true, false, false);
            this.lookupSensitiveProperties(snippetContents);
            snippetContents = this.snippetUtils.copy(snippetContents, processGroup, idGenerationSeed, true);
            if (originX != null && originY != null) {
                org.apache.nifi.util.SnippetUtils.moveSnippet((FlowSnippetDTO)snippetContents, (Double)originX, (Double)originY);
            }
            try {
                this.flowController.getFlowManager().instantiateSnippet(processGroup, snippetContents);
                return snippetContents;
            }
            catch (IllegalStateException ise) {
                this.snippetUtils.rollbackClonedPolicies(snippetContents);
                throw ise;
            }
        }
        catch (ProcessorInstantiationException pie) {
            throw new NiFiCoreException(String.format("Unable to copy snippet because processor type '%s' is unknown to this NiFi.", StringUtils.substringAfterLast((String)pie.getMessage(), (String)".")));
        }
    }

    private Map<String, Revision> mapDtoToRevision(Map<String, RevisionDTO> revisionMap) {
        HashMap<String, Revision> revisions = new HashMap<String, Revision>(revisionMap.size());
        for (Map.Entry<String, RevisionDTO> entry : revisionMap.entrySet()) {
            RevisionDTO revisionDto = entry.getValue();
            Revision revision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), entry.getKey());
            revisions.put(entry.getKey(), revision);
        }
        return revisions;
    }

    public Snippet createSnippet(SnippetDTO snippetDTO) {
        StandardSnippet snippet = new StandardSnippet();
        snippet.setId(snippetDTO.getId());
        snippet.setParentGroupId(snippetDTO.getParentGroupId());
        snippet.addProcessors(this.mapDtoToRevision(snippetDTO.getProcessors()));
        snippet.addProcessGroups(this.mapDtoToRevision(snippetDTO.getProcessGroups()));
        snippet.addRemoteProcessGroups(this.mapDtoToRevision(snippetDTO.getRemoteProcessGroups()));
        snippet.addInputPorts(this.mapDtoToRevision(snippetDTO.getInputPorts()));
        snippet.addOutputPorts(this.mapDtoToRevision(snippetDTO.getOutputPorts()));
        snippet.addConnections(this.mapDtoToRevision(snippetDTO.getConnections()));
        snippet.addLabels(this.mapDtoToRevision(snippetDTO.getLabels()));
        snippet.addFunnels(this.mapDtoToRevision(snippetDTO.getFunnels()));
        if (snippet.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an empty snippet.");
        }
        ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(snippet.getParentGroupId());
        if (processGroup == null) {
            throw new IllegalArgumentException("The specified parent process group could not be found.");
        }
        this.flowController.getSnippetManager().addSnippet(snippet);
        return snippet;
    }

    public void verifyDeleteSnippetComponents(String snippetId) {
        StandardSnippet snippet = this.locateSnippet(snippetId);
        ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(snippet.getParentGroupId());
        if (processGroup == null) {
            throw new IllegalArgumentException("The specified parent process group could not be found.");
        }
        processGroup.verifyCanDelete((Snippet)snippet);
    }

    public void deleteSnippetComponents(String snippetId) {
        this.verifyDeleteSnippetComponents(snippetId);
        StandardSnippet snippet = this.locateSnippet(snippetId);
        ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(snippet.getParentGroupId());
        if (processGroup == null) {
            throw new IllegalArgumentException("The specified parent process group could not be found.");
        }
        processGroup.remove((Snippet)snippet);
    }

    public Snippet getSnippet(String snippetId) {
        return this.locateSnippet(snippetId);
    }

    public boolean hasSnippet(String snippetId) {
        return this.flowController.getSnippetManager().getSnippet(snippetId) != null;
    }

    public void dropSnippet(String snippetId) {
        StandardSnippet snippet = this.locateSnippet(snippetId);
        this.flowController.getSnippetManager().removeSnippet(snippet);
    }

    public void verifyUpdateSnippetComponent(SnippetDTO snippetDTO) {
        StandardSnippet snippet = this.locateSnippet(snippetDTO.getId());
        if (snippetDTO.getParentGroupId() != null && !snippet.getParentGroupId().equals(snippetDTO.getParentGroupId())) {
            ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(snippet.getParentGroupId());
            if (processGroup == null) {
                throw new IllegalArgumentException("The specified parent process group could not be found.");
            }
            ProcessGroup newProcessGroup = this.flowController.getFlowManager().getGroup(snippetDTO.getParentGroupId());
            if (newProcessGroup == null) {
                throw new IllegalArgumentException("The new process group could not be found.");
            }
            processGroup.verifyCanMove((Snippet)snippet, newProcessGroup);
        }
    }

    public Snippet updateSnippetComponents(SnippetDTO snippetDTO) {
        this.verifyUpdateSnippetComponent(snippetDTO);
        StandardSnippet snippet = this.locateSnippet(snippetDTO.getId());
        if (snippetDTO.getParentGroupId() != null && !snippet.getParentGroupId().equals(snippetDTO.getParentGroupId())) {
            ProcessGroup currentProcessGroup = this.flowController.getFlowManager().getGroup(snippet.getParentGroupId());
            if (currentProcessGroup == null) {
                throw new IllegalArgumentException("The current process group could not be found.");
            }
            ProcessGroup newProcessGroup = this.flowController.getFlowManager().getGroup(snippetDTO.getParentGroupId());
            if (newProcessGroup == null) {
                throw new IllegalArgumentException("The new process group could not be found.");
            }
            currentProcessGroup.move((Snippet)snippet, newProcessGroup);
            snippet.setParentGroupId(snippetDTO.getParentGroupId());
        }
        return snippet;
    }

    private void lookupSensitiveProperties(FlowSnippetDTO snippet) {
        if (snippet != null) {
            if (snippet.getProcessors() != null) {
                this.lookupSensitiveProcessorProperties(snippet.getProcessors());
            }
            if (snippet.getControllerServices() != null) {
                this.lookupSensitiveControllerServiceProperties(snippet.getControllerServices());
            }
            if (snippet.getProcessGroups() != null) {
                for (ProcessGroupDTO group : snippet.getProcessGroups()) {
                    this.lookupSensitiveProperties(group.getContents());
                }
            }
        }
    }

    private void lookupSensitiveProcessorProperties(Set<ProcessorDTO> processors) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        for (ProcessorDTO processorDTO : processors) {
            ProcessorConfigDTO processorConfig = processorDTO.getConfig();
            if (processorConfig == null || processorConfig.getProperties() == null) continue;
            Map processorProperties = processorConfig.getProperties();
            ProcessorNode processorNode = rootGroup.findProcessor(processorDTO.getId());
            if (processorNode == null) {
                throw new IllegalArgumentException(String.format("Unable to create snippet because Processor '%s' could not be found", processorDTO.getId()));
            }
            LinkedHashSet<String> sensitiveDynamicPropertyNames = new LinkedHashSet<String>();
            processorConfig.setSensitiveDynamicPropertyNames(sensitiveDynamicPropertyNames);
            for (Map.Entry entry : processorNode.getRawPropertyValues().entrySet()) {
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                if (!descriptor.isSensitive()) continue;
                processorProperties.put(descriptor.getName(), (String)entry.getValue());
                if (!descriptor.isDynamic()) continue;
                sensitiveDynamicPropertyNames.add(descriptor.getName());
            }
        }
    }

    private void lookupSensitiveControllerServiceProperties(Set<ControllerServiceDTO> controllerServices) {
        for (ControllerServiceDTO serviceDTO : controllerServices) {
            Map serviceProperties = serviceDTO.getProperties();
            if (serviceProperties == null) continue;
            ControllerServiceNode serviceNode = this.flowController.getFlowManager().getControllerServiceNode(serviceDTO.getId());
            if (serviceNode == null) {
                throw new IllegalArgumentException(String.format("Unable to create snippet because Controller Service '%s' could not be found", serviceDTO.getId()));
            }
            LinkedHashSet sensitiveDynamicPropertyNames = new LinkedHashSet();
            serviceDTO.setSensitiveDynamicPropertyNames(sensitiveDynamicPropertyNames);
            this.putSensitiveProperties(serviceNode.getRawPropertyValues(), serviceProperties, sensitiveDynamicPropertyNames);
        }
    }

    private void putSensitiveProperties(Map<PropertyDescriptor, String> componentPropertyValues, Map<String, String> componentProperties, Set<String> sensitiveDynamicPropertyNames) {
        for (Map.Entry<PropertyDescriptor, String> entry : componentPropertyValues.entrySet()) {
            PropertyDescriptor descriptor = entry.getKey();
            if (!descriptor.isSensitive()) continue;
            componentProperties.put(descriptor.getName(), entry.getValue());
            if (!descriptor.isDynamic()) continue;
            sensitiveDynamicPropertyNames.add(descriptor.getName());
        }
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setSnippetUtils(SnippetUtils snippetUtils) {
        this.snippetUtils = snippetUtils;
    }
}

