/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ui.extension;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.ui.extension.UiExtension;

public class UiExtensionMapping {
    private final Map<String, List<UiExtension>> uiExtensions = new ConcurrentHashMap<String, List<UiExtension>>();

    public UiExtensionMapping(Map<String, List<UiExtension>> uiExtensions) {
        this.uiExtensions.putAll(uiExtensions);
    }

    private String getBundleSpecificKey(String type, String bundleGroup, String bundleArtifact, String bundleVersion) {
        return type + ":" + bundleGroup + ":" + bundleArtifact + ":" + bundleVersion;
    }

    public boolean hasUiExtension(String type, String bundleGroup, String bundleArtifact, String bundleVersion) {
        String bundleSpecificKey = this.getBundleSpecificKey(type, bundleGroup, bundleArtifact, bundleVersion);
        if (this.uiExtensions.containsKey(bundleSpecificKey)) {
            return true;
        }
        return this.uiExtensions.containsKey(type);
    }

    public List<UiExtension> getUiExtension(String type, String bundleGroup, String bundleArtifact, String bundleVersion) {
        String bundleSpecificKey = this.getBundleSpecificKey(type, bundleGroup, bundleArtifact, bundleVersion);
        if (this.uiExtensions.containsKey(bundleSpecificKey)) {
            return this.uiExtensions.get(bundleSpecificKey);
        }
        return this.uiExtensions.get(type);
    }

    public void addUiExtensions(Map<String, List<UiExtension>> uiExtensions) {
        this.uiExtensions.putAll(uiExtensions);
    }
}

