/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.stateless.retrieval;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.stateless.ExecuteStateless;
import org.apache.nifi.processors.stateless.retrieval.DataflowProvider;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.impl.JerseyNiFiRegistryClient;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.ssl.SSLContextService;

public class RegistryDataflowProvider
implements DataflowProvider {
    private final ComponentLog logger;

    public RegistryDataflowProvider(ComponentLog logger) {
        this.logger = logger;
    }

    @Override
    public VersionedFlowSnapshot retrieveDataflowContents(ProcessContext context) throws IOException {
        VersionedFlowSnapshot versionedFlowSnapshot;
        SSLContextService sslContextService = (SSLContextService)context.getProperty(ExecuteStateless.SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        SSLContext sslContext = sslContextService == null ? null : sslContextService.createContext();
        String url = context.getProperty(ExecuteStateless.REGISTRY_URL).getValue();
        NiFiRegistryClientConfig clientConfig = new NiFiRegistryClientConfig.Builder().baseUrl(url).connectTimeout(Integer.valueOf(context.getProperty(ExecuteStateless.COMMS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue())).readTimeout(Integer.valueOf(context.getProperty(ExecuteStateless.COMMS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue())).sslContext(sslContext).build();
        NiFiRegistryClient client = new JerseyNiFiRegistryClient.Builder().config(clientConfig).build();
        String bucketName = context.getProperty(ExecuteStateless.BUCKET).getValue();
        String flowName = context.getProperty(ExecuteStateless.FLOW_NAME).getValue();
        Integer flowVersion = context.getProperty(ExecuteStateless.FLOW_VERSION).asInteger();
        try {
            String bucketId = this.getBucketId(client, bucketName);
            String flowId = this.getFlowId(client, flowName, bucketId);
            this.logger.debug("Attempting to fetch dataflow from Registry at URL {}, Bucket {}, Flow {}, flowVersion {}", new Object[]{url, bucketId, flowId, flowVersion == null ? "<Latest>" : flowVersion});
            versionedFlowSnapshot = flowVersion == null ? client.getFlowSnapshotClient().getLatest(bucketId, flowId) : client.getFlowSnapshotClient().get(bucketId, flowId, flowVersion.intValue());
            this.logger.debug("Successfully fetched dataflow from Registry at URL {}, Bucket {}, Flow {}, flowVersion {}", new Object[]{url, bucketId, flowId, flowVersion == null ? "<Latest>" : flowVersion});
        }
        catch (NiFiRegistryException e) {
            throw new IOException("Failed to retrieve Flow Snapshot from Registry", e);
        }
        return versionedFlowSnapshot;
    }

    private String getFlowId(NiFiRegistryClient client, String flowName, String bucketId) throws IOException {
        List versionedFlows;
        try {
            versionedFlows = client.getFlowClient().getByBucket(bucketId);
        }
        catch (NiFiRegistryException e) {
            throw new IOException("Could not retrieve list of Flows from NiFi Registry for Bucket ID " + bucketId);
        }
        for (VersionedFlow versionedFlow : versionedFlows) {
            if (!flowName.equals(versionedFlow.getName())) continue;
            return versionedFlow.getIdentifier();
        }
        throw new IOException("Could not find a flow with the name '" + flowName + "' within bucket with ID '" + bucketId + "' in the given Registry");
    }

    private String getBucketId(NiFiRegistryClient client, String bucketName) throws IOException {
        try {
            List allBuckets = client.getBucketClient().getAll();
            Optional<Bucket> optionalBucket = allBuckets.stream().filter(bkt -> bkt.getName().equals(bucketName)).findAny();
            if (!optionalBucket.isPresent()) {
                throw new IOException("Could not find a bucket with the name '" + bucketName + "' in the given Registry");
            }
            return optionalBucket.get().getIdentifier();
        }
        catch (NiFiRegistryException e) {
            throw new IOException("Failed to fetch buckets from NiFi Registry", e);
        }
    }
}

