/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.stateless;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.stateless.retrieval.CachingDataflowProvider;
import org.apache.nifi.processors.stateless.retrieval.DataflowProvider;
import org.apache.nifi.processors.stateless.retrieval.FileSystemDataflowProvider;
import org.apache.nifi.processors.stateless.retrieval.RegistryDataflowProvider;
import org.apache.nifi.registry.VersionedFlowConverter;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.SearchResult;
import org.apache.nifi.search.Searchable;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stateless.bootstrap.StatelessBootstrap;
import org.apache.nifi.stateless.config.ExtensionClientDefinition;
import org.apache.nifi.stateless.config.ParameterContextDefinition;
import org.apache.nifi.stateless.config.ParameterValueProviderDefinition;
import org.apache.nifi.stateless.config.ReportingTaskDefinition;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.config.StatelessConfigurationException;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.DataflowTrigger;
import org.apache.nifi.stateless.flow.DataflowTriggerContext;
import org.apache.nifi.stateless.flow.FailurePortEncounteredException;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.flow.TransactionThresholds;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.apache.nifi.stream.io.StreamUtils;

@Restricted
@SupportsBatching
@SupportsSensitiveDynamicProperties
@SystemResourceConsiderations(value={@SystemResourceConsideration(resource=SystemResource.CPU), @SystemResourceConsideration(resource=SystemResource.DISK), @SystemResourceConsideration(resource=SystemResource.MEMORY), @SystemResourceConsideration(resource=SystemResource.NETWORK)})
@DynamicProperty(name="Any Parameter name", value="Any value", description="Any dynamic property that is added will be provided to the stateless flow as a Parameter. The name of the property will be the name of the Parameter, and the value of the property will be the value of the Parameter. Because Parameter values may or may not be sensitive, all dynamic properties will be considered sensitive in order to protect their integrity.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@CapabilityDescription(value="Runs the configured dataflow using the Stateless NiFi engine. Please see documentation in order to understand the differences between the traditional NiFi runtime engine and the Stateless NiFi engine. If the Processor is configured with an incoming connection, the incoming FlowFiles will be queued up into the specified Input Port in the dataflow. Data that is transferred out of the flow via an Output Port will be sent to the 'output' relationship, and an attribute will be added to indicate which Port that FlowFile was transferred to. See Additional Details for more information.")
@WritesAttributes(value={@WritesAttribute(attribute="output.port.name", description="The name of the Output Port that the FlowFile was transferred to"), @WritesAttribute(attribute="failure.port.name", description="If one or more FlowFiles is routed to one of the Output Ports that is configured as a Failure Port, the input FlowFile (if any) will have this attribute added to it, indicating the name of the Port that caused the dataflow to be considered a failure.")})
public class ExecuteStateless
extends AbstractProcessor
implements Searchable {
    public static final AllowableValue SPEC_FROM_FILE = new AllowableValue("Use Local File", "Use Local File or URL", "Dataflow to run is stored as a file on the NiFi server or at a URL that is accessible to the NiFi server");
    public static final AllowableValue SPEC_FROM_REGISTRY = new AllowableValue("Use NiFi Registry", "Use NiFi Registry", "Dataflow to run is stored in NiFi Registry");
    public static final AllowableValue CONTENT_STORAGE_HEAP = new AllowableValue("Store Content on Heap", "Store Content on Heap", "The FlowFile content will be stored on the NiFi JVM's heap. This is the most efficient option for small FlowFiles but can quickly exhaust the heap with larger FlowFiles, resulting in Out Of Memory Errors and node instability.");
    public static final AllowableValue CONTENT_STORAGE_DISK = new AllowableValue("Store Content on Disk", "Store Content on Disk", "The FlowFile content will be stored on disk, within the configured Work Directory. The content will still be cleared between invocations and will not be persisted across restarts.");
    public static final PropertyDescriptor DATAFLOW_SPECIFICATION_STRATEGY = new PropertyDescriptor.Builder().name("Dataflow Specification Strategy").displayName("Dataflow Specification Strategy").description("Specifies how the Processor should obtain a copy of the dataflow that it is to run").required(true).allowableValues(new AllowableValue[]{SPEC_FROM_FILE, SPEC_FROM_REGISTRY}).defaultValue(SPEC_FROM_FILE.getValue()).build();
    public static final PropertyDescriptor DATAFLOW_FILE = new PropertyDescriptor.Builder().name("Dataflow File").displayName("Dataflow File/URL").description("The filename or URL that specifies the dataflow that is to be run").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.URL}).dependsOn(DATAFLOW_SPECIFICATION_STRATEGY, new AllowableValue[]{SPEC_FROM_FILE}).build();
    public static final PropertyDescriptor REGISTRY_URL = new PropertyDescriptor.Builder().name("Registry URL").displayName("Registry URL").description("The URL of the NiFi Registry to retrieve the flow from").required(true).addValidator(StandardValidators.URL_VALIDATOR).dependsOn(DATAFLOW_SPECIFICATION_STRATEGY, new AllowableValue[]{SPEC_FROM_REGISTRY}).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("Registry SSL Context Service").displayName("Registry SSL Context Service").description("The SSL Context Service to use for interacting with the NiFi Registry").required(false).identifiesControllerService(SSLContextService.class).dependsOn(DATAFLOW_SPECIFICATION_STRATEGY, new AllowableValue[]{SPEC_FROM_REGISTRY}).build();
    public static final PropertyDescriptor COMMS_TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").displayName("Communications Timeout").description("Specifies how long to wait before timing out when attempting to communicate with NiFi Registry").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).dependsOn(DATAFLOW_SPECIFICATION_STRATEGY, new AllowableValue[]{SPEC_FROM_REGISTRY}).defaultValue("15 secs").build();
    public static final PropertyDescriptor BUCKET = new PropertyDescriptor.Builder().name("Registry Bucket").displayName("Registry Bucket").description("The name of the Bucket in the NiFi Registry that the flow should retrieved from").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(DATAFLOW_SPECIFICATION_STRATEGY, new AllowableValue[]{SPEC_FROM_REGISTRY}).build();
    public static final PropertyDescriptor FLOW_NAME = new PropertyDescriptor.Builder().name("Flow Name").displayName("Flow Name").description("The name of the flow in the NiFi Registry").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(DATAFLOW_SPECIFICATION_STRATEGY, new AllowableValue[]{SPEC_FROM_REGISTRY}).build();
    public static final PropertyDescriptor FLOW_VERSION = new PropertyDescriptor.Builder().name("Flow Version").displayName("Flow Version").description("The version of the flow in the NiFi Registry that should be retrieved. If not specified, the latest version will always be used.").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).dependsOn(DATAFLOW_SPECIFICATION_STRATEGY, new AllowableValue[]{SPEC_FROM_REGISTRY}).build();
    public static final PropertyDescriptor INPUT_PORT = new PropertyDescriptor.Builder().name("Input Port").displayName("Input Port").description("Specifies the name of the Input Port to send incoming FlowFiles to. This property is required if this processor has any incoming connections.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor FAILURE_PORTS = new PropertyDescriptor.Builder().name("Failure Ports").displayName("Failure Ports").description("A comma-separated list of the names of Output Ports that exist at the root level of the dataflow. If any FlowFile is routed to one of the Ports whose name is listed here, the dataflow will be considered a failure, and the incoming FlowFile (if any) will be routed to 'failure'. If not specified, all Output Ports will be considered successful.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor DATAFLOW_TIMEOUT = new PropertyDescriptor.Builder().name("Dataflow Timeout").displayName("Dataflow Timeout").description("If the flow does not complete within this amount of time, the incoming FlowFile, if any, will be routed to the timeout relationship,the dataflow will be cancelled, and the invocation will end.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("60 sec").build();
    public static final PropertyDescriptor LIB_DIRECTORY = new PropertyDescriptor.Builder().name("NAR Directory").displayName("NAR Directory").description("This directory has three roles: 1) it contains the NiFi Stateless NAR and other necessary libraries required for the Stateless engine to be bootstrapped, 2) it can contain extensions that should be loaded by the Stateless engine, 3) it is used by the Stateless engine to download extensions into.").required(true).addValidator(StandardValidators.createDirectoryExistsValidator((boolean)false, (boolean)false)).defaultValue("./lib").build();
    public static final PropertyDescriptor ADDITIONAL_LIB_DIRECTORIES = new PropertyDescriptor.Builder().name("additional-nar-directories").displayName("Additional NAR Directories").description("A comma-separated list of paths for directories that contain extensions that should be loaded by the stateless engine. The engine will not download any extensions into these directories or write to them but will read any NAR files that are found within these directories. The engine will not recurse into subdirectories of these directories.").required(false).addValidator(StandardValidators.createListValidator((boolean)true, (boolean)true, (Validator)StandardValidators.createDirectoryExistsValidator((boolean)false, (boolean)false))).build();
    public static final PropertyDescriptor WORKING_DIRECTORY = new PropertyDescriptor.Builder().name("Work Directory").displayName("Work Directory").description("A directory that can be used to create temporary files, such as expanding NAR files, temporary FlowFile content, caching the dataflow, etc.").required(true).addValidator(StandardValidators.createDirectoryExistsValidator((boolean)false, (boolean)true)).defaultValue("./work").build();
    public static final PropertyDescriptor KRB5_CONF = new PropertyDescriptor.Builder().name("Krb5 Conf File").displayName("Krb5 Conf File").description("The KRB5 Conf file to use for configuring components that rely on Kerberos").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).build();
    public static final PropertyDescriptor STATELESS_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("Stateless SSL Context Service").displayName("Stateless SSL Context Service").description("The SSL Context to use as the Stateless System SSL Context").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor MAX_INGEST_FLOWFILES = new PropertyDescriptor.Builder().name("Max Ingest FlowFiles").displayName("Max Ingest FlowFiles").description("During the course of a stateless dataflow, some processors may require more data than they have available in order to proceed. For example, MergeContent may require a minimum number of FlowFiles before it can proceed. In this case, the dataflow may bring in additional data from its source Processor. However, this data may all be held in memory, so this property provides a mechanism for limiting the maximum number of FlowFiles that the source Processor can ingest before it will no longer be triggered to ingest additional data.").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor MAX_INGEST_DATA_SIZE = new PropertyDescriptor.Builder().name("Max Ingest Data Size").displayName("Max Ingest Data Size").description("During the course of a stateless dataflow, some processors may require more data than they have available in order to proceed. For example, MergeContent may require a minimum number of FlowFiles before it can proceed. In this case, the dataflow may bring in additional data from its source Processor. However, this data may all be held in memory, so this property provides a mechanism for limiting the maximum amount of data that the source Processor can ingest before it will no longer be triggered to ingest additional data.").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor CONTENT_STORAGE_STRATEGY = new PropertyDescriptor.Builder().name("Content Storage Strategy").displayName("Content Storage Strategy").description("Specifies where the content of FlowFiles that the Stateless dataflow is operating on should be stored. Note that the data is always considered temporary and may be deleted at any time. It is not intended to be persisted across restarted.").required(true).allowableValues(new AllowableValue[]{CONTENT_STORAGE_HEAP, CONTENT_STORAGE_DISK}).defaultValue(CONTENT_STORAGE_DISK.getValue()).build();
    public static final PropertyDescriptor MAX_INPUT_FLOWFILE_SIZE = new PropertyDescriptor.Builder().name("Max Input FlowFile Size").displayName("Max Input FlowFile Size").description("This Processor is configured to load all incoming FlowFiles into memory. Because of that, it is important to limit the maximum size of any incoming FlowFile that would get loaded into memory, in order to prevent Out Of Memory Errors and excessive Garbage Collection. Any FlowFile whose content size is greater than the configured size will be routed to failure and not sent to the Stateless Engine.").required(true).dependsOn(CONTENT_STORAGE_STRATEGY, new AllowableValue[]{CONTENT_STORAGE_HEAP}).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).defaultValue("1 MB").build();
    public static final PropertyDescriptor STATUS_TASK_INTERVAL = new PropertyDescriptor.Builder().name("Status Task Interval").displayName("Status Task Interval").description("The Stateless engine periodically logs the status of the dataflow's processors.  This property allows the interval to be changed, or the status logging to be skipped altogether if the property is not set.").required(false).addValidator(StandardValidators.createTimePeriodValidator((long)10L, (TimeUnit)TimeUnit.SECONDS, (long)24L, (TimeUnit)TimeUnit.HOURS)).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("For any incoming FlowFile that is successfully processed, the original incoming FlowFile will be transferred to this Relationship").autoTerminateDefault(true).build();
    static final Relationship REL_OUTPUT = new Relationship.Builder().name("output").description("Any FlowFiles that are transferred to an Output Port in the configured dataflow will be routed to this Relationship").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If the dataflow fails to process an incoming FlowFile, that FlowFile will be routed to this relationship").build();
    static final Relationship REL_TIMEOUT = new Relationship.Builder().name("timeout").description("If the dataflow fails to complete in the configured amount of time, any incoming FlowFile will be routed to this relationship").build();
    private final BlockingQueue<StatelessDataflow> dataflows = new LinkedBlockingDeque<StatelessDataflow>();
    private final AtomicInteger dataflowCreationCount = new AtomicInteger(0);
    private volatile Set<String> failurePortNames;
    private volatile VersionedFlowSnapshot flowSnapshot;
    private volatile AbortableTriggerContext triggerContext;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(DATAFLOW_SPECIFICATION_STRATEGY, DATAFLOW_FILE, REGISTRY_URL, SSL_CONTEXT_SERVICE, COMMS_TIMEOUT, BUCKET, FLOW_NAME, FLOW_VERSION, INPUT_PORT, FAILURE_PORTS, CONTENT_STORAGE_STRATEGY, MAX_INPUT_FLOWFILE_SIZE, DATAFLOW_TIMEOUT, LIB_DIRECTORY, ADDITIONAL_LIB_DIRECTORIES, WORKING_DIRECTORY, MAX_INGEST_FLOWFILES, MAX_INGEST_DATA_SIZE, STATELESS_SSL_CONTEXT_SERVICE, KRB5_CONF, STATUS_TASK_INTERVAL);
    }

    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(Arrays.asList(REL_ORIGINAL, REL_OUTPUT, REL_FAILURE, REL_TIMEOUT));
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).defaultValue("Value for the " + propertyDescriptorName + " parameter").addValidator(Validator.VALID).dynamic(true).build();
    }

    @OnScheduled
    public void parseDataflow(ProcessContext context) throws IOException {
        String specificationStrategy = context.getProperty(DATAFLOW_SPECIFICATION_STRATEGY).getValue();
        DataflowProvider rawRetrieval = specificationStrategy.equalsIgnoreCase(SPEC_FROM_FILE.getValue()) ? new FileSystemDataflowProvider() : new RegistryDataflowProvider(this.getLogger());
        CachingDataflowProvider cachedRetrieval = new CachingDataflowProvider(this.getIdentifier(), this.getLogger(), rawRetrieval);
        long start = System.nanoTime();
        VersionedFlowSnapshot versionedFlowSnapshot = cachedRetrieval.retrieveDataflowContents(context);
        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        this.getLogger().info("Successfully retrieved flow in {} millis", new Object[]{millis});
        this.flowSnapshot = versionedFlowSnapshot;
        this.triggerContext = new AbortableTriggerContext();
        HashSet<String> failurePorts = new HashSet<String>();
        String failurePortNames = context.getProperty(FAILURE_PORTS).getValue();
        if (failurePortNames != null) {
            for (String portName : failurePortNames.split(",")) {
                failurePorts.add(portName.trim());
            }
        }
        this.failurePortNames = failurePorts;
    }

    @OnUnscheduled
    public void abortDataflow() {
        if (this.triggerContext != null) {
            this.triggerContext.abort();
        }
    }

    @OnStopped
    public void shutdown() {
        StatelessDataflow dataflow;
        while ((dataflow = (StatelessDataflow)this.dataflows.poll()) != null) {
            dataflow.shutdown();
        }
        this.dataflows.clear();
        this.dataflowCreationCount.set(0);
    }

    private StatelessDataflow createDataflow(ProcessContext context) throws IOException, StatelessConfigurationException {
        int dataflowIndex = this.dataflowCreationCount.getAndIncrement();
        StatelessEngineConfiguration engineConfiguration = this.createEngineConfiguration(context, dataflowIndex);
        StatelessBootstrap bootstrap = StatelessBootstrap.bootstrap((StatelessEngineConfiguration)engineConfiguration, (ClassLoader)Thread.currentThread().getContextClassLoader());
        DataflowDefinition dataflowDefinition = this.createDataflowDefinition(context, this.flowSnapshot);
        StatelessDataflow dataflow = bootstrap.createDataflow(dataflowDefinition);
        dataflow.initialize();
        return dataflow;
    }

    private StatelessDataflow getDataflow(ProcessContext context) throws IOException, StatelessConfigurationException {
        StatelessDataflow dataflow = (StatelessDataflow)this.dataflows.poll();
        if (dataflow == null) {
            return this.createDataflow(context);
        }
        return dataflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        StatelessDataflow dataflow;
        FlowFile flowFile = null;
        if (context.hasIncomingConnection() && (flowFile = session.get()) == null) {
            return;
        }
        try {
            dataflow = this.getDataflow(context);
        }
        catch (Exception e) {
            this.getLogger().error("Could not create dataflow from snapshot", (Throwable)e);
            session.rollback();
            return;
        }
        try {
            this.runDataflow(dataflow, flowFile, context, session);
        }
        finally {
            this.dataflows.offer(dataflow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDataflow(StatelessDataflow dataflow, FlowFile flowFile, ProcessContext context, ProcessSession session) {
        long now;
        long yieldMillis;
        Set<FlowFile> createdSet;
        Optional optionalResult;
        boolean enqueued;
        long timeoutMillis;
        try {
            timeoutMillis = context.getProperty(DATAFLOW_TIMEOUT).evaluateAttributeExpressions(flowFile).asTimePeriod(TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to determine Dataflow Timeout for {}. Routing to failure", new Object[]{flowFile});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        if (flowFile != null && !(enqueued = this.enqueueFlowFile(flowFile, dataflow, context, session))) {
            return;
        }
        dataflow.resetCounters();
        BulletinRepository bulletinRepository = dataflow.getBulletinRepository();
        long maxBulletinId = bulletinRepository.getMaxBulletinId();
        DataflowTrigger trigger = dataflow.trigger((DataflowTriggerContext)this.triggerContext);
        boolean timeoutExceeded = false;
        try {
            optionalResult = trigger.getResult(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            timeoutExceeded = true;
            optionalResult = Optional.empty();
            trigger.cancel();
        }
        finally {
            this.surfaceBulletins(bulletinRepository, maxBulletinId);
        }
        if (!optionalResult.isPresent()) {
            timeoutExceeded = true;
        }
        if (timeoutExceeded) {
            this.getLogger().error("Dataflow did not complete within the allotted time of {} milliseconds for {}. Routing to timeout.", new Object[]{timeoutMillis, flowFile});
            if (flowFile != null) {
                session.transfer(flowFile, REL_TIMEOUT);
            }
            trigger.cancel();
            return;
        }
        TriggerResult triggerResult = (TriggerResult)optionalResult.get();
        if (!triggerResult.isSuccessful()) {
            Optional failureOptional = triggerResult.getFailureCause();
            if (failureOptional.isPresent()) {
                Throwable cause = (Throwable)failureOptional.get();
                if (flowFile == null) {
                    this.getLogger().error("Dataflow failed to complete successfully. Yielding.", (Throwable)failureOptional.get());
                } else {
                    this.getLogger().error("Dataflow failed to complete successfully for {}. Routing to failure and yielding.", new Object[]{flowFile, failureOptional.get()});
                    if (cause instanceof FailurePortEncounteredException) {
                        String portName = ((FailurePortEncounteredException)cause).getPortName();
                        session.putAttribute(flowFile, "failure.port.name", portName);
                    }
                }
            }
            if (flowFile != null) {
                session.transfer(flowFile, REL_FAILURE);
            }
            this.adjustCounters(session, dataflow, " (Failed attempts)");
            session.adjustCounter("Failed Invocations", 1L, false);
            context.yield();
            return;
        }
        try {
            createdSet = this.createOutputFlowFiles((TriggerResult)optionalResult.get(), session, flowFile);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to write FlowFile contents that were output from Stateless Flow to the NiFi content repository for {}. Routing to failure.", new Object[]{flowFile, e});
            if (flowFile != null) {
                session.transfer(flowFile, REL_FAILURE);
            }
            return;
        }
        this.adjustCounters(session, dataflow, null);
        long yieldExpiration = dataflow.getSourceYieldExpiration();
        if (yieldExpiration > 0L && (yieldMillis = yieldExpiration - (now = System.currentTimeMillis())) > 0L) {
            context.yield();
        }
        if (flowFile != null) {
            session.transfer(flowFile, REL_ORIGINAL);
        }
        session.transfer(createdSet, REL_OUTPUT);
        session.commitAsync(() -> ((TriggerResult)triggerResult).acknowledge());
        if (flowFile == null) {
            this.getLogger().info("Successfully triggered dataflow to run, producing {} output FlowFiles", new Object[]{createdSet.size()});
        } else {
            this.getLogger().info("Successfully triggered dataflow to run against {}, producing {} output FlowFiles", new Object[]{flowFile, createdSet.size()});
        }
        session.adjustCounter("Successful Invocations", 1L, false);
    }

    private void surfaceBulletins(BulletinRepository bulletinRepository, long minBulletinId) {
        BulletinQuery bulletinQuery = new BulletinQuery.Builder().after(Long.valueOf(minBulletinId)).build();
        List bulletins = bulletinRepository.findBulletins(bulletinQuery);
        for (Bulletin bulletin : bulletins) {
            try {
                LogLevel logLevel;
                String level = bulletin.getLevel();
                if (level == null || level.equalsIgnoreCase("WARNING")) {
                    level = "WARN";
                }
                if ((logLevel = LogLevel.valueOf((String)level)) == LogLevel.DEBUG || logLevel == LogLevel.INFO) continue;
                this.getLogger().log(logLevel, "{} {}[name={}, id={}] {}", new Object[]{bulletin.getTimestamp(), bulletin.getSourceType(), bulletin.getSourceName(), bulletin.getSourceName(), bulletin.getMessage()});
            }
            catch (Exception e) {
                this.getLogger().warn("Dataflow emitted a bulletin but failed to surface that bulletin due to {}", new Object[]{e.toString(), e});
            }
        }
    }

    private void adjustCounters(ProcessSession session, StatelessDataflow dataflow, String counterNameSuffix) {
        for (Map.Entry entry : dataflow.getCounters(false).entrySet()) {
            if ((Long)entry.getValue() == 0L) continue;
            String counterName = counterNameSuffix == null ? (String)entry.getKey() : (String)entry.getKey() + counterNameSuffix;
            session.adjustCounter(counterName, ((Long)entry.getValue()).longValue(), false);
        }
    }

    private Set<FlowFile> createOutputFlowFiles(TriggerResult triggerResult, ProcessSession session, FlowFile flowFile) throws IOException {
        HashSet<FlowFile> createdSet = new HashSet<FlowFile>();
        try {
            Map outputFlowFiles = triggerResult.getOutputFlowFiles();
            for (Map.Entry entry : outputFlowFiles.entrySet()) {
                String outputPortName = (String)entry.getKey();
                List outputForPort = (List)entry.getValue();
                for (FlowFile outputFlowFile : outputForPort) {
                    FlowFile created = flowFile == null ? session.create() : session.create(flowFile);
                    createdSet.add(created);
                    try (OutputStream out = session.write(created);
                         InputStream flowFileContents = triggerResult.readContent(outputFlowFile);){
                        StreamUtils.copy((InputStream)flowFileContents, (OutputStream)out);
                    }
                    HashMap<String, String> attributes = new HashMap<String, String>(outputFlowFile.getAttributes());
                    attributes.put("output.port.name", outputPortName);
                    session.putAllAttributes(created, attributes);
                }
            }
        }
        catch (Exception e) {
            session.remove(createdSet);
            throw e;
        }
        return createdSet;
    }

    private boolean enqueueFlowFile(FlowFile flowFile, StatelessDataflow dataflow, ProcessContext context, ProcessSession session) {
        long maxBytes = context.getProperty(MAX_INPUT_FLOWFILE_SIZE).asDataSize(DataUnit.B).longValue();
        if (flowFile.getSize() > maxBytes) {
            this.getLogger().warn("Will not process {} because its size of {} bytes exceeds the max configured threshold of {} bytes. Routing to failure", new Object[]{flowFile, flowFile.getSize(), maxBytes});
            session.transfer(flowFile, REL_FAILURE);
            return false;
        }
        Set inputPortNames = dataflow.getInputPortNames();
        String inputPortName = context.getProperty(INPUT_PORT).evaluateAttributeExpressions(flowFile).getValue();
        if (inputPortName == null || inputPortName.trim().isEmpty()) {
            if (inputPortNames.size() == 1) {
                inputPortName = (String)inputPortNames.iterator().next();
            } else {
                this.getLogger().error("For {}, determined Input Port Name to be unspecified. Routing to failure.", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return false;
            }
        }
        if (!inputPortNames.contains(inputPortName)) {
            this.getLogger().error("For {}, Input Port Name is {}, but that Input Port does not exist in the provided dataflow or is not at the root level. Routing to failure", new Object[]{flowFile, inputPortName});
            session.transfer(flowFile, REL_FAILURE);
            return false;
        }
        try (InputStream in = session.read(flowFile);){
            dataflow.enqueue(in, flowFile.getAttributes(), inputPortName);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to read contents of FlowFile {} into memory. Routing to failure", new Object[]{flowFile});
            session.transfer(flowFile, REL_FAILURE);
            return false;
        }
        return true;
    }

    private DataflowDefinition createDataflowDefinition(ProcessContext context, final VersionedFlowSnapshot flowSnapshot) {
        final VersionedExternalFlow externalFlow = VersionedFlowConverter.createVersionedExternalFlow((VersionedFlowSnapshot)flowSnapshot);
        final ParameterValueProviderDefinition parameterValueProviderDefinition = new ParameterValueProviderDefinition();
        parameterValueProviderDefinition.setType("org.apache.nifi.stateless.parameter.OverrideParameterValueProvider");
        parameterValueProviderDefinition.setName("Parameter Override");
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
            parameterValues.put(((PropertyDescriptor)entry.getKey()).getName(), (String)entry.getValue());
        }
        parameterValueProviderDefinition.setPropertyValues(parameterValues);
        final Integer maxFlowFiles = context.getProperty(MAX_INGEST_FLOWFILES).asInteger();
        final Double maxBytes = context.getProperty(MAX_INGEST_DATA_SIZE).asDataSize(DataUnit.B);
        final long maxTimeNanos = context.getProperty(DATAFLOW_TIMEOUT).asTimePeriod(TimeUnit.NANOSECONDS);
        final TransactionThresholds transactionThresholds = new TransactionThresholds(){

            public OptionalLong getMaxFlowFiles() {
                return maxFlowFiles == null ? OptionalLong.empty() : OptionalLong.of(maxFlowFiles.intValue());
            }

            public OptionalLong getMaxContentSize(DataUnit dataUnit) {
                return maxBytes == null ? OptionalLong.empty() : OptionalLong.of(maxBytes.longValue());
            }

            public OptionalLong getMaxTime(TimeUnit timeUnit) {
                return OptionalLong.of(timeUnit.convert(maxTimeNanos, TimeUnit.NANOSECONDS));
            }
        };
        return new DataflowDefinition(){

            public VersionedExternalFlow getVersionedExternalFlow() {
                return externalFlow;
            }

            public String getFlowName() {
                return flowSnapshot.getFlowContents().getName();
            }

            public Set<String> getFailurePortNames() {
                return ExecuteStateless.this.failurePortNames;
            }

            public Set<String> getInputPortNames() {
                return Collections.emptySet();
            }

            public Set<String> getOutputPortNames() {
                return ExecuteStateless.this.failurePortNames;
            }

            public List<ParameterContextDefinition> getParameterContexts() {
                return null;
            }

            public List<ReportingTaskDefinition> getReportingTaskDefinitions() {
                return Collections.emptyList();
            }

            public List<ParameterValueProviderDefinition> getParameterValueProviderDefinitions() {
                return Collections.singletonList(parameterValueProviderDefinition);
            }

            public TransactionThresholds getTransactionThresholds() {
                return transactionThresholds;
            }
        };
    }

    private StatelessEngineConfiguration createEngineConfiguration(ProcessContext context, int contentRepoIndex) {
        File contentRepoDirectory;
        SslContextDefinition sslContextDefinition;
        final File workingDirectory = new File(context.getProperty(WORKING_DIRECTORY).getValue());
        final File narDirectory = new File(context.getProperty(LIB_DIRECTORY).getValue());
        final Collection<File> additionalNarDirectories = this.getAdditionalNarDirectories(context.getProperty(ADDITIONAL_LIB_DIRECTORIES).getValue());
        ResourceReference krb5Reference = context.getProperty(KRB5_CONF).asResource();
        final File krb5Conf = krb5Reference == null ? null : krb5Reference.asFile();
        SSLContextService sslContextService = (SSLContextService)context.getProperty(STATELESS_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslContextService == null) {
            sslContextDefinition = null;
        } else {
            sslContextDefinition = new SslContextDefinition();
            sslContextDefinition.setKeyPass(sslContextService.getKeyPassword());
            sslContextDefinition.setKeystoreFile(sslContextService.getKeyStoreFile());
            sslContextDefinition.setKeystorePass(sslContextService.getKeyStorePassword());
            sslContextDefinition.setKeystoreType(sslContextService.getKeyStoreType());
            sslContextDefinition.setTruststoreFile(sslContextService.getTrustStoreFile());
            sslContextDefinition.setTruststorePass(sslContextService.getTrustStorePassword());
            sslContextDefinition.setTruststoreType(sslContextService.getTrustStoreType());
        }
        String contentStorageStrategy = context.getProperty(CONTENT_STORAGE_STRATEGY).getValue();
        if (CONTENT_STORAGE_DISK.getValue().equals(contentStorageStrategy)) {
            File contentRepoRootDirectory = new File(workingDirectory, "execute-stateless-flowfile-content");
            File processorContentRepo = new File(contentRepoRootDirectory, this.getIdentifier());
            contentRepoDirectory = new File(processorContentRepo, String.valueOf(contentRepoIndex));
        } else {
            contentRepoDirectory = null;
        }
        final String statusTaskInterval = context.getProperty(STATUS_TASK_INTERVAL).getValue();
        return new StatelessEngineConfiguration(){

            public File getWorkingDirectory() {
                return workingDirectory;
            }

            public File getNarDirectory() {
                return narDirectory;
            }

            public File getExtensionsDirectory() {
                return narDirectory;
            }

            public Collection<File> getReadOnlyExtensionsDirectories() {
                return additionalNarDirectories;
            }

            public File getKrb5File() {
                return krb5Conf;
            }

            public Optional<File> getContentRepositoryDirectory() {
                return Optional.ofNullable(contentRepoDirectory);
            }

            public SslContextDefinition getSslContext() {
                return sslContextDefinition;
            }

            public String getSensitivePropsKey() {
                return ExecuteStateless.this.getIdentifier();
            }

            public List<ExtensionClientDefinition> getExtensionClients() {
                return Collections.emptyList();
            }

            public boolean isLogExtensionDiscovery() {
                return false;
            }

            public String getStatusTaskInterval() {
                return statusTaskInterval;
            }
        };
    }

    public Collection<SearchResult> search(SearchContext context) {
        VersionedFlow versionedFlow;
        if (this.flowSnapshot == null) {
            return Collections.emptyList();
        }
        VersionedComponentSearchResults results = new VersionedComponentSearchResults(context.getSearchTerm());
        Bucket bucket = this.flowSnapshot.getBucket();
        if (bucket != null) {
            results.add(bucket.getIdentifier(), "Bucket ID");
            results.add(bucket.getName(), "Bucket Name");
            results.add(bucket.getDescription(), "Bucket Description");
        }
        if ((versionedFlow = this.flowSnapshot.getFlow()) != null) {
            results.add(versionedFlow.getIdentifier(), "Flow ID");
            results.add(versionedFlow.getName(), "Flow Name");
            results.add(versionedFlow.getDescription(), "Flow Description");
        }
        this.search(this.flowSnapshot.getFlowContents(), results);
        return results.toList();
    }

    private void search(VersionedProcessGroup group, VersionedComponentSearchResults results) {
        Object bundle;
        results.add(group.getName(), "Process Group Name");
        results.add(group.getComments(), "Process Group Comments");
        for (VersionedPort versionedPort : group.getInputPorts()) {
            results.add(versionedPort.getName(), "Input Port Name");
            results.add(versionedPort.getComments(), "Input Port Comments");
            results.add(versionedPort.getIdentifier(), "Input Port ID");
        }
        for (VersionedPort versionedPort : group.getOutputPorts()) {
            results.add(versionedPort.getName(), "Output Port Name");
            results.add(versionedPort.getComments(), "Output Port Comments");
            results.add(versionedPort.getIdentifier(), "Output Port ID");
        }
        for (VersionedLabel versionedLabel : group.getLabels()) {
            results.add(versionedLabel.getLabel(), "Label Text");
        }
        for (VersionedProcessor versionedProcessor : group.getProcessors()) {
            results.add(versionedProcessor.getName(), "Processor Name");
            results.add(versionedProcessor.getType(), "Processor Type");
            results.add(versionedProcessor.getIdentifier(), "Processor ID");
            for (Map.Entry entry : versionedProcessor.getProperties().entrySet()) {
                results.add((String)entry.getKey(), "Processor Property Name");
                results.add((String)entry.getValue(), "Value of Processor Property " + (String)entry.getKey());
            }
            results.add(versionedProcessor.getComments(), "Processor Comments");
            bundle = versionedProcessor.getBundle();
            if (bundle == null) continue;
            results.add(bundle.getGroup(), "Bundle Group ID for Processor " + versionedProcessor.getType());
            results.add(bundle.getArtifact(), "Bundle Artifact ID for Processor " + versionedProcessor.getType());
            results.add(bundle.getVersion(), "Bundle Version for Processor " + versionedProcessor.getType());
        }
        for (VersionedRemoteProcessGroup versionedRemoteProcessGroup : group.getRemoteProcessGroups()) {
            results.add(versionedRemoteProcessGroup.getTargetUris(), "RPG Target URI");
            results.add(versionedRemoteProcessGroup.getComments(), "RPG Comments");
            results.add(versionedRemoteProcessGroup.getIdentifier(), "RPG Identifier");
            for (VersionedRemoteGroupPort versionedRemoteGroupPort : versionedRemoteProcessGroup.getInputPorts()) {
                results.add(versionedRemoteGroupPort.getName(), "RPG Input Port Name");
                results.add(versionedRemoteGroupPort.getIdentifier(), "RPG Input Port ID");
                results.add(versionedRemoteGroupPort.getTargetId(), "RPG Input Port Target ID");
            }
            for (VersionedRemoteGroupPort versionedRemoteGroupPort : versionedRemoteProcessGroup.getOutputPorts()) {
                results.add(versionedRemoteGroupPort.getName(), "RPG Output Port Name");
                results.add(versionedRemoteGroupPort.getIdentifier(), "RPG Output Port ID");
                results.add(versionedRemoteGroupPort.getTargetId(), "RPG Output Port Target ID");
            }
        }
        for (Map.Entry entry : group.getVariables().entrySet()) {
            results.add((String)entry.getKey(), "Variable Name");
            results.add((String)entry.getValue(), "Value of Variable " + (String)entry.getKey());
        }
        results.add(group.getParameterContextName(), "Parameter Context Name");
        for (VersionedConnection versionedConnection : group.getConnections()) {
            results.add(versionedConnection.getIdentifier(), "Connection ID");
            results.add(versionedConnection.getName(), "Connection Name");
            if (versionedConnection.getSelectedRelationships() != null) {
                results.add(versionedConnection.getSelectedRelationships().toString(), "Selected Relationships");
            }
            results.add(versionedConnection.getComments(), "Connection Comments");
        }
        for (VersionedControllerService versionedControllerService : group.getControllerServices()) {
            results.add(versionedControllerService.getName(), "Controller Service Name");
            results.add(versionedControllerService.getType(), "Controller Service Type");
            results.add(versionedControllerService.getIdentifier(), "Controller Service ID");
            for (Map.Entry entry : versionedControllerService.getProperties().entrySet()) {
                results.add((String)entry.getKey(), "Controller Service Property Name");
                results.add((String)entry.getValue(), "Value of Controller Service Property " + (String)entry.getKey());
            }
            results.add(versionedControllerService.getComments(), "Controller Service Comments");
            bundle = versionedControllerService.getBundle();
            if (bundle == null) continue;
            results.add(bundle.getGroup(), "Bundle Group ID for Controller Service " + versionedControllerService.getType());
            results.add(bundle.getArtifact(), "Bundle Artifact ID for Controller Service " + versionedControllerService.getType());
            results.add(bundle.getVersion(), "Bundle Version for Controller Service " + versionedControllerService.getType());
        }
        for (VersionedProcessGroup versionedProcessGroup : group.getProcessGroups()) {
            this.search(versionedProcessGroup, results);
        }
    }

    private Collection<File> getAdditionalNarDirectories(String commaSeparatedPaths) {
        if (commaSeparatedPaths == null || commaSeparatedPaths.isEmpty()) {
            return Collections.emptyList();
        }
        String[] paths = commaSeparatedPaths.split(",");
        ArrayList<File> directories = new ArrayList<File>();
        for (String path : paths) {
            String trimmedPath = path.trim();
            if (trimmedPath.isEmpty()) continue;
            directories.add(new File(trimmedPath));
        }
        return directories;
    }

    private static class AbortableTriggerContext
    implements DataflowTriggerContext {
        private volatile boolean aborted = false;

        private AbortableTriggerContext() {
        }

        public boolean isAbort() {
            return this.aborted;
        }

        public void abort() {
            this.aborted = true;
        }
    }

    private static class VersionedComponentSearchResults {
        private final String term;
        private final List<SearchResult> results = new ArrayList<SearchResult>();

        public VersionedComponentSearchResults(String term) {
            this.term = term;
        }

        public void add(String value, String description) {
            if (value == null) {
                return;
            }
            if (value.contains(this.term)) {
                this.results.add(new SearchResult.Builder().match(value).label(description).build());
            }
        }

        public List<SearchResult> toList() {
            return this.results;
        }
    }
}

