/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.repository;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.AsyncLineageSubmission;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QuerySubmission;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.util.RingBuffer;

public class StatelessProvenanceRepository
implements ProvenanceRepository {
    public static String CONTAINER_NAME = "in-memory";
    private final RingBuffer<ProvenanceEventRecord> ringBuffer;
    private final int maxSize;
    private final AtomicLong idGenerator = new AtomicLong(0L);

    public StatelessProvenanceRepository(int maxEvents) {
        this.maxSize = maxEvents;
        this.ringBuffer = new RingBuffer(this.maxSize);
    }

    public void initialize(EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory, IdentifierLookup idLookup) throws IOException {
    }

    public ProvenanceEventRepository getProvenanceEventRepository() {
        return this;
    }

    public ProvenanceEventBuilder eventBuilder() {
        return new StandardProvenanceEventRecord.Builder();
    }

    public void registerEvent(ProvenanceEventRecord event) {
        long id = this.idGenerator.getAndIncrement();
        this.ringBuffer.add((Object)new IdEnrichedProvEvent(event, id));
    }

    public void registerEvents(Iterable<ProvenanceEventRecord> events) {
        for (ProvenanceEventRecord event : events) {
            this.registerEvent(event);
        }
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords) throws IOException {
        return this.getEvents(firstRecordId, maxRecords, null);
    }

    public List<ProvenanceEventRecord> getEvents(final long firstRecordId, int maxRecords, NiFiUser user) throws IOException {
        return this.ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord value) {
                return value.getEventId() >= firstRecordId;
            }
        }, maxRecords);
    }

    public Long getMaxEventId() {
        ProvenanceEventRecord newest = (ProvenanceEventRecord)this.ringBuffer.getNewestElement();
        return newest == null ? null : Long.valueOf(newest.getEventId());
    }

    public ProvenanceEventRecord getEvent(final String identifier) throws IOException {
        List records = this.ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord event) {
                return identifier.equals(event.getFlowFileUuid());
            }
        }, 1);
        return records.isEmpty() ? null : (ProvenanceEventRecord)records.get(0);
    }

    public ProvenanceEventRecord getEvent(final long id) {
        List records = this.ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<ProvenanceEventRecord>(){

            public boolean select(ProvenanceEventRecord event) {
                return event.getEventId() == id;
            }
        }, 1);
        return records.isEmpty() ? null : (ProvenanceEventRecord)records.get(0);
    }

    public ProvenanceEventRecord getEvent(long id, NiFiUser user) {
        return this.getEvent(id);
    }

    public void close() throws IOException {
    }

    public List<SearchableField> getSearchableFields() {
        throw new UnsupportedOperationException();
    }

    public List<SearchableField> getSearchableAttributes() {
        throw new UnsupportedOperationException();
    }

    public QuerySubmission submitQuery(Query query, NiFiUser user) {
        throw new UnsupportedOperationException();
    }

    public Optional<ProvenanceEventRecord> getLatestCachedEvent(String componentId) throws IOException {
        return Optional.empty();
    }

    public QuerySubmission retrieveQuerySubmission(String queryIdentifier, NiFiUser user) {
        throw new UnsupportedOperationException();
    }

    public ComputeLineageSubmission submitLineageComputation(long eventId, NiFiUser user) {
        throw new UnsupportedOperationException();
    }

    public AsyncLineageSubmission submitLineageComputation(String flowFileUuid, NiFiUser user) {
        throw new UnsupportedOperationException();
    }

    public ComputeLineageSubmission retrieveLineageSubmission(String lineageIdentifier, NiFiUser user) {
        throw new UnsupportedOperationException();
    }

    public ComputeLineageSubmission submitExpandParents(long eventId, NiFiUser user) {
        throw new UnsupportedOperationException();
    }

    public ComputeLineageSubmission submitExpandChildren(long eventId, NiFiUser user) {
        throw new UnsupportedOperationException();
    }

    public long getContainerCapacity(String containerName) throws IOException {
        return this.maxSize;
    }

    public Set<String> getContainerNames() {
        return Collections.singleton(CONTAINER_NAME);
    }

    public long getContainerUsableSpace(String containerName) throws IOException {
        return this.maxSize - this.ringBuffer.getSize();
    }

    public String getContainerFileStoreName(String containerName) {
        return null;
    }

    private static class IdEnrichedProvEvent
    implements ProvenanceEventRecord {
        private final ProvenanceEventRecord record;
        private final long id;

        public IdEnrichedProvEvent(ProvenanceEventRecord record, long id) {
            this.record = record;
            this.id = id;
        }

        public long getEventId() {
            return this.id;
        }

        public long getEventTime() {
            return this.record.getEventTime();
        }

        public long getFlowFileEntryDate() {
            return this.record.getFlowFileEntryDate();
        }

        public long getLineageStartDate() {
            return this.record.getLineageStartDate();
        }

        public long getFileSize() {
            return this.record.getFileSize();
        }

        public Long getPreviousFileSize() {
            return this.record.getPreviousFileSize();
        }

        public long getEventDuration() {
            return this.record.getEventDuration();
        }

        public ProvenanceEventType getEventType() {
            return this.record.getEventType();
        }

        public Map<String, String> getAttributes() {
            return this.record.getAttributes();
        }

        public Map<String, String> getPreviousAttributes() {
            return this.record.getPreviousAttributes();
        }

        public Map<String, String> getUpdatedAttributes() {
            return this.record.getUpdatedAttributes();
        }

        public String getComponentId() {
            return this.record.getComponentId();
        }

        public String getComponentType() {
            return this.record.getComponentType();
        }

        public String getTransitUri() {
            return this.record.getTransitUri();
        }

        public String getSourceSystemFlowFileIdentifier() {
            return this.record.getSourceSystemFlowFileIdentifier();
        }

        public String getFlowFileUuid() {
            return this.record.getFlowFileUuid();
        }

        public List<String> getParentUuids() {
            return this.record.getParentUuids();
        }

        public List<String> getChildUuids() {
            return this.record.getChildUuids();
        }

        public String getAlternateIdentifierUri() {
            return this.record.getAlternateIdentifierUri();
        }

        public String getDetails() {
            return this.record.getDetails();
        }

        public String getRelationship() {
            return this.record.getRelationship();
        }

        public String getSourceQueueIdentifier() {
            return this.record.getSourceQueueIdentifier();
        }

        public String getContentClaimSection() {
            return this.record.getContentClaimSection();
        }

        public String getPreviousContentClaimSection() {
            return this.record.getPreviousContentClaimSection();
        }

        public String getContentClaimContainer() {
            return this.record.getContentClaimContainer();
        }

        public String getPreviousContentClaimContainer() {
            return this.record.getPreviousContentClaimContainer();
        }

        public String getContentClaimIdentifier() {
            return this.record.getContentClaimIdentifier();
        }

        public String getPreviousContentClaimIdentifier() {
            return this.record.getPreviousContentClaimIdentifier();
        }

        public Long getContentClaimOffset() {
            return this.record.getContentClaimOffset();
        }

        public Long getPreviousContentClaimOffset() {
            return this.record.getPreviousContentClaimOffset();
        }

        public String getBestEventIdentifier() {
            return Long.toString(this.getEventId());
        }
    }
}

