/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.parameter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.stateless.config.ParameterOverride;
import org.apache.nifi.stateless.parameter.AbstractParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProviderInitializationContext;

public class OverrideParameterValueProvider
extends AbstractParameterValueProvider
implements ParameterValueProvider {
    private List<ParameterOverride> parameterOverrides;

    public void init(ParameterValueProviderInitializationContext context) {
        this.parameterOverrides = this.parseConfiguration(context);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(Validator.VALID).build();
    }

    private List<ParameterOverride> parseConfiguration(ParameterValueProviderInitializationContext context) {
        ArrayList<ParameterOverride> overrides = new ArrayList<ParameterOverride>();
        Map properties = context.getAllProperties();
        for (Map.Entry entry : properties.entrySet()) {
            ParameterOverride override;
            String propertyName = (String)entry.getKey();
            String propertyValue = (String)entry.getValue();
            if (propertyName.contains(":")) {
                String[] splits = propertyName.split(":", 2);
                String contextName = splits[0];
                String parameterName = splits[1];
                override = new ParameterOverride(contextName, parameterName, propertyValue);
            } else {
                override = new ParameterOverride(propertyName, propertyValue);
            }
            overrides.add(override);
        }
        return overrides;
    }

    public String getParameterValue(String contextName, String parameterName) {
        ParameterOverride override = this.getParameterOverride(contextName, parameterName);
        return override == null ? null : override.getParameterValue();
    }

    public boolean isParameterDefined(String contextName, String parameterName) {
        ParameterOverride override = this.getParameterOverride(contextName, parameterName);
        return override != null;
    }

    private ParameterOverride getParameterOverride(String contextName, String parameterName) {
        for (ParameterOverride override : this.parameterOverrides) {
            if (override.getContextName() != null && !Objects.equals(override.getContextName(), contextName) || !Objects.equals(override.getParameterName(), parameterName)) continue;
            return override;
        }
        return null;
    }
}

