/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.engine;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessSchedulingAgent
implements SchedulingAgent {
    private static final Logger logger = LoggerFactory.getLogger(StatelessSchedulingAgent.class);
    private final ExtensionManager extensionManager;

    public StatelessSchedulingAgent(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void schedule(Connectable connectable, LifecycleState scheduleState) {
    }

    public void scheduleOnce(Connectable connectable, LifecycleState scheduleState, Callable<Future<Void>> stopCallback) {
    }

    public void unschedule(Connectable connectable, LifecycleState scheduleState) {
    }

    public void onEvent(Connectable connectable) {
    }

    public void schedule(final ReportingTaskNode taskNode, final LifecycleState scheduleState) {
        final long schedulingMillis = taskNode.getSchedulingPeriod(TimeUnit.MILLISECONDS);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(schedulingMillis);
                    }
                    catch (InterruptedException e) {
                        logger.info("Interrupted while waiting to trigger {}. Will no longer trigger Reporting Task to run", (Object)taskNode);
                        return;
                    }
                    StatelessSchedulingAgent.this.triggerReportingTask(taskNode, scheduleState);
                }
            }
        });
        thread.setName("Trigger Reporting Task " + taskNode.getName());
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerReportingTask(ReportingTaskNode taskNode, LifecycleState scheduleState) {
        block11: {
            try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.extensionManager, taskNode.getReportingTask().getClass(), (String)taskNode.getIdentifier());){
                logger.debug("Triggering {} to run", (Object)taskNode);
                scheduleState.incrementActiveThreadCount(null);
                try {
                    taskNode.getReportingTask().onTrigger(taskNode.getReportingContext());
                }
                finally {
                    scheduleState.decrementActiveThreadCount();
                }
            }
            catch (Throwable t) {
                SimpleProcessLogger componentLog = new SimpleProcessLogger(taskNode.getIdentifier(), (Object)taskNode.getReportingTask(), (LoggingContext)new StandardLoggingContext(null));
                componentLog.error("Error running task {}", new Object[]{taskNode.getReportingTask(), t});
                if (!componentLog.isDebugEnabled()) break block11;
                componentLog.error("", t);
            }
        }
    }

    public void unschedule(ReportingTaskNode taskNode, LifecycleState scheduleState) {
    }

    public void setMaxThreadCount(int maxThreads) {
    }

    public void incrementMaxThreadCount(int toAdd) {
    }

    public void setAdministrativeYieldDuration(String duration) {
    }

    public String getAdministrativeYieldDuration() {
        return "1 sec";
    }

    public long getAdministrativeYieldDuration(TimeUnit timeUnit) {
        return timeUnit.convert(1L, TimeUnit.SECONDS);
    }

    public void shutdown() {
    }
}

