/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.stateful.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@TriggerSerially
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Attribute Expression Language", "state", "data science", "rolling", "window"})
@CapabilityDescription(value="Track a Rolling Window based on evaluating an Expression Language expression on each FlowFile and add that value to the processor's state. Each FlowFile will be emitted with the count of FlowFiles and total aggregate value of values processed in the current time window.")
@WritesAttributes(value={@WritesAttribute(attribute="rolling_window_value", description="The rolling window value (sum of all the values stored)."), @WritesAttribute(attribute="rolling_window_count", description="The count of the number of FlowFiles seen in the rolling window."), @WritesAttribute(attribute="rolling_window_mean", description="The mean of the FlowFiles seen in the rolling window."), @WritesAttribute(attribute="rolling_window_variance", description="The variance of the FlowFiles seen in the rolling window."), @WritesAttribute(attribute="rolling_window_stddev", description="The standard deviation (positive square root of the variance) of the FlowFiles seen in the rolling window.")})
@Stateful(scopes={Scope.LOCAL}, description="Store the values backing the rolling window. This includes storing the individual values and their time-stamps or the batches of values and their counts.")
public class AttributeRollingWindow
extends AbstractProcessor {
    public static final String COUNT_KEY = "count";
    public static final String ROLLING_WINDOW_VALUE_KEY = "rolling_window_value";
    public static final String ROLLING_WINDOW_COUNT_KEY = "rolling_window_count";
    public static final String ROLLING_WINDOW_MEAN_KEY = "rolling_window_mean";
    public static final String ROLLING_WINDOW_VARIANCE_KEY = "rolling_window_variance";
    public static final String ROLLING_WINDOW_STDDEV_KEY = "rolling_window_stddev";
    public static final String CURRENT_MICRO_BATCH_STATE_TS_KEY = "start_curr_batch_ts";
    public static final String BATCH_APPEND_KEY = "_batch";
    public static final String COUNT_APPEND_KEY = "_count";
    public static final int COUNT_APPEND_KEY_LENGTH = 6;
    static final PropertyDescriptor VALUE_TO_TRACK = new PropertyDescriptor.Builder().displayName("Value to track").name("Value to track").description("The expression on which to evaluate each FlowFile. The result of the expression will be added to the rolling window value.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).required(true).build();
    static final PropertyDescriptor TIME_WINDOW = new PropertyDescriptor.Builder().displayName("Time window").name("Time window").description("The time window on which to calculate the rolling window.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).build();
    static final PropertyDescriptor SUB_WINDOW_LENGTH = new PropertyDescriptor.Builder().displayName("Sub-window length").name("Sub-window length").description("When set, values will be batched into sub-windows of the set length. This allows for much larger length total windows to be set but sacrifices some precision. If this is not set (or is 0) then each value is stored in state with the timestamp of when it was received. After the length of time stated in " + TIME_WINDOW.getDisplayName() + " elaspes the value will be removed. If this is set, values will be batched together every X amount of time (where X is the time period set for this property) and removed all at once.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(false).build();
    private final Set<Relationship> relationships;
    private final List<PropertyDescriptor> properties;
    private Long timeWindow;
    private Long microBatchTime;
    private static final Scope SCOPE = Scope.LOCAL;
    public static final Relationship REL_SUCCESS = new Relationship.Builder().description("All FlowFiles are successfully processed are routed here").name("success").build();
    public static final Relationship REL_FAILED_SET_STATE = new Relationship.Builder().name("set state fail").description("When state fails to save when processing a FlowFile, the FlowFile is routed here.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("When a FlowFile fails for a reason other than failing to set state it is routed here.").build();

    public AttributeRollingWindow() {
        HashSet<Relationship> relationshipSet = new HashSet<Relationship>();
        relationshipSet.add(REL_SUCCESS);
        relationshipSet.add(REL_FAILED_SET_STATE);
        relationshipSet.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationshipSet);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(VALUE_TO_TRACK);
        properties.add(TIME_WINDOW);
        properties.add(SUB_WINDOW_LENGTH);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        this.timeWindow = context.getProperty(TIME_WINDOW).asTimePeriod(TimeUnit.MILLISECONDS);
        this.microBatchTime = context.getProperty(SUB_WINDOW_LENGTH).asTimePeriod(TimeUnit.MILLISECONDS);
        if (this.microBatchTime == null || this.microBatchTime == 0L) {
            StateManager stateManager = context.getStateManager();
            StateMap state = stateManager.getState(SCOPE);
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.putAll(state.toMap());
            if (!tempMap.containsKey(COUNT_KEY)) {
                tempMap.put(COUNT_KEY, "0");
                context.getStateManager().setState(tempMap, SCOPE);
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            Long currTime = System.currentTimeMillis();
            if (this.microBatchTime == null) {
                this.noMicroBatch(context, session, flowFile, currTime);
            } else {
                this.microBatch(context, session, flowFile, currTime);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Ran into an error while processing {}.", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void noMicroBatch(ProcessContext context, ProcessSession session, FlowFile flowFile, Long currTime) {
        Long count;
        HashMap<String, String> state = null;
        try {
            state = new HashMap<String, String>(session.getState(SCOPE).toMap());
        }
        catch (IOException e) {
            this.getLogger().error("Failed to get the initial state when processing {}; transferring FlowFile back to its incoming queue", new Object[]{flowFile, e});
            session.transfer(flowFile);
            context.yield();
            return;
        }
        Long l = count = Long.valueOf((String)state.get(COUNT_KEY));
        count = count + 1L;
        Long l2 = count;
        HashSet<Object> keysToRemove = new HashSet<Object>();
        for (Object key : state.keySet()) {
            if (((String)key).equals(COUNT_KEY)) continue;
            Long l3 = Long.decode((String)key);
            if (currTime - l3 <= this.timeWindow) continue;
            keysToRemove.add(key);
            Long l4 = count;
            Long l5 = count = Long.valueOf(count - 1L);
        }
        String countString = String.valueOf(count);
        for (String string : keysToRemove) {
            state.remove(string);
        }
        Double aggregateValue = 0.0;
        Variance variance = new Variance();
        for (Map.Entry entry : state.entrySet()) {
            if (((String)entry.getKey()).equals(COUNT_KEY)) continue;
            Double value = Double.valueOf((String)entry.getValue());
            variance.increment(value.doubleValue());
            aggregateValue = aggregateValue + value;
        }
        Double currentFlowFileValue = context.getProperty(VALUE_TO_TRACK).evaluateAttributeExpressions(flowFile).asDouble();
        variance.increment(currentFlowFileValue.doubleValue());
        aggregateValue = aggregateValue + currentFlowFileValue;
        state.put(String.valueOf(currTime), String.valueOf(currentFlowFileValue));
        state.put(COUNT_KEY, countString);
        try {
            session.setState(state, SCOPE);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to set the state after successfully processing {} due a failure when setting the state. Transferring to '{}'", new Object[]{flowFile, REL_FAILED_SET_STATE.getName(), e});
            session.transfer(flowFile, REL_FAILED_SET_STATE);
            context.yield();
            return;
        }
        Double mean = aggregateValue / (double)count.longValue();
        HashMap<String, String> attributesToAdd = new HashMap<String, String>();
        attributesToAdd.put(ROLLING_WINDOW_VALUE_KEY, String.valueOf(aggregateValue));
        attributesToAdd.put(ROLLING_WINDOW_COUNT_KEY, String.valueOf(count));
        attributesToAdd.put(ROLLING_WINDOW_MEAN_KEY, String.valueOf(mean));
        double varianceValue = variance.getResult();
        attributesToAdd.put(ROLLING_WINDOW_VARIANCE_KEY, String.valueOf(varianceValue));
        attributesToAdd.put(ROLLING_WINDOW_STDDEV_KEY, String.valueOf(Math.sqrt(varianceValue)));
        flowFile = session.putAllAttributes(flowFile, attributesToAdd);
        session.transfer(flowFile, REL_SUCCESS);
    }

    private void microBatch(ProcessContext context, ProcessSession session, FlowFile flowFile, Long currTime) {
        HashMap<Object, String> state = null;
        try {
            state = new HashMap<Object, String>(session.getState(SCOPE).toMap());
        }
        catch (IOException e) {
            this.getLogger().error("Failed to get the initial state when processing {}; transferring FlowFile back to its incoming queue", new Object[]{flowFile, e});
            session.transfer(flowFile);
            context.yield();
            return;
        }
        String currBatchStart = (String)state.get(CURRENT_MICRO_BATCH_STATE_TS_KEY);
        boolean newBatch = false;
        if (currBatchStart != null) {
            if (currTime - Long.valueOf(currBatchStart) > this.microBatchTime) {
                newBatch = true;
                currBatchStart = String.valueOf(currTime);
                state.put(CURRENT_MICRO_BATCH_STATE_TS_KEY, currBatchStart);
            }
        } else {
            newBatch = true;
            currBatchStart = String.valueOf(currTime);
            state.put(CURRENT_MICRO_BATCH_STATE_TS_KEY, currBatchStart);
        }
        Long count = 0L;
        count = count + 1L;
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String key : state.keySet()) {
            Long timeStamp;
            String timeStampString;
            if (key.endsWith(BATCH_APPEND_KEY)) {
                timeStampString = key.substring(0, key.length() - 6);
                timeStamp = Long.decode(timeStampString);
                if (currTime - timeStamp <= this.timeWindow) continue;
                keysToRemove.add(key);
                continue;
            }
            if (!key.endsWith(COUNT_APPEND_KEY)) continue;
            timeStampString = key.substring(0, key.length() - 6);
            timeStamp = Long.decode(timeStampString);
            if (currTime - timeStamp > this.timeWindow) {
                keysToRemove.add(key);
                continue;
            }
            count = count + Long.valueOf((String)state.get(key));
        }
        for (String key : keysToRemove) {
            state.remove(key);
        }
        keysToRemove.clear();
        Double aggregateValue = 0.0;
        Double currentBatchValue = 0.0;
        Long currentBatchCount = 0L;
        Variance variance = new Variance();
        for (Map.Entry entry : state.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(BATCH_APPEND_KEY)) continue;
            String timeStampString = key.substring(0, key.length() - 6);
            Double batchValue = Double.valueOf((String)entry.getValue());
            Long batchCount = Long.valueOf((String)state.get(timeStampString + COUNT_APPEND_KEY));
            if (!newBatch && timeStampString.equals(currBatchStart)) {
                Double currentFlowFileValue = context.getProperty(VALUE_TO_TRACK).evaluateAttributeExpressions(flowFile).asDouble();
                Long l = batchCount;
                Long l2 = batchCount = Long.valueOf(batchCount + 1L);
                currentBatchValue = batchValue = Double.valueOf(batchValue + currentFlowFileValue);
                currentBatchCount = batchCount;
            }
            aggregateValue = aggregateValue + batchValue;
            variance.increment(batchValue.doubleValue());
        }
        if (newBatch) {
            Double currentFlowFileValue = context.getProperty(VALUE_TO_TRACK).evaluateAttributeExpressions(flowFile).asDouble();
            currentBatchValue = currentBatchValue + currentFlowFileValue;
            currentBatchCount = 1L;
            aggregateValue = aggregateValue + currentBatchValue;
            variance.increment(currentBatchValue.doubleValue());
        }
        state.put(currBatchStart + BATCH_APPEND_KEY, String.valueOf(currentBatchValue));
        state.put(currBatchStart + COUNT_APPEND_KEY, String.valueOf(currentBatchCount));
        try {
            session.setState(state, SCOPE);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to get the initial state when processing {}; transferring FlowFile back to its incoming queue", new Object[]{flowFile, e});
            session.transfer(flowFile);
            context.yield();
            return;
        }
        Double mean = aggregateValue / (double)count.longValue();
        HashMap<String, String> attributesToAdd = new HashMap<String, String>();
        attributesToAdd.put(ROLLING_WINDOW_VALUE_KEY, String.valueOf(aggregateValue));
        attributesToAdd.put(ROLLING_WINDOW_COUNT_KEY, String.valueOf(count));
        attributesToAdd.put(ROLLING_WINDOW_MEAN_KEY, String.valueOf(mean));
        double varianceValue = variance.getResult();
        attributesToAdd.put(ROLLING_WINDOW_VARIANCE_KEY, String.valueOf(varianceValue));
        attributesToAdd.put(ROLLING_WINDOW_STDDEV_KEY, String.valueOf(Math.sqrt(varianceValue)));
        flowFile = session.putAllAttributes(flowFile, attributesToAdd);
        session.transfer(flowFile, REL_SUCCESS);
    }
}

