/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.socket;

import com.exceptionfactory.socketbroker.BrokeredSocketFactory;
import com.exceptionfactory.socketbroker.configuration.AuthenticationCredentials;
import com.exceptionfactory.socketbroker.configuration.BrokerConfiguration;
import com.exceptionfactory.socketbroker.configuration.ProxyType;
import com.exceptionfactory.socketbroker.configuration.StandardBrokerConfiguration;
import com.exceptionfactory.socketbroker.configuration.StandardUsernamePasswordAuthenticationCredentials;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Objects;
import javax.net.SocketFactory;
import org.apache.nifi.processors.standard.socket.ProxySocketFactory;
import org.apache.nifi.processors.standard.socket.SocketFactoryProvider;
import org.apache.nifi.proxy.ProxyConfiguration;

public class StandardSocketFactoryProvider
implements SocketFactoryProvider {
    @Override
    public SocketFactory getSocketFactory(ProxyConfiguration proxyConfiguration) {
        ProxySocketFactory socketFactory;
        Objects.requireNonNull(proxyConfiguration, "Proxy Configuration required");
        String userName = proxyConfiguration.getProxyUserName();
        if (userName == null) {
            Proxy proxy = proxyConfiguration.createProxy();
            socketFactory = new ProxySocketFactory(proxy);
        } else {
            Proxy.Type proxyType = proxyConfiguration.getProxyType();
            ProxyType brokerProxyType = Proxy.Type.SOCKS == proxyType ? ProxyType.SOCKS5 : ProxyType.HTTP_CONNECT;
            InetSocketAddress proxySocketAddress = new InetSocketAddress(proxyConfiguration.getProxyServerHost(), (int)proxyConfiguration.getProxyServerPort());
            String proxyPassword = proxyConfiguration.getProxyUserPassword();
            char[] brokerProxyPassword = proxyPassword == null ? new char[]{} : proxyPassword.toCharArray();
            StandardUsernamePasswordAuthenticationCredentials credentials = new StandardUsernamePasswordAuthenticationCredentials(userName, brokerProxyPassword);
            StandardBrokerConfiguration brokerConfiguration = new StandardBrokerConfiguration(brokerProxyType, proxySocketAddress, (AuthenticationCredentials)credentials);
            socketFactory = new BrokeredSocketFactory((BrokerConfiguration)brokerConfiguration, SocketFactory.getDefault());
        }
        return socketFactory;
    }
}

