/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.http;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.nifi.processors.standard.http.CertificateAttribute;
import org.apache.nifi.processors.standard.http.HandleHttpRequestCertificateAttributesProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class HandleHttpRequestCertificateAttributesProviderTest {
    private static final X500Principal SUBJECT_PRINCIPAL = new X500Principal("CN=subject, OU=users");
    private static final X500Principal ISSUER_PRINCIPAL = new X500Principal("CN=issuer, OU=authorities");
    private static final String RFC_822_NAME_GENERAL_NAME = "rfc822Name";
    private static final String DNS_NAME_GENERAL_NAME = "dNSName";
    private static final Integer RFC_822_NAME_TYPE = 1;
    private static final String EMAIL_ADDRESS = "username@localhost.localdomain";
    private static final Integer DNS_NAME_TYPE = 2;
    private static final String DNS_NAME = "localhost.localdomain";
    private static final String FIRST_SAN_NAME_ATTRIBUTE_KEY = "http.certificate.sans.0.name";
    private static final String FIRST_SAN_NAME_TYPE_ATTRIBUTE_KEY = "http.certificate.sans.0.nameType";
    private static final String SECOND_SAN_NAME_ATTRIBUTE_KEY = "http.certificate.sans.1.name";
    private static final String SECOND_SAN_NAME_TYPE_ATTRIBUTE_KEY = "http.certificate.sans.1.nameType";
    private static final String PARSING_EXCEPTION_MESSAGE = "SAN parsing failed";
    @Mock
    private HttpServletRequest request;
    @Mock
    private X509Certificate certificate;
    private HandleHttpRequestCertificateAttributesProvider provider;

    HandleHttpRequestCertificateAttributesProviderTest() {
    }

    @BeforeEach
    void setProvider() {
        this.provider = new HandleHttpRequestCertificateAttributesProvider();
    }

    @Test
    void testCertificatesNotFound() {
        Map attributes = this.provider.getCertificateAttributes(this.request);
        Assertions.assertTrue((boolean)attributes.isEmpty());
    }

    @Test
    void testCertificatesFound() {
        X509Certificate[] certificates = new X509Certificate[]{this.certificate};
        Mockito.when((Object)this.request.getAttribute((String)ArgumentMatchers.eq((Object)"jakarta.servlet.request.X509Certificate"))).thenReturn((Object)certificates);
        Mockito.when((Object)this.certificate.getSubjectX500Principal()).thenReturn((Object)SUBJECT_PRINCIPAL);
        Mockito.when((Object)this.certificate.getIssuerX500Principal()).thenReturn((Object)ISSUER_PRINCIPAL);
        Map attributes = this.provider.getCertificateAttributes(this.request);
        this.assertSubjectIssuerFound(attributes);
    }

    @Test
    void testCertificatesFoundParsingException() throws CertificateParsingException {
        X509Certificate[] certificates = new X509Certificate[]{this.certificate};
        Mockito.when((Object)this.request.getAttribute((String)ArgumentMatchers.eq((Object)"jakarta.servlet.request.X509Certificate"))).thenReturn((Object)certificates);
        Mockito.when((Object)this.certificate.getSubjectX500Principal()).thenReturn((Object)SUBJECT_PRINCIPAL);
        Mockito.when((Object)this.certificate.getIssuerX500Principal()).thenReturn((Object)ISSUER_PRINCIPAL);
        Mockito.when(this.certificate.getSubjectAlternativeNames()).thenThrow(new Throwable[]{new CertificateParsingException(PARSING_EXCEPTION_MESSAGE)});
        Map attributes = this.provider.getCertificateAttributes(this.request);
        this.assertSubjectIssuerFound(attributes);
    }

    @Test
    void testCertificateSubjectAlternativeNamesFound() throws CertificateParsingException {
        X509Certificate[] certificates = new X509Certificate[]{this.certificate};
        Mockito.when((Object)this.request.getAttribute((String)ArgumentMatchers.eq((Object)"jakarta.servlet.request.X509Certificate"))).thenReturn((Object)certificates);
        Mockito.when((Object)this.certificate.getSubjectX500Principal()).thenReturn((Object)SUBJECT_PRINCIPAL);
        Mockito.when((Object)this.certificate.getIssuerX500Principal()).thenReturn((Object)ISSUER_PRINCIPAL);
        ArrayList<List<Serializable>> subjectAlternativeNames = new ArrayList<List<Serializable>>();
        List<Serializable> emailAddressName = Arrays.asList(RFC_822_NAME_TYPE, EMAIL_ADDRESS);
        subjectAlternativeNames.add(emailAddressName);
        List<Serializable> dnsName = Arrays.asList(DNS_NAME_TYPE, DNS_NAME);
        subjectAlternativeNames.add(dnsName);
        Mockito.when(this.certificate.getSubjectAlternativeNames()).thenReturn(subjectAlternativeNames);
        Map attributes = this.provider.getCertificateAttributes(this.request);
        this.assertSubjectIssuerFound(attributes);
        Assertions.assertEquals(attributes.get(FIRST_SAN_NAME_ATTRIBUTE_KEY), (Object)EMAIL_ADDRESS);
        Assertions.assertEquals(attributes.get(FIRST_SAN_NAME_TYPE_ATTRIBUTE_KEY), (Object)RFC_822_NAME_GENERAL_NAME);
        Assertions.assertEquals(attributes.get(SECOND_SAN_NAME_ATTRIBUTE_KEY), (Object)DNS_NAME);
        Assertions.assertEquals(attributes.get(SECOND_SAN_NAME_TYPE_ATTRIBUTE_KEY), (Object)DNS_NAME_GENERAL_NAME);
    }

    private void assertSubjectIssuerFound(Map<String, String> attributes) {
        Assertions.assertEquals((Object)SUBJECT_PRINCIPAL.getName(), (Object)attributes.get(CertificateAttribute.HTTP_SUBJECT_DN.getName()));
        Assertions.assertEquals((Object)ISSUER_PRINCIPAL.getName(), (Object)attributes.get(CertificateAttribute.HTTP_ISSUER_DN.getName()));
    }
}

