/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.calcite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.csv.CSVRecordSetWriter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.QueryRecord;
import org.apache.nifi.processors.standard.calcite.RecordResultSetOutputStreamCallback;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestRecordResultSetOutputStreamCallback {
    @Test
    void testResultSetClosed() throws IOException, SQLException, InitializationException {
        TestRunner runner = TestRunners.newTestRunner(QueryRecord.class);
        String writerId = "record-writer";
        runner.setProperty("record-writer", "record-writer");
        CSVRecordSetWriter writerService = new CSVRecordSetWriter();
        runner.addControllerService("record-writer", (ControllerService)writerService);
        runner.setProperty((ControllerService)writerService, "schema-access-strategy", "inherit-record-schema");
        runner.enableControllerService((ControllerService)writerService);
        ResultSet resultSet = this.getResultSet();
        RecordField fieldFirst = new RecordField("first", RecordFieldType.STRING.getDataType());
        RecordField fieldLast = new RecordField("last", RecordFieldType.STRING.getDataType());
        SimpleRecordSchema writerSchema = new SimpleRecordSchema(Arrays.asList(fieldFirst, fieldLast));
        FlowFile flowFile = (FlowFile)Mockito.mock(FlowFile.class);
        Mockito.when((Object)flowFile.getAttributes()).thenReturn(new LinkedHashMap());
        RecordResultSetOutputStreamCallback writer = new RecordResultSetOutputStreamCallback((ComponentLog)runner.getLogger(), resultSet, (RecordSchema)writerSchema, Integer.valueOf(0), Integer.valueOf(0), (RecordSetWriterFactory)writerService, flowFile.getAttributes());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        writer.process((OutputStream)os);
        Assertions.assertTrue((boolean)resultSet.isClosed());
    }

    private ResultSet getResultSet() throws SQLException {
        DriverManager.registerDriver((Driver)new org.apache.calcite.jdbc.Driver());
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        calciteConnection.getRootSchema().add("TEST", (Schema)new ReflectiveSchema((Object)new CalciteTestSchema()));
        Statement statement = calciteConnection.createStatement();
        return statement.executeQuery("SELECT * FROM TEST.PERSONS");
    }

    public static class CalciteTestSchema
    extends AbstractSchema {
        public Person[] PERSONS = new Person[]{new Person("Joe", "Smith"), new Person("Bob", "Jones")};
    }

    public static class Person {
        public final String first;
        public final String last;

        public Person(String first, String last) {
            this.first = first;
            this.last = last;
        }
    }
}

