/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.RouteText;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRouteText {
    @Test
    public void testRelationships() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES);
        runner.setProperty("simple", "start");
        runner.run();
        Set relationshipSet = runner.getProcessor().getRelationships();
        HashSet<String> expectedRelationships = new HashSet<String>(Arrays.asList("matched", "unmatched", "original"));
        Assertions.assertEquals((int)expectedRelationships.size(), (int)relationshipSet.size());
        for (Relationship relationship : relationshipSet) {
            Assertions.assertTrue((boolean)expectedRelationships.contains(relationship.getName()));
        }
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHING_PROPERTY_NAME);
        relationshipSet = runner.getProcessor().getRelationships();
        expectedRelationships = new HashSet<String>(Arrays.asList("simple", "unmatched", "original"));
        Assertions.assertEquals((int)expectedRelationships.size(), (int)relationshipSet.size());
        for (Relationship relationship : relationshipSet) {
            Assertions.assertTrue((boolean)expectedRelationships.contains(relationship.getName()));
        }
        runner.run();
    }

    @Test
    public void testSeparationStrategyNotKnown() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.assertNotValid();
    }

    @Test
    public void testNotText() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty("simple", "start");
        Set relationshipSet = runner.getProcessor().getRelationships();
        HashSet<String> expectedRelationships = new HashSet<String>(Arrays.asList("simple", "unmatched", "original"));
        Assertions.assertEquals((int)expectedRelationships.size(), (int)relationshipSet.size());
        for (Relationship relationship : relationshipSet) {
            Assertions.assertTrue((boolean)expectedRelationships.contains(relationship.getName()));
        }
        runner.enqueue(Paths.get("src/test/resources/simple.jpg", new String[0]));
        runner.run();
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outOriginal = (MockFlowFile)runner.getFlowFilesForRelationship("original").get(0);
        outOriginal.assertContentEquals(Paths.get("src/test/resources/simple.jpg", new String[0]));
    }

    @Test
    public void testInvalidRegex() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.MATCHES_REGULAR_EXPRESSION);
        runner.setProperty("simple", "[");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        Assertions.assertThrows(AssertionError.class, () -> runner.run());
    }

    @Test
    public void testSimpleDefaultStarts() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty("simple", "start");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleCaseSensitiveStartsMatch() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty(RouteText.IGNORE_CASE, "false");
        runner.setProperty("simple", "start");
        runner.enqueue("STart middle end\nstart middle end".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("STart middle end\n".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleCaseInsensitiveStartsMatch() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty(RouteText.IGNORE_CASE, "true");
        runner.setProperty("simple", "start");
        runner.enqueue("start middle end\nSTart middle end".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 0);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\nSTart middle end".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleDefaultEnd() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.ENDS_WITH);
        runner.setProperty("simple", "end");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testRouteLineToMultipleRelationships() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS);
        runner.setProperty("t", "t");
        runner.setProperty("e", "e");
        runner.setProperty("z", "z");
        String originalText = "start middle end\nnot match";
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("t", 1);
        runner.assertTransferCount("e", 1);
        runner.assertTransferCount("z", 0);
        runner.assertTransferCount("unmatched", 0);
        runner.assertTransferCount("original", 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship("t").get(0)).assertContentEquals("start middle end\nnot match");
        ((MockFlowFile)runner.getFlowFilesForRelationship("e").get(0)).assertContentEquals("start middle end\n");
        runner.getFlowFilesForRelationship("z").isEmpty();
        ((MockFlowFile)runner.getFlowFilesForRelationship("original").get(0)).assertContentEquals("start middle end\nnot match");
    }

    @Test
    public void testGroupSameRelationship() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS);
        runner.setProperty(RouteText.GROUPING_REGEX, "(.*?),.*");
        runner.setProperty("o", "o");
        String originalText = "1,hello\n2,world\n1,good-bye";
        runner.enqueue("1,hello\n2,world\n1,good-bye".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("o", 2);
        runner.assertTransferCount("unmatched", 0);
        runner.assertTransferCount("original", 1);
        List list = runner.getFlowFilesForRelationship("o");
        boolean found1 = false;
        boolean found2 = false;
        for (MockFlowFile mff : list) {
            if (mff.getAttribute("RouteText.Group").equals("1")) {
                mff.assertContentEquals("1,hello\n1,good-bye");
                found1 = true;
                continue;
            }
            mff.assertAttributeEquals("RouteText.Group", "2");
            mff.assertContentEquals("2,world\n");
            found2 = true;
        }
        Assertions.assertTrue((boolean)found1);
        Assertions.assertTrue((boolean)found2);
    }

    @Test
    public void testMultipleGroupsSameRelationship() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS);
        runner.setProperty(RouteText.GROUPING_REGEX, "(.*?),(.*?),.*");
        runner.setProperty("o", "o");
        String originalText = "1,5,hello\n2,5,world\n1,8,good-bye\n1,5,overt";
        runner.enqueue("1,5,hello\n2,5,world\n1,8,good-bye\n1,5,overt".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("o", 3);
        runner.assertTransferCount("unmatched", 0);
        runner.assertTransferCount("original", 1);
        List list = runner.getFlowFilesForRelationship("o");
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        for (MockFlowFile mff : list) {
            if (mff.getAttribute("RouteText.Group").equals("1, 5")) {
                mff.assertContentEquals("1,5,hello\n1,5,overt");
                found1 = true;
                continue;
            }
            if (mff.getAttribute("RouteText.Group").equals("2, 5")) {
                mff.assertContentEquals("2,5,world\n");
                found2 = true;
                continue;
            }
            mff.assertAttributeEquals("RouteText.Group", "1, 8");
            mff.assertContentEquals("1,8,good-bye\n");
            found3 = true;
        }
        Assertions.assertTrue((boolean)found1);
        Assertions.assertTrue((boolean)found2);
        Assertions.assertTrue((boolean)found3);
    }

    @Test
    public void testGroupDifferentRelationships() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS);
        runner.setProperty(RouteText.GROUPING_REGEX, "(.*?),.*");
        runner.setProperty("l", "l");
        String originalText = "1,hello\n2,world\n1,good-bye\n3,ciao";
        runner.enqueue("1,hello\n2,world\n1,good-bye\n3,ciao".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("l", 2);
        runner.assertTransferCount("unmatched", 2);
        runner.assertTransferCount("original", 1);
        List lFlowFiles = runner.getFlowFilesForRelationship("l");
        boolean found1 = false;
        boolean found2 = false;
        for (MockFlowFile mff : lFlowFiles) {
            if (mff.getAttribute("RouteText.Group").equals("1")) {
                mff.assertContentEquals("1,hello\n");
                found1 = true;
                continue;
            }
            mff.assertAttributeEquals("RouteText.Group", "2");
            mff.assertContentEquals("2,world\n");
            found2 = true;
        }
        Assertions.assertTrue((boolean)found1);
        Assertions.assertTrue((boolean)found2);
        List unmatchedFlowFiles = runner.getFlowFilesForRelationship("unmatched");
        found1 = false;
        boolean found3 = false;
        for (MockFlowFile mff : unmatchedFlowFiles) {
            if (mff.getAttribute("RouteText.Group").equals("1")) {
                mff.assertContentEquals("1,good-bye\n");
                found1 = true;
                continue;
            }
            mff.assertAttributeEquals("RouteText.Group", "3");
            mff.assertContentEquals("3,ciao");
            found3 = true;
        }
        Assertions.assertTrue((boolean)found1);
        Assertions.assertTrue((boolean)found3);
    }

    @Test
    public void testSimpleDefaultContains() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS);
        runner.setProperty("simple", "middle");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleContainsIgnoreCase() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS);
        runner.setProperty(RouteText.IGNORE_CASE, "true");
        runner.setProperty("simple", "miDDlE");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleDefaultEquals() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.EQUALS);
        runner.setProperty("simple", "start middle end");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleDefaultMatchRegularExpression() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.MATCHES_REGULAR_EXPRESSION);
        runner.setProperty("simple", ".*(mid).*");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleDefaultContainRegularExpression() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS_REGULAR_EXPRESSION);
        runner.setProperty("simple", "(m.d)");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAnyStarts() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES);
        runner.setProperty("simple", "start");
        runner.setProperty("no", "no match");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAnyEnds() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.ENDS_WITH);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES);
        runner.setProperty("simple", "end");
        runner.setProperty("no", "no match");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAnyEquals() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.EQUALS);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES);
        runner.setProperty("simple", "start middle end");
        runner.setProperty("no", "no match");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAnyMatchRegularExpression() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.MATCHES_REGULAR_EXPRESSION);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES);
        runner.setProperty("simple", ".*(m.d).*");
        runner.setProperty("no", "no match");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAnyContainRegularExpression() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS_REGULAR_EXPRESSION);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ANY_PROPERTY_MATCHES);
        runner.setProperty("simple", "(m.d)");
        runner.setProperty("no", "no match");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAllStarts() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH);
        runner.setProperty("simple", "start middle");
        runner.setProperty("second", "star");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAllEnds() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.ENDS_WITH);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH);
        runner.setProperty("simple", "middle end");
        runner.setProperty("second", "nd");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAllEquals() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.EQUALS);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH);
        runner.setProperty("simple", "start middle end");
        runner.setProperty("second", "start middle end");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAllMatchRegularExpression() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.MATCHES_REGULAR_EXPRESSION);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH);
        runner.setProperty("simple", ".*(m.d).*");
        runner.setProperty("second", ".*(t.*m).*");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSimpleAllContainRegularExpression() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS_REGULAR_EXPRESSION);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHED_WHEN_ALL_PROPERTIES_MATCH);
        runner.setProperty("simple", "(m.d)");
        runner.setProperty("second", "(t.*m)");
        runner.enqueue("start middle end\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("matched", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("matched").get(0);
        outMatched.assertContentEquals("start middle end\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testRouteOnPropertiesStartsWindowsNewLine() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty("simple", "start");
        runner.enqueue("start middle end\r\nnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\r\n".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testRouteOnPropertiesStartsJustCarriageReturn() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty("simple", "start");
        runner.enqueue("start middle end\rnot match".getBytes("UTF-8"));
        runner.run();
        runner.assertTransferCount("simple", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship("simple").get(0);
        outMatched.assertContentEquals("start middle end\r".getBytes("UTF-8"));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        outUnmatched.assertContentEquals("not match".getBytes("UTF-8"));
    }

    @Test
    public void testSatisfiesExpression() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.SATISFIES_EXPRESSION);
        runner.setProperty("empty", "${incomplete expression");
        runner.assertNotValid();
        runner.setProperty("empty", "${line:isEmpty()}");
        runner.setProperty("third-line", "${lineNo:equals(3)}");
        runner.setProperty("second-field-you", "${line:getDelimitedField(2):trim():equals('you')}");
        runner.enqueue("hello\n\ngood-bye, you\n    \t\t\n");
        runner.run();
        runner.assertTransferCount("empty", 1);
        runner.assertTransferCount("third-line", 1);
        runner.assertTransferCount("second-field-you", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship("empty").get(0)).assertContentEquals("\n    \t\t\n");
        ((MockFlowFile)runner.getFlowFilesForRelationship("third-line").get(0)).assertContentEquals("good-bye, you\n");
        ((MockFlowFile)runner.getFlowFilesForRelationship("second-field-you").get(0)).assertContentEquals("good-bye, you\n");
    }

    @Test
    public void testJson() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.STARTS_WITH);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHING_PROPERTY_NAME);
        runner.setProperty("greeting", "\"greeting\"");
        runner.setProperty("address", "\"address\"");
        runner.enqueue(Paths.get("src/test/resources/TestJson/json-sample.json", new String[0]));
        runner.run();
        runner.assertTransferCount("greeting", 1);
        runner.assertTransferCount("address", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outGreeting = (MockFlowFile)runner.getFlowFilesForRelationship("greeting").get(0);
        String outGreetingString = new String(runner.getContentAsByteArray(outGreeting));
        Assertions.assertEquals((int)7, (int)TestRouteText.countLines(outGreetingString));
        MockFlowFile outAddress = (MockFlowFile)runner.getFlowFilesForRelationship("address").get(0);
        String outAddressString = new String(runner.getContentAsByteArray(outAddress));
        Assertions.assertEquals((int)7, (int)TestRouteText.countLines(outAddressString));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        String outUnmatchedString = new String(runner.getContentAsByteArray(outUnmatched));
        Assertions.assertEquals((int)400, (int)TestRouteText.countLines(outUnmatchedString));
        MockFlowFile outOriginal = (MockFlowFile)runner.getFlowFilesForRelationship("original").get(0);
        outOriginal.assertContentEquals(Paths.get("src/test/resources/TestJson/json-sample.json", new String[0]));
    }

    @Test
    public void testXml() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteText());
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.CONTAINS);
        runner.setProperty(RouteText.ROUTE_STRATEGY, RouteText.ROUTE_TO_MATCHING_PROPERTY_NAME);
        runner.setProperty("NodeType", "name=\"NodeType\"");
        runner.setProperty("element", "<xs:element");
        runner.setProperty("name", "name=");
        runner.enqueue(Paths.get("src/test/resources/TestXml/XmlBundle.xsd", new String[0]));
        runner.run();
        runner.assertTransferCount("NodeType", 1);
        runner.assertTransferCount("element", 1);
        runner.assertTransferCount("name", 1);
        runner.assertTransferCount("unmatched", 1);
        runner.assertTransferCount("original", 1);
        MockFlowFile outNode = (MockFlowFile)runner.getFlowFilesForRelationship("NodeType").get(0);
        String outNodeString = new String(runner.getContentAsByteArray(outNode));
        Assertions.assertEquals((int)1, (int)TestRouteText.countLines(outNodeString));
        MockFlowFile outElement = (MockFlowFile)runner.getFlowFilesForRelationship("element").get(0);
        String outElementString = new String(runner.getContentAsByteArray(outElement));
        Assertions.assertEquals((int)4, (int)TestRouteText.countLines(outElementString));
        MockFlowFile outName = (MockFlowFile)runner.getFlowFilesForRelationship("name").get(0);
        String outNameString = new String(runner.getContentAsByteArray(outName));
        Assertions.assertEquals((int)7, (int)TestRouteText.countLines(outNameString));
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship("unmatched").get(0);
        String outUnmatchedString = new String(runner.getContentAsByteArray(outUnmatched));
        Assertions.assertEquals((int)26, (int)TestRouteText.countLines(outUnmatchedString));
        MockFlowFile outOriginal = (MockFlowFile)runner.getFlowFilesForRelationship("original").get(0);
        outOriginal.assertContentEquals(Paths.get("src/test/resources/TestXml/XmlBundle.xsd", new String[0]));
    }

    @Test
    public void testPatternCache() {
        RouteText routeText = new RouteText();
        TestRunner runner = TestRunners.newTestRunner((Processor)routeText);
        runner.setProperty(RouteText.MATCH_STRATEGY, RouteText.MATCHES_REGULAR_EXPRESSION);
        String simpleRelationship = "simple";
        runner.setProperty("simple", ".*(${someValue}).*");
        int iterations = 2;
        runner.enqueue("some text", Collections.singletonMap("someValue", "a value"));
        runner.enqueue("some other text", Collections.singletonMap("someValue", "a value"));
        runner.run(2);
        Assertions.assertEquals((int)1, (int)routeText.patternsCache.size());
        for (int i = 0; i < 2; ++i) {
            String iString = Long.toString(i);
            runner.enqueue("some text with " + iString + "in it", Collections.singletonMap("someValue", iString));
            runner.run();
        }
        runner.assertTransferCount("simple", 2);
        runner.assertTransferCount(RouteText.REL_MATCH, 0);
        runner.assertTransferCount(RouteText.REL_NO_MATCH, 2);
        runner.assertTransferCount(RouteText.REL_ORIGINAL, 4);
        runner.setProperty(RouteText.IGNORE_CASE, "true");
        Assertions.assertEquals((int)0, (int)routeText.patternsCache.size(), (String)"Pattern cache is not cleared after changing IGNORE_CASE");
    }

    public static int countLines(String str) {
        String lineSeparator;
        if (str == null || str.isEmpty()) {
            return 0;
        }
        if (str.contains("\r\n")) {
            lineSeparator = "\r\n";
        } else if (str.contains("\n")) {
            lineSeparator = "\n";
        } else if (str.contains("\r")) {
            lineSeparator = "\r";
        } else {
            return 1;
        }
        int lines = 0;
        int pos = 0;
        while ((pos = str.indexOf(lineSeparator, pos) + 1) != 0) {
            ++lines;
        }
        return lines;
    }
}

