/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ParseCEF;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParseCEF {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String sample1 = "CEF:0|TestVendor|TestProduct|TestVersion|TestEventClassID|TestName|Low|rt=Feb 09 2015 00:27:43 UTC cn3Label=Test Long cn3=9223372036854775807 cfp1=1.234 cfp1Label=Test FP Number smac=00:00:0c:07:ac:00 c6a3=2001:cdba::3257:9652 c6a3Label=Test IPv6 cs1Label=Test String cs1=test test test chocolate destinationTranslatedAddress=123.123.123.123 deviceCustomDate1=Feb 06 2015 13:27:43 dpt=1234 agt=123.123.0.124 dlat=40.366633";
    private static final String sample2 = "CEF:0|TestVendor|TestProduct|TestVersion|TestEventClassID|TestName|Low|rt=Feb 09 2015 00:27:43 UTC cn3Label=Test Long cn3=9223372036854775807 cfp1=1.234 cfp1Label=Test FP Number smac=00:00:0c:07:ac:00 c6a3=2001:cdba::3257:9652 c6a3Label=Test IPv6 cs1Label=Test String cs1=test test test chocolate destinationTranslatedAddress=123.123.123.123 deviceCustomDate1=Feb 06 2015 13:27:43 dpt=1234 agt=123.123.0.124 dlat=40.366633 cs2Label=JSON payload cs2={\"test_test_test\": \"chocolate!\", \"what?!?\": \"Simple! test test test chocolate!\"}";

    @Test
    public void testInvalidMessage() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.enqueue("test test test chocolate\n".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_FAILURE, 1);
    }

    @Test
    public void testSuccessfulParseToAttributes() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-attribute");
        runner.enqueue(sample1.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        mff.assertAttributeEquals("cef.extension.rt", this.sdf.format(new Date(1423441663000L)));
        mff.assertAttributeEquals("cef.extension.cn3Label", "Test Long");
        mff.assertAttributeEquals("cef.extension.cn3", "9223372036854775807");
        mff.assertAttributeEquals("cef.extension.cfp1", "1.234");
        mff.assertAttributeEquals("cef.extension.cfp1Label", "Test FP Number");
        mff.assertAttributeEquals("cef.extension.smac", "00:00:0c:07:ac:00");
        mff.assertAttributeEquals("cef.extension.c6a3", "2001:cdba:0:0:0:0:3257:9652");
        mff.assertAttributeEquals("cef.extension.c6a3Label", "Test IPv6");
        mff.assertAttributeEquals("cef.extension.cs1Label", "Test String");
        mff.assertAttributeEquals("cef.extension.cs1", "test test test chocolate");
        mff.assertAttributeEquals("cef.extension.destinationTranslatedAddress", "123.123.123.123");
        mff.assertContentEquals(sample1.getBytes());
        long eventTime = 1423229263000L;
        int offset = TimeZone.getDefault().getOffset(eventTime);
        this.sdf.setTimeZone(TimeZone.getDefault());
        String prettyEvent = this.sdf.format(new Date(eventTime - (long)offset));
        mff.assertAttributeEquals("cef.extension.deviceCustomDate1", prettyEvent);
        mff.assertAttributeEquals("cef.extension.dpt", "1234");
        mff.assertAttributeEquals("cef.extension.agt", "123.123.0.124");
        mff.assertAttributeEquals("cef.extension.dlat", "40.366633");
    }

    @Test
    public void testSuccessfulParseToAttributesWithUTC() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-attribute");
        runner.setProperty(ParseCEF.TIME_REPRESENTATION, "UTC");
        runner.enqueue(sample1.getBytes());
        runner.run();
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        mff.assertAttributeEquals("cef.extension.rt", this.sdf.format(new Date(1423441663000L)));
        long eventTime = 1423229263000L;
        int offset = TimeZone.getDefault().getOffset(eventTime);
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String prettyEvent = this.sdf.format(new Date(eventTime - (long)offset));
        mff.assertAttributeEquals("cef.extension.deviceCustomDate1", prettyEvent);
        mff.assertContentEquals(sample1.getBytes());
    }

    @Test
    public void testSuccessfulParseToContent() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-content");
        runner.enqueue(sample1.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        byte[] rawJson = mff.toByteArray();
        JsonNode results = new ObjectMapper().readTree(rawJson);
        JsonNode header = results.get("header");
        JsonNode extension = results.get("extension");
        Assertions.assertEquals((Object)"TestVendor", (Object)header.get("deviceVendor").asText());
        Assertions.assertEquals((Object)this.sdf.format(new Date(1423441663000L)), (Object)extension.get("rt").asText());
        Assertions.assertEquals((Object)"Test Long", (Object)extension.get("cn3Label").asText());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)extension.get("cn3").asLong());
        Assertions.assertEquals((float)extension.get("cfp1").floatValue(), (float)1.234f);
        Assertions.assertEquals((Object)"Test FP Number", (Object)extension.get("cfp1Label").asText());
        Assertions.assertEquals((Object)"00:00:0c:07:ac:00", (Object)extension.get("smac").asText());
        Assertions.assertEquals((Object)"2001:cdba:0:0:0:0:3257:9652", (Object)extension.get("c6a3").asText());
        Assertions.assertEquals((Object)"Test IPv6", (Object)extension.get("c6a3Label").asText());
        Assertions.assertEquals((Object)"123.123.123.123", (Object)extension.get("destinationTranslatedAddress").asText());
        Assertions.assertEquals((Object)"Test String", (Object)extension.get("cs1Label").asText());
        Assertions.assertEquals((Object)"test test test chocolate", (Object)extension.get("cs1").asText());
    }

    @Test
    public void testSuccessfulParseToContentWhenCEFContainsJSON() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-content");
        runner.enqueue(sample2.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        byte[] rawJson = mff.toByteArray();
        JsonNode results = new ObjectMapper().readTree(rawJson);
        JsonNode header = results.get("header");
        JsonNode extension = results.get("extension");
        Assertions.assertEquals((Object)"TestVendor", (Object)header.get("deviceVendor").asText());
        Assertions.assertEquals((Object)this.sdf.format(new Date(1423441663000L)), (Object)extension.get("rt").asText());
        Assertions.assertEquals((Object)"Test Long", (Object)extension.get("cn3Label").asText());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)extension.get("cn3").asLong());
        Assertions.assertEquals((float)extension.get("cfp1").floatValue(), (float)1.234f);
        Assertions.assertEquals((Object)"Test FP Number", (Object)extension.get("cfp1Label").asText());
        Assertions.assertEquals((Object)"00:00:0c:07:ac:00", (Object)extension.get("smac").asText());
        Assertions.assertEquals((Object)"2001:cdba:0:0:0:0:3257:9652", (Object)extension.get("c6a3").asText());
        Assertions.assertEquals((Object)"Test IPv6", (Object)extension.get("c6a3Label").asText());
        Assertions.assertEquals((Object)"Test String", (Object)extension.get("cs1Label").asText());
        Assertions.assertEquals((Object)"test test test chocolate", (Object)extension.get("cs1").asText());
        Assertions.assertEquals((Object)"123.123.123.123", (Object)extension.get("destinationTranslatedAddress").asText());
        JsonNode inner = new ObjectMapper().readTree(extension.get("cs2").asText());
        Assertions.assertEquals((Object)"chocolate!", (Object)inner.get("test_test_test").asText());
    }

    @Test
    public void testSuccessfulParseToContentUTC() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-content");
        runner.setProperty(ParseCEF.TIME_REPRESENTATION, "UTC");
        runner.enqueue(sample1.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        byte[] rawJson = mff.toByteArray();
        JsonNode results = new ObjectMapper().readTree(rawJson);
        JsonNode extension = results.get("extension");
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assertions.assertEquals((Object)this.sdf.format(new Date(1423441663000L)), (Object)extension.get("rt").asText());
        long eventTime = 1423229263000L;
        int offset = TimeZone.getDefault().getOffset(eventTime);
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String prettyEvent = this.sdf.format(new Date(eventTime - (long)offset));
        Assertions.assertEquals((Object)prettyEvent, (Object)extension.get("deviceCustomDate1").asText());
    }

    @Test
    public void testNonEnglishDate() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-attribute");
        runner.setProperty(ParseCEF.DATETIME_REPRESENTATION, "fr-FR");
        runner.assertValid();
        String sample = sample1.replace("Feb", "f\u00e9vr.");
        runner.enqueue(sample);
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff1 = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        mff1.assertAttributeEquals("cef.extension.rt", this.sdf.format(new Date(1423441663000L)));
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-attribute");
        runner.setProperty(ParseCEF.DATETIME_REPRESENTATION, "et-EE");
        runner.assertValid();
        sample = sample1.replace("Feb", "veebr");
        runner.enqueue(sample);
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 2);
        MockFlowFile mff2 = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        mff2.assertAttributeEquals("cef.extension.rt", this.sdf.format(new Date(1423441663000L)));
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-attribute");
        runner.setProperty(ParseCEF.DATETIME_REPRESENTATION, "ja-JP");
        runner.assertValid();
        SimpleDateFormat dateFormat = new SimpleDateFormat("LLLL", Locale.forLanguageTag("ja-JP"));
        String jpFeb = dateFormat.format(1423441663000L);
        sample = sample1.replace("Feb", jpFeb);
        runner.enqueue(sample);
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 3);
        MockFlowFile mff3 = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        mff3.assertAttributeEquals("cef.extension.rt", this.sdf.format(new Date(1423441663000L)));
    }

    @Test
    public void testCustomValidator() {
        Locale[] availableLocales;
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-content");
        runner.setProperty(ParseCEF.TIME_REPRESENTATION, "UTC");
        runner.setProperty(ParseCEF.DATETIME_REPRESENTATION, "SPANGLISH");
        runner.assertNotValid();
        runner.setProperty(ParseCEF.DATETIME_REPRESENTATION, "en-US");
        runner.assertValid();
        for (Locale listedLocale : availableLocales = Locale.getAvailableLocales()) {
            if (listedLocale.toString().isEmpty()) continue;
            String input = listedLocale.toLanguageTag();
            runner.setProperty(ParseCEF.DATETIME_REPRESENTATION, input);
            runner.assertValid();
        }
    }

    @Test
    public void testIncludeCustomExtensions() throws Exception {
        String sample3 = "<159>Aug 09 08:56:28 8.8.8.8 CEF:0|x|Security|x.x.0|20|Transaction blocked|7| act=blocked app=https dvc=8.8.8.8 dst=8.8.8.8 dhost=www.flynas.com dpt=443 src=8.8.8.8 spt=53475 suser=x UserPath=LDAP://8.8.8.8 OU\\\\=1 - x x x x,OU\\\\=x x,DC\\\\=x,DC\\\\=com/x destinationTranslatedPort=36436 rt=1628488588000 in=65412 out=546 requestMethod=GET  category=20 http_response=200 http_proxy_status_code=302 duration=13 requestClientApplication=Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0;) like Gecko reason=-  cs1Label=Policy cs1=x x**x cs2Label=DynCat cs2=0 cs3Label=ContentType cs3=font/otf cn1Label=DispositionCode cn1=1047 cn2Label=ScanDuration cn2=13 request=https://www.flynas.com/css/fonts/GothamRounded-Book.otf URLRefer=https://www.flynas.com/en";
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-content");
        runner.setProperty(ParseCEF.TIME_REPRESENTATION, "UTC");
        runner.setProperty(ParseCEF.INCLUDE_CUSTOM_EXTENSIONS, "true");
        runner.enqueue(sample3.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        byte[] rawJson = mff.toByteArray();
        JsonNode results = new ObjectMapper().readTree(rawJson);
        JsonNode extension = results.get("extension");
        Assertions.assertEquals((int)200, (int)extension.get("http_response").asInt());
    }

    @Test
    public void testAcceptEmptyExtensions() throws Exception {
        String sample3 = "CEF:0|TestVendor|TestProduct|TestVersion|TestEventClassID|TestName|Low|rt=Feb 09 2015 00:27:43 UTC cn3Label= cn3= cfp1=1.234 cfp1Label=Test FP Number smac=00:00:0c:07:ac:00 c6a3=2001:cdba::3257:9652 c6a3Label=Test IPv6 cs1Label=Test String cs1=test test test chocolate destinationTranslatedAddress=123.123.123.123 deviceCustomDate1=Feb 06 2015 13:27:43 dpt= agt= dlat=";
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseCEF());
        runner.setProperty(ParseCEF.FIELDS_DESTINATION, "flowfile-content");
        runner.setProperty(ParseCEF.TIME_REPRESENTATION, "UTC");
        runner.setProperty(ParseCEF.INCLUDE_CUSTOM_EXTENSIONS, "true");
        runner.setProperty(ParseCEF.ACCEPT_EMPTY_EXTENSIONS, "true");
        runner.enqueue(sample3.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseCEF.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)runner.getFlowFilesForRelationship(ParseCEF.REL_SUCCESS).get(0);
        byte[] rawJson = mff.toByteArray();
        JsonNode results = new ObjectMapper().readTree(rawJson);
        JsonNode extensions = results.get("extension");
        Assertions.assertTrue((boolean)extensions.has("cn3"));
        Assertions.assertTrue((boolean)extensions.get("cn3").isNull());
        Assertions.assertTrue((boolean)extensions.has("cn3Label"));
        Assertions.assertTrue((boolean)extensions.get("cn3Label").asText().isEmpty());
    }
}

