/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.TailFile;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class AbstractTestTailFileScenario {
    public static final String TEST_DIRECTORY = "testTailFileScenario";
    public static final String TARGET_FILE_PATH = "target/testTailFileScenario/in.txt";
    public static final String NUL_SUBSTITUTE = "X";
    public static final Long POST_ROLLOVER_WAIT_PERSIOD_SECONDS = 100L;
    protected File file;
    protected RandomAccessFile randomAccessFile;
    private TailFile processor;
    protected TestRunner runner;
    private AtomicBoolean stopAfterEachTrigger;
    protected AtomicLong wordIndex;
    protected AtomicLong rolloverIndex;
    protected AtomicLong timeAdjustment;
    protected AtomicBoolean rolloverSwitchPending;
    protected LinkedList<Long> nulPositions;
    protected List<String> expected;
    private Random random;

    @BeforeEach
    public void setUp() throws IOException {
        this.clean();
        File directory = new File("target/testTailFileScenario");
        if (!directory.exists()) {
            Assertions.assertTrue((boolean)directory.mkdirs());
        }
        this.createTargetFile();
        this.randomAccessFile = new RandomAccessFile(this.file, "rw");
        this.processor = new TailFile(){

            public long getCurrentTimeMs() {
                return super.getCurrentTimeMs() + AbstractTestTailFileScenario.this.timeAdjustment.get();
            }
        };
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.runner.setProperty(TailFile.FILENAME, TARGET_FILE_PATH);
        this.runner.setProperty(TailFile.ROLLING_FILENAME_PATTERN, "in.txt*");
        this.runner.setProperty(TailFile.REREAD_ON_NUL, "true");
        this.runner.setProperty(TailFile.POST_ROLLOVER_TAIL_PERIOD, POST_ROLLOVER_WAIT_PERSIOD_SECONDS + " sec");
        this.runner.assertValid();
        this.runner.run(1, false, true);
        this.stopAfterEachTrigger = new AtomicBoolean(false);
        this.nulPositions = new LinkedList();
        this.wordIndex = new AtomicLong(1L);
        this.rolloverIndex = new AtomicLong(1L);
        this.timeAdjustment = new AtomicLong(0L);
        this.rolloverSwitchPending = new AtomicBoolean(false);
        this.expected = new ArrayList<String>();
        this.random = new Random();
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
        this.processor.cleanup((ProcessContext)new MockProcessContext((ConfigurableComponent)this.processor));
    }

    public void testScenario(List<Action> actions) throws Exception {
        this.testScenario(actions, false);
        this.tearDown();
        this.setUp();
        this.testScenario(actions, true);
    }

    public void testScenario(List<Action> actions, boolean stopAfterEachTrigger) throws Exception {
        this.stopAfterEachTrigger.set(stopAfterEachTrigger);
        for (Action action : actions) {
            action.run(this);
        }
        this.overwriteRemainingNuls();
        Action.WRITE_NEW_LINE.run(this);
        Action.TRIGGER.run(this);
        Action.EXPIRE_ROLLOVER_WAIT_PERIOD.run(this);
        Action.TRIGGER.run(this);
        Action.TRIGGER.run(this);
        List flowFiles = this.runner.getFlowFilesForRelationship(TailFile.REL_SUCCESS);
        List actual = flowFiles.stream().map(MockFlowFile::toByteArray).map(String::new).collect(Collectors.toList());
        Assertions.assertEquals((Object)this.expected.stream().collect(Collectors.joining()), (Object)actual.stream().collect(Collectors.joining()), (String)(stopAfterEachTrigger + " " + actions.toString()));
    }

    private void clean() {
        this.cleanFiles("target/testTailFileScenario");
    }

    private void cleanFiles(String directory) {
        File targetDir = new File(directory);
        if (targetDir.exists()) {
            for (File file : targetDir.listFiles()) {
                file.delete();
            }
        }
    }

    private void createTargetFile() throws IOException {
        this.file = new File(TARGET_FILE_PATH);
        this.file.delete();
        Assertions.assertTrue((boolean)this.file.createNewFile());
    }

    private void overwriteRemainingNuls() throws Exception {
        while (!this.nulPositions.isEmpty()) {
            Action.OVERWRITE_NUL.run(this);
        }
    }

    private void writeWord() throws IOException {
        String word = "-word_" + this.wordIndex.getAndIncrement() + "-";
        this.randomAccessFile.write(word.getBytes());
        this.expected.add(word);
    }

    private void writeNewLine() throws IOException {
        this.randomAccessFile.write("\n".getBytes());
        this.expected.add("\n");
    }

    private void writeNul() throws IOException {
        this.nulPositions.add(this.randomAccessFile.getFilePointer());
        this.randomAccessFile.write("\u0000".getBytes());
        this.expected.add(NUL_SUBSTITUTE);
    }

    private void overwriteNul() throws IOException {
        if (!this.nulPositions.isEmpty()) {
            Long nulPosition = this.nulPositions.remove(this.random.nextInt(this.nulPositions.size()));
            long currentPosition = this.randomAccessFile.getFilePointer();
            this.randomAccessFile.seek(nulPosition);
            this.randomAccessFile.write(NUL_SUBSTITUTE.getBytes());
            this.randomAccessFile.seek(currentPosition);
        }
    }

    private void trigger() {
        this.runner.run(1, this.stopAfterEachTrigger.get(), false);
    }

    private void rollover() throws IOException {
        File rolledOverFile = new File(this.file.getParentFile(), this.file.getName() + "." + this.rolloverIndex.getAndIncrement());
        this.file.renameTo(rolledOverFile);
        this.createTargetFile();
        this.rolloverSwitchPending.set(true);
    }

    private void switchFile() throws Exception {
        if (this.rolloverSwitchPending.get()) {
            this.overwriteRemainingNuls();
            this.randomAccessFile.close();
            this.randomAccessFile = new RandomAccessFile(this.file, "rw");
            this.rolloverSwitchPending.set(false);
        }
    }

    private void expireRolloverWaitPeriod() throws Exception {
        long waitPeriod = POST_ROLLOVER_WAIT_PERSIOD_SECONDS * 1000L + 100L;
        this.timeAdjustment.set(this.timeAdjustment.get() + waitPeriod);
    }

    protected static enum Action {
        WRITE_WORD(AbstractTestTailFileScenario::writeWord),
        WRITE_NEW_LINE(AbstractTestTailFileScenario::writeNewLine),
        WRITE_NUL(AbstractTestTailFileScenario::writeNul),
        OVERWRITE_NUL(AbstractTestTailFileScenario::overwriteNul),
        TRIGGER(AbstractTestTailFileScenario::trigger),
        ROLLOVER(AbstractTestTailFileScenario::rollover),
        SWITCH_FILE(AbstractTestTailFileScenario::switchFile),
        EXPIRE_ROLLOVER_WAIT_PERIOD(AbstractTestTailFileScenario::expireRolloverWaitPeriod);

        private final ActionRunner actionRunner;

        private Action(ActionRunner actionRunner) {
            this.actionRunner = actionRunner;
        }

        void run(AbstractTestTailFileScenario currentTest) throws Exception {
            this.actionRunner.runAction(currentTest);
        }
    }

    private static interface ActionRunner {
        public void runAction(AbstractTestTailFileScenario var1) throws Exception;
    }
}

