/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.AbstractEncryptor;
import org.apache.nifi.security.util.crypto.BcryptCipherProvider;
import org.apache.nifi.security.util.crypto.CipherProviderFactory;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.NiFiLegacyCipherProvider;
import org.apache.nifi.security.util.crypto.PBECipherProvider;
import org.apache.nifi.security.util.crypto.PBKDF2CipherProvider;
import org.apache.nifi.security.util.crypto.RandomIVPBECipherProvider;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordBasedEncryptor
extends AbstractEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(PasswordBasedEncryptor.class);
    private EncryptionMethod encryptionMethod;
    private PBEKeySpec password;
    private KeyDerivationFunction kdf;
    private static final int DEFAULT_MAX_ALLOWED_KEY_LENGTH = 128;
    private static final int MINIMUM_SAFE_PASSWORD_LENGTH = 10;

    public PasswordBasedEncryptor(EncryptionMethod encryptionMethod, char[] password, KeyDerivationFunction kdf) {
        try {
            if (encryptionMethod == null) {
                throw new IllegalArgumentException("Cannot initialize password-based encryptor with null encryption method");
            }
            this.encryptionMethod = encryptionMethod;
            if (kdf == null || kdf.equals((Object)KeyDerivationFunction.NONE)) {
                throw new IllegalArgumentException("Cannot initialize password-based encryptor with null KDF");
            }
            this.kdf = kdf;
            if (password == null || password.length == 0) {
                throw new IllegalArgumentException("Cannot initialize password-based encryptor with empty password");
            }
            this.password = new PBEKeySpec(password);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public static int getMaxAllowedKeyLength(String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return 128;
        }
        String parsedCipher = CipherUtility.parseCipherFromAlgorithm((String)algorithm);
        try {
            return Cipher.getMaxAllowedKeyLength(parsedCipher);
        }
        catch (NoSuchAlgorithmException e) {
            return 128;
        }
    }

    public static int getMinimumSafePasswordLength() {
        return 10;
    }

    static Map<String, String> writeAttributes(EncryptionMethod encryptionMethod, KeyDerivationFunction kdf, byte[] iv, byte[] kdfSalt, ByteCountingInputStream bcis, ByteCountingOutputStream bcos, boolean encryptMode) {
        Map<String, String> attributes = AbstractEncryptor.writeAttributes(encryptionMethod, kdf, iv, bcis, bcos, encryptMode);
        if (kdf.hasFormattedSalt()) {
            String saltString = new String(kdfSalt, StandardCharsets.UTF_8);
            attributes.put("encryptcontent.kdf_salt", saltString);
            attributes.put("encryptcontent.kdf_salt_length", String.valueOf(saltString.length()));
        }
        byte[] rawSalt = CipherUtility.extractRawSalt((byte[])kdfSalt, (KeyDerivationFunction)kdf);
        attributes.put("encryptcontent.salt", Hex.encodeHexString((byte[])rawSalt));
        attributes.put("encryptcontent.salt_length", String.valueOf(rawSalt.length));
        return attributes;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws ProcessException {
        return new EncryptCallback();
    }

    @Override
    public StreamCallback getDecryptionCallback() throws ProcessException {
        return new DecryptCallback();
    }

    private class EncryptCallback
    implements StreamCallback {
        private static final boolean ENCRYPT = true;

        public void process(InputStream in, OutputStream out) throws IOException {
            PBECipherProvider cipherProvider = (PBECipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)PasswordBasedEncryptor.this.kdf);
            if (PasswordBasedEncryptor.this.kdf == KeyDerivationFunction.PBKDF2) {
                PasswordBasedEncryptor.this.flowfileAttributes.put("encryptcontent.pbkdf2_iterations", String.valueOf(((PBKDF2CipherProvider)cipherProvider).getIterationCount()));
            }
            byte[] salt = cipherProvider instanceof NiFiLegacyCipherProvider ? ((NiFiLegacyCipherProvider)cipherProvider).generateSalt(PasswordBasedEncryptor.this.encryptionMethod) : cipherProvider.generateSalt();
            ByteCountingInputStream bcis = CipherUtility.wrapStreamForCounting((InputStream)in);
            ByteCountingOutputStream bcos = CipherUtility.wrapStreamForCounting((OutputStream)out);
            cipherProvider.writeSalt(salt, (OutputStream)bcos);
            int keyLength = CipherUtility.parseKeyLengthFromAlgorithm((String)PasswordBasedEncryptor.this.encryptionMethod.getAlgorithm());
            try {
                Cipher cipher = cipherProvider.getCipher(PasswordBasedEncryptor.this.encryptionMethod, new String(PasswordBasedEncryptor.this.password.getPassword()), salt, keyLength, true);
                if (cipherProvider instanceof RandomIVPBECipherProvider) {
                    ((RandomIVPBECipherProvider)cipherProvider).writeIV(cipher.getIV(), (OutputStream)bcos);
                }
                CipherUtility.processStreams((Cipher)cipher, (InputStream)bcis, (OutputStream)bcos);
                PasswordBasedEncryptor.this.flowfileAttributes.putAll(PasswordBasedEncryptor.writeAttributes(PasswordBasedEncryptor.this.encryptionMethod, PasswordBasedEncryptor.this.kdf, cipher.getIV(), salt, bcis, bcos, true));
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }

    private class DecryptCallback
    implements StreamCallback {
        private static final boolean DECRYPT = false;
        private static final int RETRY_LIMIT_LENGTH = 0xA00000;

        public void process(InputStream in, OutputStream out) throws IOException {
            byte[] salt;
            PBECipherProvider cipherProvider = (PBECipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)PasswordBasedEncryptor.this.kdf);
            ByteCountingInputStream bcis = CipherUtility.wrapStreamForCounting((InputStream)in);
            ByteCountingOutputStream bcos = CipherUtility.wrapStreamForCounting((OutputStream)out);
            try {
                salt = cipherProvider instanceof NiFiLegacyCipherProvider ? ((NiFiLegacyCipherProvider)cipherProvider).readSalt(PasswordBasedEncryptor.this.encryptionMethod, (InputStream)bcis) : cipherProvider.readSalt((InputStream)bcis);
            }
            catch (EOFException e) {
                throw new ProcessException("Cannot decrypt because file size is smaller than salt size", (Throwable)e);
            }
            int keyLength = CipherUtility.parseKeyLengthFromAlgorithm((String)PasswordBasedEncryptor.this.encryptionMethod.getAlgorithm());
            try {
                Cipher cipher;
                String password = new String(PasswordBasedEncryptor.this.password.getPassword());
                byte[] iv = new byte[]{};
                if (cipherProvider instanceof RandomIVPBECipherProvider) {
                    RandomIVPBECipherProvider rivpcp = (RandomIVPBECipherProvider)cipherProvider;
                    iv = rivpcp.readIV((InputStream)bcis);
                    cipher = rivpcp.getCipher(PasswordBasedEncryptor.this.encryptionMethod, password, salt, iv, keyLength, false);
                } else {
                    cipher = cipherProvider.getCipher(PasswordBasedEncryptor.this.encryptionMethod, password, salt, keyLength, false);
                }
                if (PasswordBasedEncryptor.this.kdf == KeyDerivationFunction.BCRYPT) {
                    boolean cipherProviderIsSafeType = cipherProvider instanceof BcryptCipherProvider;
                    logger.debug("Cipher provider instance of BcryptCipherProvider: {}", (Object)cipherProviderIsSafeType);
                    if (!cipherProviderIsSafeType) {
                        throw new ProcessException("The KDF is Bcrypt but the cipher provider is not a Bcrypt cipher provider; " + cipherProvider.getClass().getSimpleName());
                    }
                    this.handleBcryptDecryption((BcryptCipherProvider)cipherProvider, bcis, bcos, salt, keyLength, cipher, iv, password);
                } else {
                    CipherUtility.processStreams((Cipher)cipher, (InputStream)bcis, (OutputStream)bcos);
                }
                PasswordBasedEncryptor.this.flowfileAttributes.putAll(PasswordBasedEncryptor.writeAttributes(PasswordBasedEncryptor.this.encryptionMethod, PasswordBasedEncryptor.this.kdf, cipher.getIV(), salt, bcis, bcos, false));
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }

        protected void handleBcryptDecryption(BcryptCipherProvider bcryptCipherProvider, ByteCountingInputStream bcis, ByteCountingOutputStream bcos, byte[] salt, int keyLength, Cipher cipher, byte[] iv, String password) throws IOException, ProcessException {
            bcis.mark(0xA00000);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                CipherUtility.processStreams((Cipher)cipher, (InputStream)bcis, (OutputStream)baos);
                bcos.write(baos.toByteArray());
            }
            catch (ProcessException e) {
                if (this.shouldAttemptLegacyDecrypt(e, bcis.getBytesConsumed())) {
                    logger.warn("Error decrypting content using Bcrypt-derived key; attempting legacy key derivation for backward compatibility");
                    bcis.reset();
                    cipher = bcryptCipherProvider.getLegacyDecryptCipher(PasswordBasedEncryptor.this.encryptionMethod, password, salt, iv, keyLength);
                    CipherUtility.processStreams((Cipher)cipher, (InputStream)bcis, (OutputStream)bcos);
                }
                throw e;
            }
        }

        protected boolean shouldAttemptLegacyDecrypt(ProcessException e, long bytesConsumed) {
            boolean bytesConsumedWithinLimit;
            boolean causeIsWrongKey = e.getCause() instanceof BadPaddingException;
            boolean bl = bytesConsumedWithinLimit = bytesConsumed < 0xA00000L;
            if (logger.isDebugEnabled()) {
                logger.debug("Exception cause instance of BadPaddingException: {}", (Object)causeIsWrongKey);
                logger.debug("Bytes consumed ({} B) < retry limit ({} B): {}", new Object[]{bytesConsumed, 0xA00000, bytesConsumedWithinLimit});
            }
            return causeIsWrongKey && bytesConsumedWithinLimit;
        }
    }
}

