/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.distributed.cache.client.exception.DeserializationException;
import org.apache.nifi.distributed.cache.client.exception.SerializationException;

public class FlowFileAttributesSerializer
implements Deserializer<Map<String, String>>,
Serializer<Map<String, String>> {
    private static final String ATTRIBUTE_SEPARATOR = "<|--|>";

    public Map<String, String> deserialize(byte[] input) throws DeserializationException, IOException {
        String[] entries;
        if (input == null || input.length == 0) {
            return null;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        String attributesText = new String(input, StandardCharsets.UTF_8);
        for (String entry : entries = attributesText.split(Pattern.quote(ATTRIBUTE_SEPARATOR))) {
            int equalsIndex = entry.indexOf(61);
            String key = entry.substring(0, equalsIndex);
            String value = entry.substring(equalsIndex + 1);
            attributes.put(key, value);
        }
        return attributes;
    }

    public void serialize(Map<String, String> value, OutputStream output) throws SerializationException, IOException {
        int i = 0;
        for (Map.Entry<String, String> entry : value.entrySet()) {
            output.write((entry.getKey() + "=" + entry.getValue()).getBytes(StandardCharsets.UTF_8));
            if (i < value.size() - 1) {
                output.write(ATTRIBUTE_SEPARATOR.getBytes(StandardCharsets.UTF_8));
            }
            ++i;
        }
        output.flush();
    }
}

