/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.standard.enrichment.RecordJoinInput;
import org.apache.nifi.processors.standard.enrichment.RecordJoinResult;
import org.apache.nifi.processors.standard.enrichment.RecordJoinStrategy;
import org.apache.nifi.processors.standard.enrichment.SqlJoinCache;
import org.apache.nifi.processors.standard.enrichment.SqlJoinCalciteParameters;
import org.apache.nifi.queryrecord.FlowFileTable;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.ResultSetRecordSet;

public class SqlJoinStrategy
implements RecordJoinStrategy {
    private final SqlJoinCache cache;
    private final ComponentLog logger;
    private final String sql;
    private final int defaultPrecision;
    private final int defaultScale;

    public SqlJoinStrategy(SqlJoinCache cache, String sql, ComponentLog logger, int defaultPrecision, int defaultScale) {
        this.cache = cache;
        this.sql = sql;
        this.logger = logger;
        this.defaultPrecision = defaultPrecision;
        this.defaultScale = defaultScale;
    }

    @Override
    public RecordJoinResult join(RecordJoinInput originalInput, RecordJoinInput enrichmentInput, ProcessSession session, final RecordSchema outputSchema) throws SQLException {
        ResultSet rs;
        final SqlJoinCalciteParameters calciteParameters = this.cache.getCalciteParameters(this.sql, session, outputSchema, originalInput, enrichmentInput);
        final FlowFileTable originalTable = calciteParameters.getOriginalTable();
        final FlowFileTable enrichmentTable = calciteParameters.getEnrichmentTable();
        originalTable.setFlowFile(session, originalInput.getFlowFile());
        enrichmentTable.setFlowFile(session, enrichmentInput.getFlowFile());
        PreparedStatement stmt = calciteParameters.getPreparedStatement();
        try {
            rs = stmt.executeQuery();
        }
        catch (Throwable t) {
            originalTable.close();
            enrichmentTable.close();
            throw t;
        }
        ResultSetRecordSet recordSet = new ResultSetRecordSet(rs, outputSchema, this.defaultPrecision, this.defaultScale, true);
        return new RecordJoinResult(){
            final /* synthetic */ RecordSet val$recordSet;
            {
                this.val$recordSet = recordSet;
            }

            @Override
            public void close() {
                SqlJoinStrategy.this.closeQuietly(originalTable, enrichmentTable);
                SqlJoinStrategy.this.cache.returnCalciteParameters(SqlJoinStrategy.this.sql, outputSchema, calciteParameters);
            }

            @Override
            public RecordSet getRecordSet() {
                return this.val$recordSet;
            }
        };
    }

    private void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            this.closeQuietly(closeable);
        }
    }

    private void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close {}", new Object[]{closeable, e});
            }
        }
    }
}

