/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.ConvertRecord;
import org.apache.nifi.processors.standard.SplitRecord;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.Tuple;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile")})
@Tags(value={"lookup", "enrichment", "route", "record", "csv", "json", "avro", "database", "db", "logs", "convert", "filter"})
@CapabilityDescription(value="Extracts one or more fields from a Record and looks up a value for those fields in a LookupService. If a result is returned by the LookupService, that result is optionally added to the Record. In this case, the processor functions as an Enrichment processor. Regardless, the Record is then routed to either the 'matched' relationship or 'unmatched' relationship (if the 'Routing Strategy' property is configured to do so), indicating whether or not a result was returned by the LookupService, allowing the processor to also function as a Routing processor. The \"coordinates\" to use for looking up a value in the Lookup Service are defined by adding a user-defined property. Each property that is added will have an entry added to a Map, where the name of the property becomes the Map Key and the value returned by the RecordPath becomes the value for that key. If multiple values are returned by the RecordPath, then the Record will be routed to the 'unmatched' relationship (or 'success', depending on the 'Routing Strategy' property's configuration). If one or more fields match the Result RecordPath, all fields that match will be updated. If there is no match in the configured LookupService, then no fields will be updated. I.e., it will not overwrite an existing value in the Record with a null value. Please note, however, that if the results returned by the LookupService are not accounted for in your schema (specifically, the schema that is configured for your Record Writer) then the fields will not be written out to the FlowFile.")
@DynamicProperty(name="Value To Lookup", value="Valid Record Path", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="A RecordPath that points to the field whose value will be looked up in the configured Lookup Service")
@SeeAlso(value={ConvertRecord.class, SplitRecord.class}, classNames={"org.apache.nifi.lookup.SimpleKeyValueLookupService", "org.apache.nifi.lookup.maxmind.IPLookupService", "org.apache.nifi.lookup.db.DatabaseRecordLookupService"})
public class LookupRecord
extends AbstractProcessor {
    private final RecordPathCache recordPathCache = new RecordPathCache(25);
    private volatile LookupService<?> lookupService;
    static final AllowableValue ROUTE_TO_SUCCESS = new AllowableValue("route-to-success", "Route to 'success'", "Records will be routed to a 'success' Relationship regardless of whether or not there is a match in the configured Lookup Service");
    static final AllowableValue ROUTE_TO_MATCHED_UNMATCHED = new AllowableValue("route-to-matched-unmatched", "Route to 'matched' or 'unmatched'", "Records will be routed to either a 'matched' or an 'unmatched' Relationship depending on whether or not there was a match in the configured Lookup Service. A single input FlowFile may result in two different output FlowFiles.");
    static final AllowableValue RESULT_ENTIRE_RECORD = new AllowableValue("insert-entire-record", "Insert Entire Record", "The entire Record that is retrieved from the Lookup Service will be inserted into the destination path.");
    static final AllowableValue RESULT_RECORD_FIELDS = new AllowableValue("record-fields", "Insert Record Fields", "All of the fields in the Record that is retrieved from the Lookup Service will be inserted into the destination path.");
    static final AllowableValue USE_PROPERTY = new AllowableValue("use-property", "Use Property", "The \"Result RecordPath\" property will be used to determine which part of the record should be updated with the value returned by the Lookup Service");
    static final AllowableValue REPLACE_EXISTING_VALUES = new AllowableValue("replace-existing-values", "Replace Existing Values", "The \"Result RecordPath\" property will be ignored and the lookup service must be a single simple key lookup service. Every dynamic property value should be a record path. For each dynamic property, the value contained in the field corresponding to the record path will be used as the key in the Lookup Service and the value returned by the Lookup Service will be used to replace the existing value. It is possible to configure multiple dynamic properties to replace multiple values in one execution. This strategy only supports simple types replacements (strings, integers, etc).");
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("Specifies the Controller Service to use for reading incoming data").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Writer").description("Specifies the Controller Service to use for writing out the records").identifiesControllerService(RecordSetWriterFactory.class).required(true).build();
    static final PropertyDescriptor LOOKUP_SERVICE = new PropertyDescriptor.Builder().name("lookup-service").displayName("Lookup Service").description("The Lookup Service to use in order to lookup a value in each Record").identifiesControllerService(LookupService.class).required(true).build();
    static final PropertyDescriptor RESULT_RECORD_PATH = new PropertyDescriptor.Builder().name("result-record-path").displayName("Result RecordPath").description("A RecordPath that points to the field whose value should be updated with whatever value is returned from the Lookup Service. If not specified, the value that is returned from the Lookup Service will be ignored, except for determining whether the FlowFile should be routed to the 'matched' or 'unmatched' Relationship.").addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    static final PropertyDescriptor RESULT_CONTENTS = new PropertyDescriptor.Builder().name("result-contents").displayName("Record Result Contents").description("When a result is obtained that contains a Record, this property determines whether the Record itself is inserted at the configured path or if the contents of the Record (i.e., the sub-fields) will be inserted at the configured path.").allowableValues(new AllowableValue[]{RESULT_ENTIRE_RECORD, RESULT_RECORD_FIELDS}).defaultValue(RESULT_ENTIRE_RECORD.getValue()).required(true).build();
    static final PropertyDescriptor ROUTING_STRATEGY = new PropertyDescriptor.Builder().name("routing-strategy").displayName("Routing Strategy").description("Specifies how to route records after a Lookup has completed").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{ROUTE_TO_SUCCESS, ROUTE_TO_MATCHED_UNMATCHED}).defaultValue(ROUTE_TO_SUCCESS.getValue()).required(true).build();
    static final PropertyDescriptor REPLACEMENT_STRATEGY = new PropertyDescriptor.Builder().name("record-update-strategy").displayName("Record Update Strategy").description("This property defines the strategy to use when updating the record with the value returned by the Lookup Service.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{REPLACE_EXISTING_VALUES, USE_PROPERTY}).defaultValue(USE_PROPERTY.getValue()).required(true).build();
    static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("record-path-lookup-miss-result-cache-size").displayName("Cache Size").description("Specifies how many lookup values/records should be cached.Setting this property to zero means no caching will be done and the table will be queried for each lookup value in each record. If the lookup table changes often or the most recent data must be retrieved, do not use the cache.").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("0").required(true).build();
    static final Relationship REL_MATCHED = new Relationship.Builder().name("matched").description("All records for which the lookup returns a value will be routed to this relationship").build();
    static final Relationship REL_UNMATCHED = new Relationship.Builder().name("unmatched").description("All records for which the lookup does not have a matching value will be routed to this relationship").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All records will be sent to this Relationship if configured to do so, unless a failure occurs").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile cannot be enriched, the unchanged FlowFile will be routed to this relationship").build();
    private static final Set<Relationship> MATCHED_COLLECTION = Collections.singleton(REL_MATCHED);
    private static final Set<Relationship> UNMATCHED_COLLECTION = Collections.singleton(REL_UNMATCHED);
    private static final Set<Relationship> SUCCESS_COLLECTION = Collections.singleton(REL_SUCCESS);
    private volatile Set<Relationship> relationships = new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE));
    private volatile boolean routeToMatchedUnmatched = false;

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.lookupService = (LookupService)context.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(RECORD_READER);
        properties.add(RECORD_WRITER);
        properties.add(LOOKUP_SERVICE);
        properties.add(RESULT_RECORD_PATH);
        properties.add(ROUTING_STRATEGY);
        properties.add(RESULT_CONTENTS);
        properties.add(REPLACEMENT_STRATEGY);
        properties.add(CACHE_SIZE);
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("A RecordPath that points to the field whose value will be looked up in the configured Lookup Service").addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Set dynamicPropNames = validationContext.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).map(PropertyDescriptor::getName).collect(Collectors.toSet());
        if (dynamicPropNames.isEmpty()) {
            return Collections.singleton(new ValidationResult.Builder().subject("User-Defined Properties").valid(false).explanation("At least one user-defined property must be specified.").build());
        }
        Set requiredKeys = ((LookupService)validationContext.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class)).getRequiredKeys();
        if (validationContext.getProperty(REPLACEMENT_STRATEGY).getValue().equals(REPLACE_EXISTING_VALUES.getValue())) {
            if (requiredKeys.size() != 1) {
                return Collections.singleton(new ValidationResult.Builder().subject(LOOKUP_SERVICE.getDisplayName()).valid(false).explanation("When using \"" + REPLACE_EXISTING_VALUES.getDisplayName() + "\" as Record Update Strategy, only a Lookup Service requiring a single key can be used.").build());
            }
        } else {
            Set missingKeys = requiredKeys.stream().filter(key -> !dynamicPropNames.contains(key)).collect(Collectors.toSet());
            if (!missingKeys.isEmpty()) {
                ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
                for (String missingKey : missingKeys) {
                    ValidationResult result = new ValidationResult.Builder().subject(missingKey).valid(false).explanation("The configured Lookup Services requires that a key be provided with the name '" + missingKey + "'. Please add a new property to this Processor with a name '" + missingKey + "' and provide a RecordPath that can be used to retrieve the appropriate value.").build();
                    validationResults.add(result);
                }
                return validationResults;
            }
        }
        return Collections.emptyList();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (ROUTING_STRATEGY.equals((Object)descriptor)) {
            if (ROUTE_TO_MATCHED_UNMATCHED.getValue().equalsIgnoreCase(newValue)) {
                HashSet<Relationship> matchedUnmatchedRels = new HashSet<Relationship>();
                matchedUnmatchedRels.add(REL_MATCHED);
                matchedUnmatchedRels.add(REL_UNMATCHED);
                matchedUnmatchedRels.add(REL_FAILURE);
                this.relationships = matchedUnmatchedRels;
                this.routeToMatchedUnmatched = true;
            } else {
                HashSet<Relationship> successRels = new HashSet<Relationship>();
                successRels.add(REL_SUCCESS);
                successRels.add(REL_FAILURE);
                this.relationships = successRels;
                this.routeToMatchedUnmatched = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(final ProcessContext context, ProcessSession session) throws ProcessException {
        RecordSetWriter writer;
        RecordSchema enrichedSchema;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        final RecordReaderFactory readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        final RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
        final FlowFile original = flowFile;
        final Map originalAttributes = original.getAttributes();
        final LookupContext lookupContext = this.createLookupContext(flowFile, context, session, writerFactory);
        final ReplacementStrategy replacementStrategy = this.createReplacementStrategy(context);
        try {
            enrichedSchema = replacementStrategy.determineResultSchema(readerFactory, writerFactory, context, session, flowFile, lookupContext);
        }
        catch (Exception e) {
            this.getLogger().error("Could not determine schema to use for enriched FlowFiles", (Throwable)e);
            session.transfer(original, REL_FAILURE);
            return;
        }
        try {
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream in) throws IOException {
                    try (RecordReader reader = readerFactory.createRecordReader(originalAttributes, in, original.getSize(), LookupRecord.this.getLogger());){
                        Record record;
                        HashMap<Relationship, RecordSchema> writeSchemas = new HashMap<Relationship, RecordSchema>();
                        while ((record = reader.nextRecord()) != null) {
                            Set<Relationship> relationships = replacementStrategy.lookup(record, context, lookupContext);
                            for (Relationship relationship : relationships) {
                                RecordSchema writeSchema = (RecordSchema)writeSchemas.get(relationship);
                                if (writeSchema == null) {
                                    RecordSchema outputSchema = enrichedSchema == null ? record.getSchema() : enrichedSchema;
                                    writeSchema = writerFactory.getSchema(originalAttributes, outputSchema);
                                    writeSchemas.put(relationship, writeSchema);
                                }
                                RecordSetWriter writer = lookupContext.getRecordWriterForRelationship(relationship, writeSchema);
                                writer.write(record);
                            }
                        }
                    }
                    catch (SchemaNotFoundException | MalformedRecordException e) {
                        throw new ProcessException("Could not parse incoming data", e);
                    }
                }
            });
            for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                writer = lookupContext.getExistingRecordWriterForRelationship(relationship);
                FlowFile childFlowFile = lookupContext.getFlowFileForRelationship(relationship);
                WriteResult writeResult = writer.finishRecordSet();
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    this.getLogger().warn("Failed to close Writer for {}", new Object[]{childFlowFile});
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("record.count", String.valueOf(writeResult.getRecordCount()));
                attributes.put(CoreAttributes.MIME_TYPE.key(), writer.getMimeType());
                attributes.putAll(writeResult.getAttributes());
                childFlowFile = session.putAllAttributes(childFlowFile, attributes);
                session.transfer(childFlowFile, relationship);
                session.adjustCounter("Records Processed", (long)writeResult.getRecordCount(), false);
                session.adjustCounter("Records Routed to " + relationship.getName(), (long)writeResult.getRecordCount(), false);
                session.getProvenanceReporter().route(childFlowFile, relationship);
            }
        }
        catch (Exception e) {
            RecordSetWriter writer2;
            try {
                this.getLogger().error("Failed to process {}", new Object[]{flowFile, e});
                for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                    writer2 = lookupContext.getExistingRecordWriterForRelationship(relationship);
                    FlowFile childFlowFile = lookupContext.getFlowFileForRelationship(relationship);
                    try {
                        writer2.close();
                    }
                    catch (Exception e1) {
                        this.getLogger().warn("Failed to close Writer for {}; some resources may not be cleaned up appropriately", new Object[]{writer2});
                    }
                    session.remove(childFlowFile);
                }
                session.transfer(flowFile, REL_FAILURE);
            }
            catch (Throwable throwable) {
                for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                    RecordSetWriter writer3 = lookupContext.getExistingRecordWriterForRelationship(relationship);
                    try {
                        writer3.close();
                    }
                    catch (Exception e2) {
                        this.getLogger().warn("Failed to close Record Writer for {}; some resources may not be properly cleaned up", new Object[]{writer3, e2});
                    }
                }
                throw throwable;
            }
            for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
                writer2 = lookupContext.getExistingRecordWriterForRelationship(relationship);
                try {
                    writer2.close();
                }
                catch (Exception e3) {
                    this.getLogger().warn("Failed to close Record Writer for {}; some resources may not be properly cleaned up", new Object[]{writer2, e3});
                }
            }
            return;
        }
        for (Relationship relationship : lookupContext.getRelationshipsUsed()) {
            writer = lookupContext.getExistingRecordWriterForRelationship(relationship);
            try {
                writer.close();
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to close Record Writer for {}; some resources may not be properly cleaned up", new Object[]{writer, e});
            }
        }
        session.remove(flowFile);
        this.getLogger().info("Successfully processed {}, creating {} derivative FlowFiles and processing {} records", new Object[]{flowFile, lookupContext.getRelationshipsUsed().size(), replacementStrategy.getLookupCount()});
    }

    private ReplacementStrategy createReplacementStrategy(ProcessContext context) {
        boolean isInPlaceReplacement = context.getProperty(REPLACEMENT_STRATEGY).getValue().equals(REPLACE_EXISTING_VALUES.getValue());
        if (isInPlaceReplacement) {
            return new InPlaceReplacementStrategy();
        }
        return new RecordPathReplacementStrategy(context);
    }

    protected LookupContext createLookupContext(FlowFile flowFile, ProcessContext context, ProcessSession session, RecordSetWriterFactory writerFactory) {
        RecordPath resultRecordPath;
        HashMap<String, RecordPath> recordPaths = new HashMap<String, RecordPath>();
        for (PropertyDescriptor prop : context.getProperties().keySet()) {
            if (!prop.isDynamic()) continue;
            String pathText = context.getProperty(prop).evaluateAttributeExpressions(flowFile).getValue();
            RecordPath lookupRecordPath = this.recordPathCache.getCompiled(pathText);
            recordPaths.put(prop.getName(), lookupRecordPath);
        }
        if (context.getProperty(RESULT_RECORD_PATH).isSet()) {
            String resultPathText = context.getProperty(RESULT_RECORD_PATH).evaluateAttributeExpressions(flowFile).getValue();
            resultRecordPath = this.recordPathCache.getCompiled(resultPathText);
        } else {
            resultRecordPath = null;
        }
        return new LookupContext(recordPaths, resultRecordPath, session, flowFile, writerFactory, this.getLogger());
    }

    private static class LookupContext {
        private final Map<String, RecordPath> recordPathsByCoordinateKey;
        private final RecordPath resultRecordPath;
        private final ProcessSession session;
        private final FlowFile flowFile;
        private final RecordSetWriterFactory writerFactory;
        private final ComponentLog logger;
        private final Map<Relationship, Tuple<FlowFile, RecordSetWriter>> writersByRelationship = new HashMap<Relationship, Tuple<FlowFile, RecordSetWriter>>();

        public LookupContext(Map<String, RecordPath> recordPathsByCoordinateKey, RecordPath resultRecordPath, ProcessSession session, FlowFile flowFile, RecordSetWriterFactory writerFactory, ComponentLog logger) {
            this.recordPathsByCoordinateKey = recordPathsByCoordinateKey;
            this.resultRecordPath = resultRecordPath;
            this.session = session;
            this.flowFile = flowFile;
            this.writerFactory = writerFactory;
            this.logger = logger;
        }

        public Map<String, RecordPath> getRecordPathsByCoordinateKey() {
            return this.recordPathsByCoordinateKey;
        }

        public RecordPath getResultRecordPath() {
            return this.resultRecordPath;
        }

        public FlowFile getOriginalFlowFile() {
            return this.flowFile;
        }

        private Set<Relationship> getRelationshipsUsed() {
            return this.writersByRelationship.keySet();
        }

        public FlowFile getFlowFileForRelationship(Relationship relationship) {
            Tuple<FlowFile, RecordSetWriter> tuple = this.writersByRelationship.get(relationship);
            return (FlowFile)tuple.getKey();
        }

        public RecordSetWriter getExistingRecordWriterForRelationship(Relationship relationship) {
            Tuple<FlowFile, RecordSetWriter> tuple = this.writersByRelationship.get(relationship);
            return (RecordSetWriter)tuple.getValue();
        }

        public RecordSetWriter getRecordWriterForRelationship(Relationship relationship, RecordSchema schema) throws IOException, SchemaNotFoundException {
            Tuple<FlowFile, RecordSetWriter> tuple = this.writersByRelationship.get(relationship);
            if (tuple != null) {
                return (RecordSetWriter)tuple.getValue();
            }
            FlowFile outFlowFile = this.session.create(this.flowFile);
            OutputStream out = this.session.write(outFlowFile);
            try {
                RecordSchema recordWriteSchema = this.writerFactory.getSchema(this.flowFile.getAttributes(), schema);
                RecordSetWriter recordSetWriter = this.writerFactory.createWriter(this.logger, recordWriteSchema, out, outFlowFile);
                recordSetWriter.beginRecordSet();
                this.writersByRelationship.put(relationship, (Tuple<FlowFile, RecordSetWriter>)new Tuple((Object)outFlowFile, (Object)recordSetWriter));
                return recordSetWriter;
            }
            catch (Exception e) {
                try {
                    out.close();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
                throw e;
            }
        }
    }

    private static interface ReplacementStrategy {
        public Set<Relationship> lookup(Record var1, ProcessContext var2, LookupContext var3);

        public RecordSchema determineResultSchema(RecordReaderFactory var1, RecordSetWriterFactory var2, ProcessContext var3, ProcessSession var4, FlowFile var5, LookupContext var6) throws IOException, SchemaNotFoundException, MalformedRecordException, LookupFailureException;

        public int getLookupCount();
    }

    private class InPlaceReplacementStrategy
    implements ReplacementStrategy {
        private int lookupCount = 0;

        private InPlaceReplacementStrategy() {
        }

        @Override
        public Set<Relationship> lookup(Record record, ProcessContext context, LookupContext lookupContext) {
            ++this.lookupCount;
            Map<String, RecordPath> recordPaths = lookupContext.getRecordPathsByCoordinateKey();
            HashMap<String, Object> lookupCoordinates = new HashMap<String, Object>(recordPaths.size());
            String coordinateKey = (String)LookupRecord.this.lookupService.getRequiredKeys().iterator().next();
            FlowFile flowFile = lookupContext.getOriginalFlowFile();
            boolean hasUnmatchedValue = false;
            for (Map.Entry<String, RecordPath> entry : recordPaths.entrySet()) {
                RecordPath recordPath = entry.getValue();
                RecordPathResult pathResult = recordPath.evaluate(record);
                AtomicLong selectedFieldsCount = new AtomicLong(0L);
                List lookupFieldValues = pathResult.getSelectedFields().filter(fieldVal -> {
                    selectedFieldsCount.incrementAndGet();
                    return fieldVal.getValue() != null;
                }).collect(Collectors.toList());
                if (selectedFieldsCount.get() == 0L) continue;
                if (lookupFieldValues.isEmpty()) {
                    Set<Relationship> rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                    LookupRecord.this.getLogger().debug("RecordPath for property '{}' did not match any fields in a record for {}; routing record to {}", new Object[]{coordinateKey, flowFile, rels});
                    return rels;
                }
                for (FieldValue fieldValue : lookupFieldValues) {
                    Optional lookupValueOption;
                    Object coordinateValue = DataTypeUtils.convertType((Object)fieldValue.getValue(), (DataType)fieldValue.getField().getDataType(), null, null, null, (String)fieldValue.getField().getFieldName());
                    lookupCoordinates.clear();
                    lookupCoordinates.put(coordinateKey, coordinateValue);
                    try {
                        lookupValueOption = LookupRecord.this.lookupService.lookup(lookupCoordinates, flowFile.getAttributes());
                    }
                    catch (Exception e) {
                        throw new ProcessException("Failed to lookup coordinates " + lookupCoordinates + " in Lookup Service", (Throwable)e);
                    }
                    if (!lookupValueOption.isPresent()) {
                        hasUnmatchedValue = true;
                        continue;
                    }
                    Object lookupValue = lookupValueOption.get();
                    DataType inferredDataType = DataTypeUtils.inferDataType(lookupValue, (DataType)RecordFieldType.STRING.getDataType());
                    fieldValue.updateValue(lookupValue, inferredDataType);
                }
            }
            if (hasUnmatchedValue) {
                return LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
            }
            return LookupRecord.this.routeToMatchedUnmatched ? MATCHED_COLLECTION : SUCCESS_COLLECTION;
        }

        @Override
        public RecordSchema determineResultSchema(RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, ProcessContext context, ProcessSession session, FlowFile flowFile, LookupContext lookupContext) throws IOException, SchemaNotFoundException, MalformedRecordException {
            try (InputStream in = session.read(flowFile);){
                RecordSchema recordSchema;
                block12: {
                    RecordReader reader = readerFactory.createRecordReader(flowFile, in, LookupRecord.this.getLogger());
                    try {
                        recordSchema = reader.getSchema();
                        if (reader == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                return recordSchema;
            }
        }

        @Override
        public int getLookupCount() {
            return this.lookupCount;
        }
    }

    private class RecordPathReplacementStrategy
    implements ReplacementStrategy {
        private int lookupCount = 0;
        private volatile Cache<Map<String, Object>, Optional<?>> cache;

        public RecordPathReplacementStrategy(ProcessContext context) {
            int cacheSize = context.getProperty(CACHE_SIZE).evaluateAttributeExpressions().asInteger();
            if (this.cache == null || cacheSize > 0) {
                this.cache = Caffeine.newBuilder().maximumSize((long)cacheSize).build();
            }
        }

        @Override
        public Set<Relationship> lookup(Record record, ProcessContext context, LookupContext lookupContext) {
            Optional lookupValueOption;
            ++this.lookupCount;
            Map<String, Object> lookupCoordinates = this.createLookupCoordinates(record, lookupContext, true);
            if (lookupCoordinates.isEmpty()) {
                Set<Relationship> rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                return rels;
            }
            FlowFile flowFile = lookupContext.getOriginalFlowFile();
            try {
                Optional lookupValueCacheOption = (Optional)this.cache.get(lookupCoordinates, k -> null);
                lookupValueOption = lookupValueCacheOption == null ? LookupRecord.this.lookupService.lookup(lookupCoordinates, flowFile.getAttributes()) : lookupValueCacheOption;
            }
            catch (Exception e) {
                throw new ProcessException("Failed to lookup coordinates " + lookupCoordinates + " in Lookup Service", (Throwable)e);
            }
            if (!lookupValueOption.isPresent()) {
                Set<Relationship> rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                return rels;
            }
            this.applyLookupResult(record, context, lookupContext, lookupValueOption.get());
            Set<Relationship> rels = LookupRecord.this.routeToMatchedUnmatched ? MATCHED_COLLECTION : SUCCESS_COLLECTION;
            return rels;
        }

        private void applyLookupResult(Record record, ProcessContext context, LookupContext lookupContext, Object lookupValue) {
            RecordPath resultPath = lookupContext.getResultRecordPath();
            if (resultPath != null) {
                RecordPathResult resultPathResult = resultPath.evaluate(record);
                String resultContentsValue = context.getProperty(RESULT_CONTENTS).getValue();
                if (RESULT_RECORD_FIELDS.getValue().equals(resultContentsValue) && lookupValue instanceof Record) {
                    Record lookupRecord = (Record)lookupValue;
                    resultPathResult.getSelectedFields().forEach(fieldVal -> {
                        Object destinationValue = fieldVal.getValue();
                        if (destinationValue instanceof Record) {
                            Record destinationRecord = (Record)destinationValue;
                            for (String fieldName : lookupRecord.getRawFieldNames()) {
                                Object value = lookupRecord.getValue(fieldName);
                                Optional recordFieldOption = lookupRecord.getSchema().getField(fieldName);
                                if (recordFieldOption.isPresent()) {
                                    RecordField field = (RecordField)recordFieldOption.get();
                                    if (!LookupRecord.this.routeToMatchedUnmatched && !field.isNullable()) {
                                        field = new RecordField(field.getFieldName(), field.getDataType(), field.getDefaultValue(), field.getAliases(), true);
                                    }
                                    destinationRecord.setValue(field, value);
                                    continue;
                                }
                                destinationRecord.setValue(fieldName, value);
                            }
                        } else {
                            Optional parentOption = fieldVal.getParentRecord();
                            parentOption.ifPresent(parent -> parent.setValue(fieldVal.getField(), (Object)lookupRecord));
                        }
                    });
                } else {
                    DataType inferredDataType = DataTypeUtils.inferDataType((Object)lookupValue, (DataType)RecordFieldType.STRING.getDataType());
                    resultPathResult.getSelectedFields().forEach(fieldVal -> fieldVal.updateValue(lookupValue, inferredDataType));
                }
                record.incorporateInactiveFields();
            }
        }

        @Override
        public RecordSchema determineResultSchema(RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, ProcessContext context, ProcessSession session, FlowFile flowFile, LookupContext lookupContext) throws IOException, SchemaNotFoundException, MalformedRecordException, LookupFailureException {
            Map flowFileAttributes = flowFile.getAttributes();
            try (InputStream in = session.read(flowFile);){
                RecordSchema recordSchema;
                block16: {
                    RecordSchema recordSchema2;
                    RecordReader reader = readerFactory.createRecordReader(flowFile, in, LookupRecord.this.getLogger());
                    try {
                        Record record;
                        while ((record = reader.nextRecord()) != null) {
                            Map<String, Object> lookupCoordinates = this.createLookupCoordinates(record, lookupContext, false);
                            if (lookupCoordinates.isEmpty()) continue;
                            Optional lookupResult = LookupRecord.this.lookupService.lookup(lookupCoordinates, flowFileAttributes);
                            this.cache.put(lookupCoordinates, (Object)lookupResult);
                            if (!lookupResult.isPresent()) continue;
                            this.applyLookupResult(record, context, lookupContext, lookupResult.get());
                            LookupRecord.this.getLogger().debug("Found a Record for {} that returned a result from the LookupService. Will provide the following schema to the Writer: {}", new Object[]{flowFile, record.getSchema()});
                            recordSchema2 = record.getSchema();
                            if (reader == null) break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    {
                        block15: {
                            reader.close();
                        }
                        return recordSchema2;
                    }
                    LookupRecord.this.getLogger().debug("Found no Record for {} that returned a result from the LookupService. Will provider Reader's schema to the Writer.", new Object[]{flowFile});
                    recordSchema = reader.getSchema();
                    if (reader == null) break block16;
                    reader.close();
                }
                return recordSchema;
            }
        }

        private Map<String, Object> createLookupCoordinates(Record record, LookupContext lookupContext, boolean logIfNotMatched) {
            Map<String, RecordPath> recordPaths = lookupContext.getRecordPathsByCoordinateKey();
            HashMap<String, Object> lookupCoordinates = new HashMap<String, Object>(recordPaths.size());
            FlowFile flowFile = lookupContext.getOriginalFlowFile();
            for (Map.Entry<String, RecordPath> entry : recordPaths.entrySet()) {
                Set<Relationship> rels;
                String coordinateKey = entry.getKey();
                RecordPath recordPath = entry.getValue();
                RecordPathResult pathResult = recordPath.evaluate(record);
                List lookupFieldValues = pathResult.getSelectedFields().filter(fieldVal -> fieldVal.getValue() != null).collect(Collectors.toList());
                if (lookupFieldValues.isEmpty()) {
                    if (logIfNotMatched) {
                        rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                        LookupRecord.this.getLogger().debug("RecordPath for property '{}' did not match any fields in a record for {}; routing record to {}", new Object[]{coordinateKey, flowFile, rels});
                    }
                    return Collections.emptyMap();
                }
                if (lookupFieldValues.size() > 1) {
                    if (logIfNotMatched) {
                        rels = LookupRecord.this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                        LookupRecord.this.getLogger().debug("RecordPath for property '{}' matched {} fields in a record for {}; routing record to {}", new Object[]{coordinateKey, lookupFieldValues.size(), flowFile, rels});
                    }
                    return Collections.emptyMap();
                }
                FieldValue fieldValue = (FieldValue)lookupFieldValues.get(0);
                Object coordinateValue = DataTypeUtils.convertType((Object)fieldValue.getValue(), (DataType)Optional.ofNullable(fieldValue.getField()).map(RecordField::getDataType).orElse(DataTypeUtils.inferDataType((Object)fieldValue.getValue(), (DataType)RecordFieldType.STRING.getDataType())), null, null, null, (String)Optional.ofNullable(fieldValue.getField()).map(RecordField::getFieldName).orElse(coordinateKey));
                lookupCoordinates.put(coordinateKey, coordinateValue);
            }
            return lookupCoordinates;
        }

        @Override
        public int getLookupCount() {
            return this.lookupCount;
        }
    }
}

