/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fluenda.parcefone.event.CEFHandlingException;
import com.fluenda.parcefone.event.CommonEvent;
import com.fluenda.parcefone.event.MacAddress;
import com.fluenda.parcefone.parser.CEFParser;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.validation.Validation;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.ParseSyslog;
import org.apache.nifi.stream.io.StreamUtils;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"logs", "cef", "attributes", "system", "event", "message"})
@CapabilityDescription(value="Parses the contents of a CEF formatted message and adds attributes to the FlowFile for headers and extensions of the parts of the CEF message.\nNote: This Processor expects CEF messages WITHOUT the syslog headers (i.e. starting at \"CEF:0\"")
@WritesAttributes(value={@WritesAttribute(attribute="cef.header.version", description="The version of the CEF message."), @WritesAttribute(attribute="cef.header.deviceVendor", description="The Device Vendor of the CEF message."), @WritesAttribute(attribute="cef.header.deviceProduct", description="The Device Product of the CEF message."), @WritesAttribute(attribute="cef.header.deviceVersion", description="The Device Version of the CEF message."), @WritesAttribute(attribute="cef.header.deviceEventClassId", description="The Device Event Class ID of the CEF message."), @WritesAttribute(attribute="cef.header.name", description="The name of the CEF message."), @WritesAttribute(attribute="cef.header.severity", description="The severity of the CEF message."), @WritesAttribute(attribute="cef.extension.*", description="The key and value generated by the parsing of the message.")})
@SeeAlso(value={ParseSyslog.class})
@DeprecationNotice(reason="This component is deprecated and will be removed in NiFi 2.x.")
public class ParseCEF
extends AbstractProcessor {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private String tzId = null;
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String DESTINATION_CONTENT = "flowfile-content";
    public static final String DESTINATION_ATTRIBUTES = "flowfile-attribute";
    public static final PropertyDescriptor FIELDS_DESTINATION = new PropertyDescriptor.Builder().name("FIELDS_DESTINATION").displayName("Parsed fields destination").description("Indicates whether the results of the CEF parser are written to the FlowFile content or a FlowFile attribute; if using flowfile-attributeattribute, fields will be populated as attributes. If set to flowfile-content, the CEF extension field will be converted into a flat JSON object.").required(true).allowableValues(new String[]{"flowfile-content", "flowfile-attribute"}).defaultValue("flowfile-content").build();
    public static final PropertyDescriptor APPEND_RAW_MESSAGE_TO_JSON = new PropertyDescriptor.Builder().name("APPEND_RAW_MESSAGE_TO_JSON").displayName("Append raw message to JSON").description("When using flowfile-content (i.e. JSON output), add the original CEF message to the resulting JSON object. The original message is added as a string to _raw.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(true).defaultValue("true").build();
    public static final PropertyDescriptor INCLUDE_CUSTOM_EXTENSIONS = new PropertyDescriptor.Builder().name("INCLUDE_CUSTOM_EXTENSIONS").displayName("Include custom extensions").description("If set to true, custom extensions (not specified in the CEF specifications) will be included in the generated data/attributes.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(true).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor ACCEPT_EMPTY_EXTENSIONS = new PropertyDescriptor.Builder().name("ACCEPT_EMPTY_EXTENSIONS").displayName("Accept empty extensions").description("If set to true, empty extensions will be accepted and will be associated to a null value.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(true).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor VALIDATE_DATA = new PropertyDescriptor.Builder().name("VALIDATE_DATA").displayName("Validate the CEF event").description("If set to true, the event will be validated against the CEF standard (revision 23). If the event is invalid, the FlowFile will be routed to the failure relationship. If this property is set to false, the event will be processed without validating the data.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    public static final String UTC = "UTC";
    public static final String LOCAL_TZ = "Local Timezone (system Default)";
    public static final PropertyDescriptor TIME_REPRESENTATION = new PropertyDescriptor.Builder().name("TIME_REPRESENTATION").displayName("Timezone").description("Timezone to be used when representing date fields. UTC will convert all dates to UTC, while Local Timezone will convert them to the timezone used by NiFi.").allowableValues(new String[]{"UTC", "Local Timezone (system Default)"}).required(true).defaultValue("Local Timezone (system Default)").build();
    public static final PropertyDescriptor DATETIME_REPRESENTATION = new PropertyDescriptor.Builder().name("DATETIME_REPRESENTATION").displayName("DateTime Locale").description("The IETF BCP 47 representation of the Locale to be used when parsing date fields with long or short month names (e.g. may <en-US> vs. mai. <fr-FR>. The defaultvalue is generally safe. Only change if having issues parsing CEF messages").required(true).addValidator((Validator)new ValidateLocale()).defaultValue("en-US").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that could not be parsed as a CEF message will be transferred to this Relationship without any attributes being added").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Any FlowFile that is successfully parsed as a CEF message will be transferred to this Relationship.").build();
    final javax.validation.Validator validator = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(FIELDS_DESTINATION);
        properties.add(APPEND_RAW_MESSAGE_TO_JSON);
        properties.add(INCLUDE_CUSTOM_EXTENSIONS);
        properties.add(ACCEPT_EMPTY_EXTENSIONS);
        properties.add(VALIDATE_DATA);
        properties.add(TIME_REPRESENTATION);
        properties.add(DATETIME_REPRESENTATION);
        return properties;
    }

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_FAILURE);
        relationships.add(REL_SUCCESS);
        return relationships;
    }

    @OnScheduled
    public void OnScheduled(ProcessContext context) {
        SimpleModule module = new SimpleModule().addSerializer(MacAddress.class, (JsonSerializer)new MacAddressToStringSerializer());
        mapper.registerModule((Module)module);
        mapper.setDateFormat((DateFormat)this.simpleDateFormat);
        switch (context.getProperty(TIME_REPRESENTATION).getValue()) {
            case "Local Timezone (system Default)": {
                mapper.setTimeZone(TimeZone.getDefault());
                this.tzId = TimeZone.getDefault().getID();
                break;
            }
            case "UTC": {
                mapper.setTimeZone(TimeZone.getTimeZone(UTC));
                this.tzId = UTC;
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        CommonEvent event;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        CEFParser parser = new CEFParser(this.validator);
        final byte[] buffer = new byte[(int)flowFile.getSize()];
        session.read(flowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                StreamUtils.fillBuffer((InputStream)in, (byte[])buffer);
            }
        });
        try {
            Locale parcefoneLocale = Locale.forLanguageTag(context.getProperty(DATETIME_REPRESENTATION).getValue());
            boolean validateData = context.getProperty(VALIDATE_DATA).asBoolean();
            boolean acceptEmptyExtensions = context.getProperty(ACCEPT_EMPTY_EXTENSIONS).asBoolean();
            event = parser.parse(buffer, validateData, acceptEmptyExtensions, parcefoneLocale);
        }
        catch (Exception e) {
            this.getLogger().error("CEF Parsing Failed: {}", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        if (event == null) {
            this.getLogger().error("Failed to parse {} as a CEF message: it does not conform to the CEF standard; routing to failure", new Object[]{flowFile});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        try {
            String destination = context.getProperty(FIELDS_DESTINATION).getValue();
            boolean includeCustomExtensions = context.getProperty(INCLUDE_CUSTOM_EXTENSIONS).asBoolean();
            switch (destination) {
                case "flowfile-attribute": {
                    HashMap<CallSite, String> attributes = new HashMap<CallSite, String>();
                    for (Map.Entry entry : event.getHeader().entrySet()) {
                        attributes.put((CallSite)((Object)("cef.header." + (String)entry.getKey())), this.prettyResult(entry.getValue(), this.tzId));
                    }
                    for (Map.Entry entry : event.getExtension(true, includeCustomExtensions).entrySet()) {
                        attributes.put((CallSite)((Object)("cef.extension." + (String)entry.getKey())), this.prettyResult(entry.getValue(), this.tzId));
                        flowFile = session.putAllAttributes(flowFile, attributes);
                    }
                    break;
                }
                case "flowfile-content": {
                    final ObjectNode results = mapper.createObjectNode();
                    results.set("header", mapper.valueToTree((Object)event.getHeader()));
                    results.set("extension", mapper.valueToTree((Object)event.getExtension(true, includeCustomExtensions)));
                    if (context.getProperty(APPEND_RAW_MESSAGE_TO_JSON).asBoolean().booleanValue()) {
                        results.set("_raw", mapper.valueToTree((Object)new String(buffer)));
                    }
                    flowFile = session.write(flowFile, new OutputStreamCallback(){

                        public void process(OutputStream out) throws IOException {
                            try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                                ((OutputStream)outputStream).write(mapper.writeValueAsBytes((Object)results));
                            }
                        }
                    });
                    flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
                    session.getProvenanceReporter().modifyContent(flowFile, "Replaced content with parsed CEF fields and values");
                }
            }
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (CEFHandlingException e) {
            this.getLogger().error("Reading CEF Event Failed: {}", new Object[]{flowFile, e});
            session.getProvenanceReporter().route(flowFile, REL_FAILURE);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private String prettyResult(Object entryValue, String tzID) {
        if (entryValue instanceof InetAddress) {
            return ((InetAddress)entryValue).getHostAddress();
        }
        if (entryValue instanceof Date) {
            ZonedDateTime zdt = ZonedDateTime.from(((Date)entryValue).toInstant().atZone(ZoneId.of(tzID)));
            return String.valueOf(zdt.format(dateTimeFormatter));
        }
        return String.valueOf(entryValue);
    }

    protected static class ValidateLocale
    implements Validator {
        protected ValidateLocale() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (null == input || input.isEmpty()) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(subject + " cannot be empty").build();
            }
            Locale testLocale = Locale.forLanguageTag(input);
            if ("".equals(testLocale.toString())) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(input + " is not a valid locale format.").build();
            }
            return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
        }
    }

    private class MacAddressToStringSerializer
    extends JsonSerializer<MacAddress> {
        private MacAddressToStringSerializer() {
        }

        public void serialize(MacAddress macAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)macAddress.toString());
        }
    }
}

