/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.NullOutputStream;
import org.apache.nifi.stream.io.StreamUtils;

@Deprecated
@DeprecationNotice(classNames={"org.apache.nifi.processors.standard.CryptographicHashContent"}, reason="This processor is deprecated and may be removed in future releases.")
@EventDriven
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"hash", "content", "MD5", "SHA-1", "SHA-256"})
@CapabilityDescription(value="Calculates a hash value for the Content of a FlowFile and puts that hash value on the FlowFile as an attribute whose name is determined by the <Hash Attribute Name> property. This processor did not provide a consistent offering of hash algorithms, and is now deprecated. For modern cryptographic hashing capabilities, see \"CryptographicHashContent\". ")
@WritesAttribute(attribute="<Hash Attribute Name>", description="This Processor adds an attribute whose value is the result of Hashing the existing FlowFile content. The name of this attribute is specified by the <Hash Attribute Name> property")
public class HashContent
extends AbstractProcessor {
    public static final PropertyDescriptor ATTRIBUTE_NAME = new PropertyDescriptor.Builder().name("Hash Attribute Name").description("The name of the FlowFile Attribute into which the Hash Value should be written. If the value already exists, it will be overwritten").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("hash.value").build();
    public static final PropertyDescriptor HASH_ALGORITHM = new PropertyDescriptor.Builder().name("Hash Algorithm").description("Determines what hashing algorithm should be used to perform the hashing function").required(true).allowableValues(Security.getAlgorithms("MessageDigest")).defaultValue("MD5").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are process successfully will be sent to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that cannot be processed successfully will be sent to this relationship without any attribute being added").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(ATTRIBUTE_NAME);
        props.add(HASH_ALGORITHM);
        this.properties = Collections.unmodifiableList(props);
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(rels);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        MessageDigest digest;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        String algorithm = context.getProperty(HASH_ALGORITHM).getValue();
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to process {}", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        final AtomicReference<Object> hashValueHolder = new AtomicReference<Object>(null);
        try {
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream in) throws IOException {
                    try (DigestOutputStream digestOut = new DigestOutputStream((OutputStream)new NullOutputStream(), digest);){
                        StreamUtils.copy((InputStream)in, (OutputStream)digestOut);
                        byte[] hash = digest.digest();
                        StringBuilder strb = new StringBuilder(hash.length * 2);
                        for (int i = 0; i < hash.length; ++i) {
                            strb.append(Integer.toHexString(hash[i] & 0xFF | 0x100), 1, 3);
                        }
                        hashValueHolder.set(strb.toString());
                    }
                }
            });
            String attributeName = context.getProperty(ATTRIBUTE_NAME).getValue();
            flowFile = session.putAttribute(flowFile, attributeName, (String)hashValueHolder.get());
            logger.info("Successfully added attribute '{}' to {} with a value of {}; routing to success", new Object[]{attributeName, flowFile, hashValueHolder.get()});
            session.getProvenanceReporter().modifyAttributes(flowFile);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (ProcessException e) {
            logger.error("Failed to process {}", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

