/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.standard.db.ColumnDescription;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.TableSchema;
import org.apache.nifi.processors.standard.db.impl.Oracle12DatabaseAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOracle12DatabaseAdapter {
    private final DatabaseAdapter db = new Oracle12DatabaseAdapter();

    @Test
    public void testGeneration() {
        String sql1 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", null, null);
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename";
        Assertions.assertEquals((Object)sql1, (Object)expected1);
        String sql2 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "that='some\"' value'", "", null, null);
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE that='some\"' value'";
        Assertions.assertEquals((Object)sql2, (Object)expected2);
        String sql3 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "that='some\"' value'", "might DESC", null, null);
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE that='some\"' value' ORDER BY might DESC";
        Assertions.assertEquals((Object)sql3, (Object)expected3);
        String sql4 = this.db.getSelectStatement("database.tablename", "", "that='some\"' value'", "might DESC", null, null);
        String expected4 = "SELECT * FROM database.tablename WHERE that='some\"' value' ORDER BY might DESC";
        Assertions.assertEquals((Object)sql4, (Object)expected4);
    }

    @Test
    public void testNoTableName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.db.getSelectStatement("", "some(set),of(columns),that,might,contain,methods,a.*", "", "", null, null));
    }

    @Test
    public void testPagingQuery() {
        String sql1 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "contain", Long.valueOf(100L), Long.valueOf(0L));
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename ORDER BY contain FETCH NEXT 100 ROWS ONLY";
        Assertions.assertEquals((Object)sql1, (Object)expected1);
        String sql2 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "contain", Long.valueOf(10000L), Long.valueOf(123456L));
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename ORDER BY contain OFFSET 123456 ROWS FETCH NEXT 10000 ROWS ONLY";
        Assertions.assertEquals((Object)sql2, (Object)expected2);
        String sql3 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "methods='strange'", "contain", Long.valueOf(10000L), Long.valueOf(123456L));
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE methods='strange' ORDER BY contain OFFSET 123456 ROWS FETCH NEXT 10000 ROWS ONLY";
        Assertions.assertEquals((Object)sql3, (Object)expected3);
        String sql4 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", Long.valueOf(100L), null);
        String expected4 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename FETCH NEXT 100 ROWS ONLY";
        Assertions.assertEquals((Object)sql4, (Object)expected4);
    }

    @Test
    public void testPagingQueryUsingColumnValuesForPartitioning() {
        String sql1 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "1=1", "contain", Long.valueOf(100L), Long.valueOf(0L), "contain");
        String expected1 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE 1=1 AND contain >= 0 AND contain < 100";
        Assertions.assertEquals((Object)expected1, (Object)sql1);
        String sql2 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "1=1", "contain", Long.valueOf(10000L), Long.valueOf(123456L), "contain");
        String expected2 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE 1=1 AND contain >= 123456 AND contain < 133456";
        Assertions.assertEquals((Object)expected2, (Object)sql2);
        String sql3 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "methods='strange'", "contain", Long.valueOf(10000L), Long.valueOf(123456L), "contain");
        String expected3 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename WHERE methods='strange' AND contain >= 123456 AND contain < 133456";
        Assertions.assertEquals((Object)expected3, (Object)sql3);
        String sql4 = this.db.getSelectStatement("database.tablename", "some(set),of(columns),that,might,contain,methods,a.*", "", "", Long.valueOf(100L), null, "contain");
        String expected4 = "SELECT some(set),of(columns),that,might,contain,methods,a.* FROM database.tablename";
        Assertions.assertEquals((Object)expected4, (Object)sql4);
    }

    @Test
    public void testSupportsUpsert() {
        Assertions.assertTrue((boolean)this.db.supportsUpsert(), (String)(this.db.getClass().getSimpleName() + " should support upsert"));
    }

    @Test
    public void testGetUpsertStatementWithNullTableName() {
        this.testGetUpsertStatement(null, Arrays.asList("notEmpty"), Arrays.asList("notEmpty"), new IllegalArgumentException("Table name cannot be null or blank"));
    }

    @Test
    public void testGetUpsertStatementWithBlankTableName() {
        this.testGetUpsertStatement("", Arrays.asList("notEmpty"), Arrays.asList("notEmpty"), new IllegalArgumentException("Table name cannot be null or blank"));
    }

    @Test
    public void testGetUpsertStatementWithNullColumnNames() {
        this.testGetUpsertStatement("notEmpty", null, Arrays.asList("notEmpty"), new IllegalArgumentException("Column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatementWithEmptyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Collections.emptyList(), Arrays.asList("notEmpty"), new IllegalArgumentException("Column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatementWithNullKeyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Arrays.asList("notEmpty"), null, new IllegalArgumentException("Key column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatementWithEmptyKeyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Arrays.asList("notEmpty"), Collections.emptyList(), new IllegalArgumentException("Key column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatement() {
        String tableName = "table";
        List<String> columnNames = Arrays.asList("column1", "column2", "column3", "column_4");
        List<String> uniqueKeyColumnNames = Arrays.asList("column1", "column4");
        String expected = "MERGE INTO table USING (SELECT ? column1, ? column2, ? column3, ? column_4 FROM DUAL) n ON (table.column1 = n.column1 AND table.column_4 = n.column_4) WHEN NOT MATCHED THEN INSERT (column1, column2, column3, column_4) VALUES (n.column1, n.column2, n.column3, n.column_4) WHEN MATCHED THEN UPDATE SET table.column2 = n.column2, table.column3 = n.column3";
        this.testGetUpsertStatement(tableName, columnNames, uniqueKeyColumnNames, expected);
    }

    @Test
    public void testGetCreateTableStatement() {
        Assertions.assertTrue((boolean)this.db.supportsCreateTableIfNotExists());
        List<ColumnDescription> columns = Arrays.asList(new ColumnDescription("col1", 4, true, Integer.valueOf(4), false), new ColumnDescription("col2", 12, false, Integer.valueOf(2000), true));
        TableSchema tableSchema = new TableSchema("USERS", null, "TEST_TABLE", columns, true, Collections.singleton("COL1"), this.db.getColumnQuoteString());
        String expectedStatement = "DECLARE\n\tsql_stmt long;\nBEGIN\n\tsql_stmt:='CREATE TABLE \"USERS\".\"TEST_TABLE\" (\"col1\" INTEGER NOT NULL, \"col2\" VARCHAR2(2000))';\nEXECUTE IMMEDIATE sql_stmt;\nEXCEPTION\n\tWHEN OTHERS THEN\n\t\tIF SQLCODE = -955 THEN\n\t\t\tNULL;\n\t\tELSE\n\t\t\tRAISE;\n\t\tEND IF;\nEND;";
        String actualStatement = this.db.getCreateTableStatement(tableSchema, true, true);
        Assertions.assertEquals((Object)expectedStatement, (Object)actualStatement);
    }

    private void testGetUpsertStatement(String tableName, List<String> columnNames, Collection<String> uniqueKeyColumnNames, IllegalArgumentException expected) {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.testGetUpsertStatement(tableName, columnNames, uniqueKeyColumnNames, (String)null));
        Assertions.assertEquals((Object)expected.getMessage(), (Object)e.getMessage());
    }

    private void testGetUpsertStatement(String tableName, List<String> columnNames, Collection<String> uniqueKeyColumnNames, String expected) {
        String actual = this.db.getUpsertStatement(tableName, columnNames, uniqueKeyColumnNames);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

