/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.json.JsonRecordSetWriter;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.processors.standard.AbstractRecordProcessor;
import org.apache.nifi.processors.standard.RemoveRecordField;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.serialization.SchemaRegistryRecordSetWriter;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestRemoveRecordField {
    private TestRunner runner;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String TEST_RESOURCES_FOLDER = "src/test/resources/TestRemoveRecordField";

    TestRemoveRecordField() {
    }

    @BeforeEach
    void setup() throws InitializationException {
        this.runner = TestRunners.newTestRunner(RemoveRecordField.class);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.INHERIT_RECORD_SCHEMA);
        this.runner.setProperty((ControllerService)jsonWriter, JsonRecordSetWriter.SUPPRESS_NULLS, JsonRecordSetWriter.NEVER_SUPPRESS);
        this.runner.setProperty((ControllerService)jsonWriter, JsonRecordSetWriter.PRETTY_PRINT_JSON, "true");
        this.runner.setProperty((ControllerService)jsonWriter, jsonWriter.getSchemaWriteStrategyDescriptor(), SchemaRegistryRecordSetWriter.AVRO_SCHEMA_ATTRIBUTE);
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.setProperty(AbstractRecordProcessor.RECORD_WRITER, "writer");
    }

    @Test
    void testNotRootPath() throws InitializationException, IOException {
        this.setUpJsonReader(null);
        this.runner.setProperty("root_path", "/");
        this.runner.assertNotValid();
    }

    @Test
    void testNotRootPathEL() throws InitializationException, IOException {
        this.runner.assertNotValid();
        this.setUpJsonReader(null);
        this.runner.setProperty("root_path", "${remove.path}");
        this.runner.assertValid();
        this.runner.enqueue("{}".getBytes(StandardCharsets.UTF_8), Collections.singletonMap("remove.path", "/"));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(AbstractRecordProcessor.REL_FAILURE, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractRecordProcessor.REL_FAILURE).get(0)).assertAttributeEquals("record.error.message", "org.apache.nifi.processor.exception.ProcessException Thrown");
    }

    @Test
    void testRemoveSimpleFieldWithSchemaInference() throws InitializationException, IOException {
        String inputContent = "complex-person.json";
        String outputContent = "complex-person-no-dateOfBirth.json";
        String fieldToRemove = "/dateOfBirth";
        this.executeRemovalTest(null, "complex-person.json", null, "complex-person-no-dateOfBirth.json", "/dateOfBirth");
    }

    @Test
    void testRemoveSimpleFieldThatIsMissingFromOneRecord() throws InitializationException, IOException {
        String inputSchema = "complex-person.avsc";
        String inputContent = "complex-person.json";
        String outputSchema = "complex-person-no-dateOfBirth.avsc";
        String outputContent = "complex-person-no-dateOfBirth.json";
        String fieldToRemove = "/dateOfBirth";
        this.executeRemovalTest("complex-person.avsc", "complex-person.json", "complex-person-no-dateOfBirth.avsc", "complex-person-no-dateOfBirth.json", "/dateOfBirth");
    }

    @Test
    void testRemoveComplexFieldThatIsMissingFromOneRecord() throws InitializationException, IOException {
        String inputSchema = "complex-person.avsc";
        String inputFlowFile = "complex-person.json";
        String outputSchema = "complex-person-no-workAddress.avsc";
        String outputFlowFile = "complex-person-no-workAddress.json";
        String fieldToRemove = "/workAddress";
        this.executeRemovalTest("complex-person.avsc", "complex-person.json", "complex-person-no-workAddress.avsc", "complex-person-no-workAddress.json", "/workAddress");
    }

    @Test
    void testRemoveFieldFrom3LevelDeepStructure() throws InitializationException, IOException {
        String inputSchema = "complex-person.avsc";
        String inputFlowFile = "complex-person.json";
        String outputSchema = "complex-person-no-workAddress-building-letter.avsc";
        String outputFlowFile = "complex-person-no-workAddress-building-letter.json";
        String fieldToRemove = "/workAddress/building/letter";
        this.executeRemovalTest("complex-person.avsc", "complex-person.json", "complex-person-no-workAddress-building-letter.avsc", "complex-person-no-workAddress-building-letter.json", "/workAddress/building/letter");
    }

    @Test
    void testRemoveNestedFieldFromDeepStructureWithRelativePath() throws InitializationException, IOException {
        String inputSchema = "complex-person.avsc";
        String inputFlowFile = "complex-person.json";
        String outputSchema = "complex-person-no-workAddress-building-letter.avsc";
        String outputFlowFile = "complex-person-no-workAddress-building-letter.json";
        String fieldToRemove = "/workAddress//letter";
        this.executeRemovalTest("complex-person.avsc", "complex-person.json", "complex-person-no-workAddress-building-letter.avsc", "complex-person-no-workAddress-building-letter.json", "/workAddress//letter");
    }

    @Test
    void testRemoveFieldFromNonExistentParent() throws InitializationException, IOException {
        String inputSchema = "complex-person.avsc";
        String inputFlowFile = "complex-person.json";
        String outputSchema = "complex-person.avsc";
        String outputFlowFile = "complex-person.json";
        String fieldToRemove = "/workAddress/nonExistent/letter";
        this.executeRemovalTest("complex-person.avsc", "complex-person.json", "complex-person.avsc", "complex-person.json", "/workAddress/nonExistent/letter");
    }

    @Test
    void testRemoveNonExistentField() throws InitializationException, IOException {
        String inputSchema = "complex-person.avsc";
        String inputFlowFile = "complex-person.json";
        String outputSchema = "complex-person.avsc";
        String outputFlowFile = "complex-person.json";
        String fieldToRemove = "/nonExistentField";
        this.executeRemovalTest("complex-person.avsc", "complex-person.json", "complex-person.avsc", "complex-person.json", "/nonExistentField");
    }

    @Test
    void testRemoveMultipleFields() throws InitializationException, IOException {
        String inputSchema = "complex-person.avsc";
        String inputFlowFile = "complex-person.json";
        String outputSchema = "complex-person-multiple-fields-removed.avsc";
        String outputFlowFile = "complex-person-multiple-fields-removed.json";
        String fieldToRemove1 = "/name";
        String fieldToRemove2 = "/dateOfBirth";
        String fieldToRemove3 = "/workAddress/building";
        this.executeRemovalTest("complex-person.avsc", "complex-person.json", "complex-person-multiple-fields-removed.avsc", "complex-person-multiple-fields-removed.json", "/name", "/dateOfBirth", "/workAddress/building");
    }

    @Test
    void testRemoveEntireArrayFieldWithSchemaInference() throws InitializationException, IOException {
        String inputFlowFile = "address-array.json";
        String outputFlowFile = "address-array-removed.json";
        String fieldToRemove = "/addresses";
        this.executeRemovalTest(null, "address-array.json", null, "address-array-removed.json", "/addresses");
    }

    @Test
    void testRemoveEntireArrayField() throws InitializationException, IOException {
        String inputSchema = "address-array.avsc";
        String inputFlowFile = "address-array.json";
        String outputSchema = "address-array-field-removed.avsc";
        String outputFlowFile = "address-array-removed.json";
        String fieldToRemove = "/addresses";
        this.executeRemovalTest("address-array.avsc", "address-array.json", "address-array-field-removed.avsc", "address-array-removed.json", "/addresses");
    }

    @Test
    void testRemoveOneElementFromArray() throws InitializationException, IOException {
        String inputSchema = "address-array.avsc";
        String inputFlowFile = "address-array.json";
        String outputSchema = "address-array.avsc";
        String outputFlowFile = "address-array-one-element-removed.json";
        String fieldToRemove = "/addresses[1]";
        this.executeRemovalTest("address-array.avsc", "address-array.json", "address-array.avsc", "address-array-one-element-removed.json", "/addresses[1]");
    }

    @Test
    void testRemoveAllElementsFromArrayAsterisk() throws InitializationException, IOException {
        String inputSchema = "address-array.avsc";
        String inputFlowFile = "address-array.json";
        String outputSchema = "address-array.avsc";
        String outputFlowFile = "address-array-empty.json";
        String fieldToRemove = "/addresses[*]";
        this.executeRemovalTest("address-array.avsc", "address-array.json", "address-array.avsc", "address-array-empty.json", "/addresses[*]");
    }

    @Test
    void testRemoveAllElementsFromArrayIndexRange() throws InitializationException, IOException {
        String inputSchema = "address-array.avsc";
        String inputFlowFile = "address-array.json";
        String outputSchema = "address-array.avsc";
        String outputFlowFile = "address-array-empty.json";
        String fieldToRemove = "/addresses[0..-1]";
        this.executeRemovalTest("address-array.avsc", "address-array.json", "address-array.avsc", "address-array-empty.json", "/addresses[0..-1]");
    }

    @Test
    void testRemoveFieldFromOneArrayElement() throws InitializationException, IOException {
        String inputSchema = "address-array.avsc";
        String inputFlowFile = "address-array.json";
        String outputSchema = "address-array.avsc";
        String outputFlowFile = "address-array-zip-removed-from-one-element.json";
        String fieldToRemove = "/addresses[1]/zip";
        this.executeRemovalTest("address-array.avsc", "address-array.json", "address-array.avsc", "address-array-zip-removed-from-one-element.json", "/addresses[1]/zip");
    }

    @Test
    void testRemoveFieldFromAllArrayElements() throws InitializationException, IOException {
        String inputSchema = "address-array.avsc";
        String inputFlowFile = "address-array.json";
        String outputSchema = "address-array-zip-removed.avsc";
        String outputFlowFile = "address-array-zip-removed-from-all-elements.json";
        String fieldToRemove = "/addresses[*]/zip";
        this.executeRemovalTest("address-array.avsc", "address-array.json", "address-array-zip-removed.avsc", "address-array-zip-removed-from-all-elements.json", "/addresses[*]/zip");
    }

    @Test
    void testMapRemoveOneItem() throws InitializationException, IOException {
        String inputSchema = "bookshelf-map.avsc";
        String inputFlowFile = "bookshelf-map.json";
        String outputSchema = "bookshelf-map.avsc";
        String outputFlowFile = "bookshelf-map-one-item-removed.json";
        String fieldToRemove = "/books['ISBN_2222222222222']";
        this.executeRemovalTest("bookshelf-map.avsc", "bookshelf-map.json", "bookshelf-map.avsc", "bookshelf-map-one-item-removed.json", "/books['ISBN_2222222222222']");
    }

    @Test
    void testMapRemoveFieldFromOneItem() throws InitializationException, IOException {
        String inputSchema = "bookshelf-map.avsc";
        String inputFlowFile = "bookshelf-map.json";
        String outputSchema = "bookshelf-map.avsc";
        String outputFlowFile = "bookshelf-map-field-removed-from-one-element.json";
        String fieldToRemove = "/books['ISBN_2222222222222']/author";
        this.executeRemovalTest("bookshelf-map.avsc", "bookshelf-map.json", "bookshelf-map.avsc", "bookshelf-map-field-removed-from-one-element.json", "/books['ISBN_2222222222222']/author");
    }

    @Test
    void testMapRemoveFieldFromAllItems() throws InitializationException, IOException {
        String inputSchema = "bookshelf-map.avsc";
        String inputFlowFile = "bookshelf-map.json";
        String outputSchema = "bookshelf-map-author-field-removed.avsc";
        String outputFlowFile = "bookshelf-map-field-removed-from-all-elements.json";
        String fieldToRemove = "/books[*]/author";
        this.executeRemovalTest("bookshelf-map.avsc", "bookshelf-map.json", "bookshelf-map-author-field-removed.avsc", "bookshelf-map-field-removed-from-all-elements.json", "/books[*]/author");
    }

    @Test
    void testMapRemoveAllItems() throws InitializationException, IOException {
        String inputSchema = "bookshelf-map.avsc";
        String inputFlowFile = "bookshelf-map.json";
        String outputSchema = "bookshelf-map.avsc";
        String outputFlowFile = "bookshelf-map-all-items-removed.json";
        String fieldToRemove = "/books[*]";
        this.executeRemovalTest("bookshelf-map.avsc", "bookshelf-map.json", "bookshelf-map.avsc", "bookshelf-map-all-items-removed.json", "/books[*]");
    }

    @Test
    void testChoiceRemoveFieldFromPossibleSubtypeWithSchemaInference() throws InitializationException, IOException {
        String inputFlowFile = "name-choice.json";
        String outputFlowFile = "name-choice-firstName-removed.json";
        String fieldToRemove = "/name/firstName";
        this.executeRemovalTest(null, "name-choice.json", null, "name-choice-firstName-removed.json", "/name/firstName");
    }

    @Test
    void testChoiceRemoveFieldFromPossibleSubtype() throws InitializationException, IOException {
        String inputSchema = "name-choice.avsc";
        String inputFlowFile = "name-choice.json";
        String outputSchema = "name-choice-firstName-removed.avsc";
        String outputFlowFile = "name-choice-firstName-removed.json";
        String fieldToRemove = "/name/firstName";
        this.executeRemovalTest("name-choice.avsc", "name-choice.json", "name-choice-firstName-removed.avsc", "name-choice-firstName-removed.json", "/name/firstName");
    }

    @Test
    void testChoiceRemoveFieldFromChoiceInChoice() throws InitializationException, IOException {
        String inputSchema = "address-choice.avsc";
        String inputFlowFile = "address-choice.json";
        String outputSchema = "address-choice-letter-removed-from-building.avsc";
        String outputFlowFile = "address-choice-letter-removed-from-building.json";
        String fieldToRemove = "/address/building/letter";
        this.executeRemovalTest("address-choice.avsc", "address-choice.json", "address-choice-letter-removed-from-building.avsc", "address-choice-letter-removed-from-building.json", "/address/building/letter");
    }

    private void executeRemovalTest(String inputSchema, String inputFlowFile, String outputSchema, String outputFlowFile, String ... fieldsToRemove) throws IOException, InitializationException {
        this.executePreparation(inputSchema, inputFlowFile, fieldsToRemove);
        this.runner.run();
        this.assertOutput(outputSchema, outputFlowFile);
    }

    private void executePreparation(String inputSchema, String inputFlowFile, String ... fieldsToRemove) throws IOException, InitializationException {
        this.setUpJsonReader(inputSchema);
        String fieldName = "field-to-remove-";
        AtomicInteger counter = new AtomicInteger(0);
        Map<String, String> properties = Arrays.stream(fieldsToRemove).collect(Collectors.toMap(f -> "field-to-remove-" + counter.incrementAndGet(), f -> f));
        this.setUpRunner(inputFlowFile, properties);
    }

    private void assertOutput(String outputSchema, String outputContent) throws IOException {
        this.runner.assertAllFlowFilesTransferred(AbstractRecordProcessor.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(AbstractRecordProcessor.REL_SUCCESS).get(0);
        JsonNode expectedOutput = OBJECT_MAPPER.readTree(Paths.get(TEST_RESOURCES_FOLDER, "output", outputContent).toFile());
        JsonNode output = OBJECT_MAPPER.readTree(out.getContent());
        Assertions.assertEquals((Object)expectedOutput, (Object)output);
        if (outputSchema != null) {
            JsonNode expectedSchema = OBJECT_MAPPER.readTree(Paths.get(TEST_RESOURCES_FOLDER, "output_schema", outputSchema).toFile());
            JsonNode schema = OBJECT_MAPPER.readTree(out.getAttribute("avro.schema"));
            Assertions.assertEquals((Object)expectedSchema, (Object)schema);
        } else {
            out.assertAttributeExists("avro.schema");
            out.assertAttributeNotEquals("avro.schema", "");
        }
    }

    private void setUpJsonReader(String schemaFilePath) throws IOException, InitializationException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        if (schemaFilePath == null) {
            this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA);
        } else {
            String inputSchemaText = new String(Files.readAllBytes(Paths.get(TEST_RESOURCES_FOLDER, "input_schema", schemaFilePath)));
            this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
            this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        }
        this.runner.enableControllerService((ControllerService)jsonReader);
        this.runner.setProperty(AbstractRecordProcessor.RECORD_READER, "reader");
    }

    private void setUpRunner(String flowFilePath, Map<String, String> properties) throws IOException {
        this.runner.enqueue(Paths.get(TEST_RESOURCES_FOLDER, "input", flowFilePath));
        properties.forEach((propertyName, propertyValue) -> this.runner.setProperty(propertyName, propertyValue));
    }
}

