/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.json.JsonRecordSetWriter;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.lookup.RecordLookupService;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.processors.standard.LookupRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLookupRecord {
    private TestRunner runner;
    private MapLookup lookupService;
    private MockRecordParser recordReader;
    private MockRecordWriter recordWriter;

    @BeforeEach
    public void setup() throws InitializationException {
        this.recordReader = new MockRecordParser();
        this.recordWriter = new MockRecordWriter(null, false);
        this.lookupService = new MapLookup();
        this.runner = TestRunners.newTestRunner(LookupRecord.class);
        this.runner.addControllerService("reader", (ControllerService)this.recordReader);
        this.runner.enableControllerService((ControllerService)this.recordReader);
        this.runner.addControllerService("writer", (ControllerService)this.recordWriter);
        this.runner.enableControllerService((ControllerService)this.recordWriter);
        this.runner.addControllerService("lookup", (ControllerService)this.lookupService);
        this.runner.enableControllerService((ControllerService)this.lookupService);
        this.runner.setProperty(LookupRecord.RECORD_READER, "reader");
        this.runner.setProperty(LookupRecord.RECORD_WRITER, "writer");
        this.runner.setProperty(LookupRecord.LOOKUP_SERVICE, "lookup");
        this.runner.setProperty("lookup", "/name");
        this.runner.setProperty(LookupRecord.RESULT_RECORD_PATH, "/sport");
        this.runner.setProperty(LookupRecord.ROUTING_STRATEGY, LookupRecord.ROUTE_TO_MATCHED_UNMATCHED);
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("sport", RecordFieldType.STRING);
        this.recordReader.addRecord(new Object[]{"John Doe", 48, null, null});
        this.recordReader.addRecord(new Object[]{"Jane Doe", 47, null, null});
        this.recordReader.addRecord(new Object[]{"Jimmy Doe", 14, null, null});
    }

    @Test
    public void testFlowfileAttributesPassed() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("schema.name", "person");
        attrs.put("something_something", "test");
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.putAll(attrs);
        this.lookupService.setExpectedContext(expected);
        this.lookupService.addValue("John Doe", "Soccer");
        this.lookupService.addValue("Jane Doe", "Basketball");
        this.lookupService.addValue("Jimmy Doe", "Football");
        this.runner.enqueue("", attrs);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_MATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("John Doe,48,Soccer\nJane Doe,47,Basketball\nJimmy Doe,14,Football\n");
    }

    @Test
    public void testAllMatch() {
        this.lookupService.addValue("John Doe", "Soccer");
        this.lookupService.addValue("Jane Doe", "Basketball");
        this.lookupService.addValue("Jimmy Doe", "Football");
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_MATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("John Doe,48,Soccer\nJane Doe,47,Basketball\nJimmy Doe,14,Football\n");
    }

    @Test
    public void testLookupWithTimestamp() {
        this.recordReader.addSchemaField("record_timestamp", RecordFieldType.TIMESTAMP);
        this.runner.setProperty("lookup", "/record_timestamp");
        Timestamp timestamp = new Timestamp(0L);
        String timestampKey = timestamp.toString();
        this.recordReader.addRecord(new Object[]{"Jason Doe", 15, null, timestamp});
        this.lookupService.addValue(timestampKey, "Bowling");
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertTransferCount(LookupRecord.REL_MATCHED, 1);
        this.runner.assertTransferCount(LookupRecord.REL_UNMATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        out.assertAttributeEquals("record.count", "1");
        out.assertAttributeEquals("mime.type", "text/plain");
        String contents = out.getContent();
        Assertions.assertTrue((boolean)contents.matches("Jason Doe,15,Bowling,19[0-9]{2}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}\n"));
    }

    @Test
    public void testAllUnmatched() {
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_UNMATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_UNMATCHED).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("John Doe,48,\nJane Doe,47,\nJimmy Doe,14,\n");
    }

    @Test
    public void testMixtureOfMatch() {
        this.lookupService.addValue("John Doe", "Soccer");
        this.lookupService.addValue("Jimmy Doe", "Football");
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertTransferCount(LookupRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(LookupRecord.REL_MATCHED, 1);
        this.runner.assertTransferCount(LookupRecord.REL_UNMATCHED, 1);
        MockFlowFile matched = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        matched.assertAttributeEquals("record.count", "2");
        matched.assertAttributeEquals("mime.type", "text/plain");
        matched.assertContentEquals("John Doe,48,Soccer\nJimmy Doe,14,Football\n");
        MockFlowFile unmatched = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_UNMATCHED).get(0);
        unmatched.assertAttributeEquals("record.count", "1");
        unmatched.assertAttributeEquals("mime.type", "text/plain");
        unmatched.assertContentEquals("Jane Doe,47,\n");
    }

    @Test
    public void testAllMatchButFirstRouteToSuccess() {
        this.lookupService.addValue("Jane Doe", "Soccer");
        this.lookupService.addValue("Jimmy Doe", "Football");
        this.runner.setProperty(LookupRecord.ROUTING_STRATEGY, LookupRecord.ROUTE_TO_SUCCESS);
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertTransferCount(LookupRecord.REL_FAILURE, 0);
        this.runner.assertTransferCount(LookupRecord.REL_SUCCESS, 1);
        MockFlowFile matched = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_SUCCESS).get(0);
        matched.assertAttributeEquals("record.count", "3");
        matched.assertAttributeEquals("mime.type", "text/plain");
        matched.assertContentEquals("John Doe,48,\nJane Doe,47,Soccer\nJimmy Doe,14,Football\n");
    }

    @Test
    public void testResultPathNotFound() {
        this.runner.setProperty(LookupRecord.RESULT_RECORD_PATH, "/other");
        this.lookupService.addValue("John Doe", "Soccer");
        this.lookupService.addValue("Jane Doe", "Basketball");
        this.lookupService.addValue("Jimmy Doe", "Football");
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_MATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("John Doe,48,,Soccer\nJane Doe,47,,Basketball\nJimmy Doe,14,,Football\n");
    }

    @Test
    public void testLookupPathNotFound() {
        this.runner.setProperty("lookup", "/other");
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_UNMATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_UNMATCHED).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("John Doe,48,\nJane Doe,47,\nJimmy Doe,14,\n");
    }

    @Test
    public void testUnparseableData() {
        this.recordReader.failAfter(1);
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_FAILURE, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_FAILURE).get(0);
        out.assertAttributeNotExists("record.count");
        out.assertContentEquals("");
    }

    @Test
    public void testNoResultPath() {
        this.lookupService.addValue("John Doe", "Soccer");
        this.lookupService.addValue("Jane Doe", "Basketball");
        this.lookupService.addValue("Jimmy Doe", "Football");
        this.runner.removeProperty(LookupRecord.RESULT_RECORD_PATH);
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_MATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("John Doe,48,\nJane Doe,47,\nJimmy Doe,14,\n");
    }

    @Test
    public void testMultipleLookupPaths() {
        this.lookupService.addValue("John Doe", "Soccer");
        this.lookupService.addValue("Jane Doe", "Basketball");
        this.lookupService.addValue("Jimmy Doe", "Football");
        this.runner.setProperty("lookup", "/*");
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_UNMATCHED, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_UNMATCHED).get(0);
        out.assertAttributeEquals("record.count", "3");
        out.assertAttributeEquals("mime.type", "text/plain");
        out.assertContentEquals("John Doe,48,\nJane Doe,47,\nJimmy Doe,14,\n");
    }

    @Test
    public void testInvalidUnlessAllRequiredPropertiesAdded() {
        this.runner.removeProperty(new PropertyDescriptor.Builder().name("lookup").build());
        this.runner.setProperty("hello", "/name");
        this.runner.assertNotValid();
        this.runner.setProperty("lookup", "xx");
        this.runner.assertNotValid();
        this.runner.setProperty("lookup", "/name");
        this.runner.assertValid();
    }

    @Test
    public void testAddFieldsToExistingRecord() throws InitializationException {
        RecordLookup lookupService = new RecordLookup();
        this.runner.addControllerService("lookup", (ControllerService)lookupService);
        this.runner.enableControllerService((ControllerService)lookupService);
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        fields.add(new RecordField("favorite", RecordFieldType.STRING.getDataType()));
        fields.add(new RecordField("least", RecordFieldType.STRING.getDataType()));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        MapRecord sports = new MapRecord((RecordSchema)schema, new HashMap());
        sports.setValue("favorite", (Object)"basketball");
        sports.setValue("least", (Object)"soccer");
        lookupService.addValue("John Doe", (Record)sports);
        this.recordReader = new MockRecordParser();
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("favorite", RecordFieldType.STRING);
        this.recordReader.addSchemaField("least", RecordFieldType.STRING);
        this.recordReader.addRecord(new Object[]{"John Doe", 48, null, "baseball"});
        this.runner.addControllerService("reader", (ControllerService)this.recordReader);
        this.runner.enableControllerService((ControllerService)this.recordReader);
        this.runner.setProperty("lookup", "/name");
        this.runner.setProperty(LookupRecord.RESULT_RECORD_PATH, "/");
        this.runner.setProperty(LookupRecord.RESULT_CONTENTS, LookupRecord.RESULT_RECORD_FIELDS);
        this.runner.enqueue("");
        this.runner.run();
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        out.assertContentEquals("John Doe,48,basketball,soccer\n");
    }

    @Test
    public void testAddFieldsToNonExistentRecord() throws InitializationException {
        RecordLookup lookupService = new RecordLookup();
        this.runner.addControllerService("lookup", (ControllerService)lookupService);
        this.runner.enableControllerService((ControllerService)lookupService);
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        fields.add(new RecordField("favorite", RecordFieldType.STRING.getDataType()));
        fields.add(new RecordField("least", RecordFieldType.STRING.getDataType()));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        MapRecord sports = new MapRecord((RecordSchema)schema, new HashMap());
        sports.setValue("favorite", (Object)"basketball");
        sports.setValue("least", (Object)"soccer");
        lookupService.addValue("John Doe", (Record)sports);
        this.recordReader = new MockRecordParser();
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("sport", RecordFieldType.RECORD);
        this.recordReader.addRecord(new Object[]{"John Doe", 48, null});
        this.runner.addControllerService("reader", (ControllerService)this.recordReader);
        this.runner.enableControllerService((ControllerService)this.recordReader);
        this.runner.setProperty("lookup", "/name");
        this.runner.setProperty(LookupRecord.RESULT_RECORD_PATH, "/sport");
        this.runner.setProperty(LookupRecord.RESULT_CONTENTS, LookupRecord.RESULT_RECORD_FIELDS);
        this.runner.enqueue("");
        this.runner.run();
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        String outputContents = new String(out.toByteArray());
        Assertions.assertTrue((outputContents.equals("John Doe,48,MapRecord[{favorite=basketball, least=soccer}]\n") || outputContents.equals("John Doe,48,MapRecord[{least=soccer, favorite=basketball}]\n") ? 1 : 0) != 0);
    }

    @Test
    public void testAddFieldsToNonRecordField() throws InitializationException {
        RecordLookup lookupService = new RecordLookup();
        this.runner.addControllerService("lookup", (ControllerService)lookupService);
        this.runner.enableControllerService((ControllerService)lookupService);
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        fields.add(new RecordField("favorite", RecordFieldType.STRING.getDataType()));
        fields.add(new RecordField("least", RecordFieldType.STRING.getDataType()));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        MapRecord sports = new MapRecord((RecordSchema)schema, new HashMap());
        sports.setValue("favorite", (Object)"basketball");
        sports.setValue("least", (Object)"soccer");
        lookupService.addValue("John Doe", (Record)sports);
        this.recordReader = new MockRecordParser();
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("sport", RecordFieldType.STRING);
        this.recordReader.addRecord(new Object[]{"John Doe", 48, null});
        this.runner.addControllerService("reader", (ControllerService)this.recordReader);
        this.runner.enableControllerService((ControllerService)this.recordReader);
        this.runner.setProperty("lookup", "/name");
        this.runner.setProperty(LookupRecord.RESULT_RECORD_PATH, "/sport");
        this.runner.setProperty(LookupRecord.RESULT_CONTENTS, LookupRecord.RESULT_RECORD_FIELDS);
        this.runner.enqueue("");
        this.runner.run();
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        String outputContents = new String(out.toByteArray());
        Assertions.assertTrue((outputContents.equals("John Doe,48,MapRecord[{favorite=basketball, least=soccer}]\n") || outputContents.equals("John Doe,48,MapRecord[{least=soccer, favorite=basketball}]\n") ? 1 : 0) != 0);
    }

    @Test
    public void testAddFieldsToExistingRecordRouteToSuccess() throws InitializationException {
        RecordLookup lookupService = new RecordLookup();
        this.runner.addControllerService("lookup", (ControllerService)lookupService);
        this.runner.enableControllerService((ControllerService)lookupService);
        this.runner.setProperty(LookupRecord.ROUTING_STRATEGY, LookupRecord.ROUTE_TO_SUCCESS);
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        fields.add(new RecordField("favorite", RecordFieldType.STRING.getDataType(), false));
        fields.add(new RecordField("least", RecordFieldType.STRING.getDataType(), true));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        MapRecord sports = new MapRecord((RecordSchema)schema, new HashMap());
        sports.setValue("favorite", (Object)"basketball");
        sports.setValue("least", (Object)"soccer");
        lookupService.addValue("John Doe", (Record)sports);
        this.recordReader = new MockRecordParser();
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addRecord(new Object[]{"John Doe", 48});
        this.recordReader.addRecord(new Object[]{"Jane Doe", 47});
        this.runner.addControllerService("reader", (ControllerService)this.recordReader);
        this.runner.enableControllerService((ControllerService)this.recordReader);
        this.runner.setProperty("lookup", "/name");
        this.runner.setProperty(LookupRecord.RESULT_RECORD_PATH, "/");
        this.runner.setProperty(LookupRecord.RESULT_CONTENTS, LookupRecord.RESULT_RECORD_FIELDS);
        this.runner.enqueue("");
        this.runner.run();
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(LookupRecord.REL_SUCCESS).get(0);
        out.assertContentEquals("John Doe,48,soccer,basketball\nJane Doe,47\n");
    }

    @Test
    public void testLookupArray() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(LookupRecord.class);
        MapLookupForInPlaceReplacement lookupService = new MapLookupForInPlaceReplacement();
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.INHERIT_RECORD_SCHEMA);
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.enableControllerService((ControllerService)jsonReader);
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.enableControllerService((ControllerService)jsonWriter);
        runner.addControllerService("lookup", (ControllerService)lookupService);
        runner.enableControllerService((ControllerService)lookupService);
        runner.setProperty(LookupRecord.ROUTING_STRATEGY, LookupRecord.ROUTE_TO_SUCCESS);
        runner.setProperty(LookupRecord.REPLACEMENT_STRATEGY, LookupRecord.REPLACE_EXISTING_VALUES);
        runner.setProperty(LookupRecord.RECORD_READER, "reader");
        runner.setProperty(LookupRecord.RECORD_WRITER, "writer");
        runner.setProperty(LookupRecord.LOOKUP_SERVICE, "lookup");
        runner.setProperty("lookupLanguage", "/locales[*]/language");
        runner.setProperty("lookupRegion", "/locales[*]/region");
        runner.setProperty("lookupFoo", "/foo/foo");
        lookupService.addValue("FR", "France");
        lookupService.addValue("CA", "Canada");
        lookupService.addValue("fr", "French");
        lookupService.addValue("key", "value");
        runner.enqueue(new File("src/test/resources/TestLookupRecord/lookup-array-input.json").toPath());
        runner.run();
        runner.assertAllFlowFilesTransferred(LookupRecord.REL_SUCCESS);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(LookupRecord.REL_SUCCESS).get(0);
        out.assertContentEquals(new File("src/test/resources/TestLookupRecord/lookup-array-output.json").toPath());
    }

    @Test
    public void testLookupEmptyArray() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(LookupRecord.class);
        MapLookupForInPlaceReplacement lookupService = new MapLookupForInPlaceReplacement();
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.INHERIT_RECORD_SCHEMA);
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.enableControllerService((ControllerService)jsonReader);
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.enableControllerService((ControllerService)jsonWriter);
        runner.addControllerService("lookup", (ControllerService)lookupService);
        runner.enableControllerService((ControllerService)lookupService);
        runner.setProperty(LookupRecord.ROUTING_STRATEGY, LookupRecord.ROUTE_TO_SUCCESS);
        runner.setProperty(LookupRecord.REPLACEMENT_STRATEGY, LookupRecord.REPLACE_EXISTING_VALUES);
        runner.setProperty(LookupRecord.RECORD_READER, "reader");
        runner.setProperty(LookupRecord.RECORD_WRITER, "writer");
        runner.setProperty(LookupRecord.LOOKUP_SERVICE, "lookup");
        runner.setProperty("lookupLanguage", "/locales[*]/language");
        runner.setProperty("lookupRegion", "/locales[*]/region");
        runner.setProperty("lookupCurrency", "/currencies[*]/currency");
        runner.setProperty("lookupFoo", "/foo/foo");
        runner.setProperty("lookupBar", "/bar");
        lookupService.addValue("CA", "Canada");
        lookupService.addValue("CAD", "Canadian dollar");
        lookupService.addValue("en", "English");
        lookupService.addValue("EUR", "Euro");
        lookupService.addValue("ja", "Japanese");
        lookupService.addValue("JP", "Japan");
        lookupService.addValue("JPY", "Japanese yen");
        lookupService.addValue("US", "United States");
        lookupService.addValue("USD", "United States Dollar");
        lookupService.addValue("fr", "French");
        lookupService.addValue("FR", "France");
        lookupService.addValue("original", "updated");
        lookupService.addValue("orgValue", "newValue");
        lookupService.addValue("orgValue2", "newValue2");
        runner.enqueue(new File("src/test/resources/TestLookupRecord/lookup-array-input-empty-array.json").toPath());
        runner.run();
        runner.assertAllFlowFilesTransferred(LookupRecord.REL_SUCCESS);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(LookupRecord.REL_SUCCESS).get(0);
        out.assertContentEquals(new File("src/test/resources/TestLookupRecord/lookup-array-output-empty-array.json").toPath());
    }

    @Test
    public void testLookupMissingJsonField() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(LookupRecord.class);
        MapLookupForInPlaceReplacement lookupService = new MapLookupForInPlaceReplacement();
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.INHERIT_RECORD_SCHEMA);
        runner.setProperty((ControllerService)jsonWriter, JsonRecordSetWriter.SUPPRESS_NULLS, JsonRecordSetWriter.ALWAYS_SUPPRESS);
        runner.enableControllerService((ControllerService)jsonReader);
        runner.enableControllerService((ControllerService)jsonWriter);
        runner.addControllerService("lookup", (ControllerService)lookupService);
        runner.enableControllerService((ControllerService)lookupService);
        runner.setProperty(LookupRecord.ROUTING_STRATEGY, LookupRecord.ROUTE_TO_MATCHED_UNMATCHED);
        runner.setProperty(LookupRecord.REPLACEMENT_STRATEGY, LookupRecord.REPLACE_EXISTING_VALUES);
        runner.setProperty(LookupRecord.RECORD_READER, "reader");
        runner.setProperty(LookupRecord.RECORD_WRITER, "writer");
        runner.setProperty(LookupRecord.LOOKUP_SERVICE, "lookup");
        runner.setProperty("lookupFoo", "/foo/foo");
        lookupService.addValue("original", "updated");
        runner.enqueue(new File("src/test/resources/TestLookupRecord/lookup-array-input-missing.json").toPath());
        runner.run();
        runner.assertTransferCount(LookupRecord.REL_UNMATCHED, 1);
        MockFlowFile outUnmatched = (MockFlowFile)runner.getFlowFilesForRelationship(LookupRecord.REL_UNMATCHED).get(0);
        outUnmatched.assertContentEquals(new File("src/test/resources/TestLookupRecord/lookup-array-output-missing-unmatched.json").toPath());
        runner.assertTransferCount(LookupRecord.REL_MATCHED, 1);
        MockFlowFile outMatched = (MockFlowFile)runner.getFlowFilesForRelationship(LookupRecord.REL_MATCHED).get(0);
        outMatched.assertContentEquals(new File("src/test/resources/TestLookupRecord/lookup-array-output-missing-matched.json").toPath());
    }

    @Test
    public void testLookupArrayKeyNotInLRS() throws InitializationException, IOException {
        TestRunner runner = TestRunners.newTestRunner(LookupRecord.class);
        MapLookupForInPlaceReplacement lookupService = new MapLookupForInPlaceReplacement();
        JsonTreeReader jsonReader = new JsonTreeReader();
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.INHERIT_RECORD_SCHEMA);
        runner.addControllerService("reader", (ControllerService)jsonReader);
        runner.enableControllerService((ControllerService)jsonReader);
        runner.addControllerService("writer", (ControllerService)jsonWriter);
        runner.enableControllerService((ControllerService)jsonWriter);
        runner.addControllerService("lookup", (ControllerService)lookupService);
        runner.enableControllerService((ControllerService)lookupService);
        runner.setProperty(LookupRecord.ROUTING_STRATEGY, LookupRecord.ROUTE_TO_MATCHED_UNMATCHED);
        runner.setProperty(LookupRecord.REPLACEMENT_STRATEGY, LookupRecord.REPLACE_EXISTING_VALUES);
        runner.setProperty(LookupRecord.RECORD_READER, "reader");
        runner.setProperty(LookupRecord.RECORD_WRITER, "writer");
        runner.setProperty(LookupRecord.LOOKUP_SERVICE, "lookup");
        runner.setProperty("lookupLanguage", "/locales[*]/language");
        runner.setProperty("lookupRegion", "/locales[*]/region");
        runner.setProperty("lookupFoo", "/foo/foo");
        lookupService.addValue("FR", "France");
        lookupService.addValue("fr", "French");
        lookupService.addValue("badkey", "value");
        runner.enqueue(new File("src/test/resources/TestLookupRecord/lookup-array-input-unmatched.json").toPath());
        runner.run();
        runner.assertAllFlowFilesTransferred(LookupRecord.REL_UNMATCHED);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(LookupRecord.REL_UNMATCHED).get(0);
        System.out.println(out.getContent());
        out.assertContentEquals(new File("src/test/resources/TestLookupRecord/lookup-array-output-unmatched.json").toPath());
    }

    @Test
    public void testLiteralCoordinate() {
        this.lookupService.addValue("lookupKey", "lookupValue");
        this.runner.setProperty("lookup", "toString('lookupKey', 'UTF-8')");
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(LookupRecord.REL_MATCHED, 1);
    }

    private static class MapLookupForInPlaceReplacement
    extends MapLookup
    implements StringLookupService {
        private MapLookupForInPlaceReplacement() {
        }

        @Override
        public Optional<String> lookup(Map<String, Object> coordinates) {
            String key = (String)coordinates.values().iterator().next();
            if (key == null) {
                return Optional.empty();
            }
            return Optional.ofNullable((String)this.values.get(key));
        }
    }

    private static class RecordLookup
    extends AbstractControllerService
    implements RecordLookupService {
        private final Map<String, Record> values = new HashMap<String, Record>();

        private RecordLookup() {
        }

        public void addValue(String key, Record value) {
            this.values.put(key, value);
        }

        public Class<?> getValueType() {
            return String.class;
        }

        public Optional<Record> lookup(Map<String, Object> coordinates) {
            if (coordinates == null || coordinates.get("lookup") == null) {
                return Optional.empty();
            }
            String key = (String)coordinates.get("lookup");
            if (key == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.values.get(key));
        }

        public Set<String> getRequiredKeys() {
            return Collections.singleton("lookup");
        }
    }

    private static class MapLookup
    extends AbstractControllerService
    implements StringLookupService {
        protected final Map<String, String> values = new HashMap<String, String>();
        private Map<String, Object> expectedContext;

        private MapLookup() {
        }

        public void addValue(String key, String value) {
            this.values.put(key, value);
        }

        public Class<?> getValueType() {
            return String.class;
        }

        public Optional<String> lookup(Map<String, Object> coordinates, Map<String, String> context) {
            this.validateContext(context);
            return this.lookup(coordinates);
        }

        public Optional<String> lookup(Map<String, Object> coordinates) {
            String key;
            if (coordinates == null || coordinates.get("lookup") == null) {
                return Optional.empty();
            }
            String string = key = coordinates.containsKey("lookup") ? coordinates.get("lookup").toString() : null;
            if (key == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.values.get(key));
        }

        public Set<String> getRequiredKeys() {
            return Collections.singleton("lookup");
        }

        public void setExpectedContext(Map<String, Object> expectedContext) {
            this.expectedContext = expectedContext;
        }

        private void validateContext(Map<String, String> context) {
            if (this.expectedContext != null) {
                for (Map.Entry<String, Object> entry : this.expectedContext.entrySet()) {
                    Assertions.assertTrue((boolean)context.containsKey(entry.getKey()), (String)String.format("%s was not in coordinates.", entry.getKey()));
                    Assertions.assertEquals((Object)entry.getValue(), (Object)context.get(entry.getKey()), (String)"Wrong value");
                }
            }
        }
    }
}

