/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processors.standard.FetchFTP;
import org.apache.nifi.processors.standard.FetchFileTransfer;
import org.apache.nifi.processors.standard.ListFTP;
import org.apache.nifi.processors.standard.ListFileTransfer;
import org.apache.nifi.processors.standard.PutFTP;
import org.apache.nifi.processors.standard.PutFileTransfer;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class FTPCharsetIT {
    private static final String SERVER_OVERRIDE = System.getProperty(FTPCharsetIT.class.getSimpleName());
    private static final boolean EMBED_FTP_SERVER = SERVER_OVERRIDE == null;
    private static FtpServer FTP_SERVER;
    private static final String USE_UTF8;
    private static final String USER = "ftpuser";
    private static final String PASSWORD = "admin";
    private static final String TIMEOUT = "3 secs";
    @TempDir
    private static File FOLDER_FTP;
    @TempDir
    private static File FOLDER_USER_PROPERTIES;
    private static int listeningPort;

    public static Stream<Arguments> folderNamesProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"folder1", "folder2"}), Arguments.arguments((Object[])new Object[]{"folder2", "\u00e6\u00f8\u00e5"}), Arguments.arguments((Object[])new Object[]{"\u00e6\u00f8\u00e5", "folder3"}), Arguments.arguments((Object[])new Object[]{"folder3", "\u0627\u062e\u062a\u0628\u0627\u0631"}), Arguments.arguments((Object[])new Object[]{"\u0627\u062e\u062a\u0628\u0627\u0631", "folder4"}), Arguments.arguments((Object[])new Object[]{"folder4", "\u0413\u043e\u0441\u0430\u0433\u0457z\u0430\u0442\u0457\u043e\u0439"}), Arguments.arguments((Object[])new Object[]{"\u0413\u043e\u0441\u0430\u0433\u0457z\u0430\u0442\u0457\u043e\u0439", "folder5"}), Arguments.arguments((Object[])new Object[]{"folder5", "\u3057\u56de\u4ea1\u4e39\u3057\u5de5z\u4e39\u535e\u5de5\u56de\u51e0"}), Arguments.arguments((Object[])new Object[]{"\u3057\u56de\u4ea1\u4e39\u3057\u5de5z\u4e39\u535e\u5de5\u56de\u51e0", "folder6"}));
    }

    public static Stream<String> filenamesProvider() {
        return Stream.of("1.txt", "\u00e6\u00f8\u00e5.txt", "\u0627\u062e\u062a\u0628\u0627\u0631.txt", "\u0413\u043e\u0441\u0430\u0433\u0457z\u0430\u0442\u0457\u043e\u0439.txt", "\u3057\u56de\u4ea1\u4e39\u3057\u5de5z\u4e39\u535e\u5de5\u56de\u51e0.txt");
    }

    @BeforeAll
    static void startEmbeddedServer() throws IOException, FtpException {
        if (!EMBED_FTP_SERVER) {
            return;
        }
        Properties userProperties = new Properties();
        userProperties.setProperty("ftpserver.user.ftpuser.idletime", "0");
        userProperties.setProperty("ftpserver.user.ftpuser.enableflag", Boolean.TRUE.toString());
        userProperties.setProperty("ftpserver.user.ftpuser.userpassword", PASSWORD);
        userProperties.setProperty("ftpserver.user.ftpuser.writepermission", Boolean.TRUE.toString());
        userProperties.setProperty("ftpserver.user.ftpuser.homedirectory", FOLDER_FTP.getAbsolutePath());
        File userPropertiesFile = new File(FOLDER_USER_PROPERTIES, "user.properties");
        try (FileOutputStream fos = new FileOutputStream(userPropertiesFile);){
            userProperties.store(fos, "ftp-user-properties");
        }
        PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
        userManagerFactory.setUrl(userPropertiesFile.toURI().toURL());
        userManagerFactory.setPasswordEncryptor((PasswordEncryptor)new ClearTextPasswordEncryptor());
        UserManager userManager = userManagerFactory.createUserManager();
        BaseUser ftpuser = (BaseUser)userManager.getUserByName(USER);
        FtpServerFactory serverFactory = new FtpServerFactory();
        serverFactory.setUserManager(userManager);
        FileSystemFactory fileSystemFactory = serverFactory.getFileSystem();
        FileSystemView view = fileSystemFactory.createFileSystemView((User)ftpuser);
        FtpFile workingDirectory = view.getWorkingDirectory();
        Object physicalFile = workingDirectory.getPhysicalFile();
        Assertions.assertInstanceOf(File.class, (Object)physicalFile);
        Assertions.assertEquals((Object)FOLDER_FTP.getAbsolutePath(), (Object)((File)physicalFile).getAbsolutePath());
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(0);
        serverFactory.addListener("default", factory.createListener());
        FTP_SERVER = serverFactory.createServer();
        FTP_SERVER.start();
        Collection listeners = serverFactory.getListeners().values();
        listeningPort = listeners.isEmpty() ? 0 : ((Listener)listeners.iterator().next()).getPort();
    }

    @AfterAll
    static void stopEmbeddedServer() {
        if (EMBED_FTP_SERVER) {
            FTP_SERVER.stop();
        }
    }

    @Test
    public void test0SeedFTPPut1() {
        TestRunner runnerPut = FTPCharsetIT.provisionTestRunner(PutFTP.class);
        String folderName = "folder0";
        MockFlowFile flowFile = new MockFlowFile(1L);
        flowFile.putAttributes(Collections.singletonMap(CoreAttributes.FILENAME.key(), "0.txt"));
        flowFile.setData(new Date().toString().getBytes(StandardCharsets.UTF_8));
        runnerPut.enqueue(new FlowFile[]{flowFile});
        runnerPut.setValidateExpressionUsage(false);
        runnerPut.setProperty(FTPTransfer.REMOTE_PATH, "folder0");
        runnerPut.setProperty(FTPTransfer.CREATE_DIRECTORY, Boolean.TRUE.toString());
        runnerPut.setProperty(FTPTransfer.DOT_RENAME, Boolean.FALSE.toString());
        runnerPut.run();
        runnerPut.assertTransferCount(PutFileTransfer.REL_FAILURE, 0);
        runnerPut.assertTransferCount(PutFileTransfer.REL_REJECT, 0);
        runnerPut.assertTransferCount(PutFileTransfer.REL_SUCCESS, 1);
    }

    @Test
    public void test0SeedFTPPutAll() {
        int id = 0;
        Object[] argumentsFirstFolder = ((Arguments)FTPCharsetIT.folderNamesProvider().iterator().next()).get();
        String folderName = Arrays.stream(argumentsFirstFolder).iterator().next().toString();
        TestRunner runnerPut = FTPCharsetIT.provisionTestRunner(PutFTP.class);
        runnerPut.setValidateExpressionUsage(false);
        runnerPut.setProperty(FTPTransfer.REMOTE_PATH, folderName);
        runnerPut.setProperty(FTPTransfer.CREATE_DIRECTORY, Boolean.TRUE.toString());
        runnerPut.setProperty(FTPTransfer.DOT_RENAME, Boolean.FALSE.toString());
        Iterator iteratorFilenames = FTPCharsetIT.filenamesProvider().iterator();
        while (iteratorFilenames.hasNext()) {
            String filename = (String)iteratorFilenames.next();
            MockFlowFile flowFile = new MockFlowFile((long)(++id));
            flowFile.putAttributes(Collections.singletonMap(CoreAttributes.FILENAME.key(), filename));
            flowFile.setData(new Date().toString().getBytes(StandardCharsets.UTF_8));
            runnerPut.enqueue(new FlowFile[]{flowFile});
        }
        int fileCount = (int)FTPCharsetIT.filenamesProvider().count();
        runnerPut.run();
        runnerPut.assertTransferCount(PutFileTransfer.REL_FAILURE, 0);
        runnerPut.assertTransferCount(PutFileTransfer.REL_REJECT, 0);
        runnerPut.assertTransferCount(PutFileTransfer.REL_SUCCESS, fileCount);
    }

    @Test
    public void test9FTPVerifyAll() {
        Set filenamesExpected = FTPCharsetIT.filenamesProvider().collect(Collectors.toSet());
        Object[] argumentsLastFolder = FTPCharsetIT.folderNamesProvider().reduce((prev, next) -> next).orElseThrow(IllegalStateException::new).get();
        String folderName = Arrays.stream(argumentsLastFolder).reduce((prev, next) -> next).orElseThrow(IllegalStateException::new).toString();
        TestRunner runnerList = FTPCharsetIT.provisionTestRunner(ListFTP.class);
        runnerList.setProperty(ListFileTransfer.FILE_TRANSFER_LISTING_STRATEGY, AbstractListProcessor.NO_TRACKING);
        runnerList.setProperty(FTPTransfer.REMOTE_PATH, folderName);
        runnerList.clearTransferState();
        runnerList.run(1);
        runnerList.assertTransferCount(AbstractListProcessor.REL_SUCCESS, filenamesExpected.size());
        List flowFilesList = runnerList.getFlowFilesForRelationship(AbstractListProcessor.REL_SUCCESS);
        for (MockFlowFile flowFile : flowFilesList) {
            filenamesExpected.remove(flowFile.getAttribute(CoreAttributes.FILENAME.key()));
        }
        Assertions.assertTrue((boolean)filenamesExpected.isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"folderNamesProvider"})
    public void test1FTP(String source, String target) {
        int fileCount = (int)FTPCharsetIT.filenamesProvider().count();
        TestRunner runnerList = FTPCharsetIT.provisionTestRunner(ListFTP.class);
        runnerList.setProperty(ListFileTransfer.FILE_TRANSFER_LISTING_STRATEGY, AbstractListProcessor.NO_TRACKING);
        runnerList.setProperty(FTPTransfer.REMOTE_PATH, source);
        runnerList.clearTransferState();
        runnerList.run(1);
        runnerList.assertTransferCount(AbstractListProcessor.REL_SUCCESS, fileCount);
        List flowFilesList = runnerList.getFlowFilesForRelationship(AbstractListProcessor.REL_SUCCESS);
        TestRunner runnerFetch = FTPCharsetIT.provisionTestRunner(FetchFTP.class);
        for (MockFlowFile flowFile : flowFilesList) {
            runnerFetch.enqueue(new FlowFile[]{flowFile});
        }
        runnerFetch.setProperty(FetchFTP.REMOTE_FILENAME, "${path}/${filename}");
        runnerFetch.run(flowFilesList.size());
        runnerFetch.assertTransferCount(FetchFTP.REL_COMMS_FAILURE, 0);
        runnerFetch.assertTransferCount(FetchFTP.REL_NOT_FOUND, 0);
        runnerFetch.assertTransferCount(FetchFTP.REL_PERMISSION_DENIED, 0);
        runnerFetch.assertTransferCount(FetchFileTransfer.REL_SUCCESS, fileCount);
        List flowFilesFetch = runnerFetch.getFlowFilesForRelationship(AbstractListProcessor.REL_SUCCESS);
        TestRunner runnerPut = FTPCharsetIT.provisionTestRunner(PutFTP.class);
        for (MockFlowFile flowFile : flowFilesFetch) {
            runnerPut.enqueue(new FlowFile[]{flowFile});
        }
        runnerPut.setValidateExpressionUsage(false);
        runnerPut.setProperty(FTPTransfer.REMOTE_PATH, target);
        runnerPut.setProperty(FTPTransfer.CREATE_DIRECTORY, Boolean.TRUE.toString());
        runnerPut.setProperty(FTPTransfer.DOT_RENAME, Boolean.FALSE.toString());
        runnerPut.run(flowFilesList.size());
        runnerPut.assertTransferCount(PutFileTransfer.REL_FAILURE, 0);
        runnerPut.assertTransferCount(PutFileTransfer.REL_REJECT, 0);
        runnerPut.assertTransferCount(PutFileTransfer.REL_SUCCESS, fileCount);
    }

    private static TestRunner provisionTestRunner(Class<? extends Processor> processorClass) {
        TestRunner runner = TestRunners.newTestRunner(processorClass);
        String valueOverrides = System.getProperty(FTPCharsetIT.class.getSimpleName());
        if (valueOverrides == null) {
            runner.setProperty(FTPTransfer.HOSTNAME, "localhost");
            runner.setProperty(FTPTransfer.PORT, String.valueOf(listeningPort));
            runner.setProperty(FTPTransfer.USERNAME, USER);
            runner.setProperty(FTPTransfer.PASSWORD, PASSWORD);
        } else {
            String[] serverParameters = valueOverrides.split(",");
            runner.setProperty(FTPTransfer.HOSTNAME, serverParameters[0]);
            runner.setProperty(FTPTransfer.PORT, serverParameters[1]);
            runner.setProperty(FTPTransfer.USERNAME, serverParameters[2]);
            runner.setProperty(FTPTransfer.PASSWORD, serverParameters[3]);
        }
        runner.setProperty(FTPTransfer.UTF8_ENCODING, USE_UTF8);
        runner.setProperty(FTPTransfer.CONNECTION_TIMEOUT, TIMEOUT);
        runner.setProperty(FTPTransfer.DATA_TIMEOUT, TIMEOUT);
        return runner;
    }

    static {
        USE_UTF8 = Boolean.TRUE.toString();
    }
}

