/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.enrichment.IndexCorrelatedJoinStrategy;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

public class InsertRecordFieldsJoinStrategy
extends IndexCorrelatedJoinStrategy {
    private static final RecordPathCache recordPathCache = new RecordPathCache(100);
    private final RecordPath recordPath;

    public InsertRecordFieldsJoinStrategy(ComponentLog logger, String insertionRecordPath) {
        super(logger);
        this.recordPath = recordPathCache.getCompiled(insertionRecordPath);
    }

    @Override
    protected Record combineRecords(Record originalRecord, Record enrichmentRecord, RecordSchema resultSchema) {
        return this.combineRecords(originalRecord, enrichmentRecord, false);
    }

    private Record combineRecords(Record originalRecord, Record enrichmentRecord, boolean incorporateEnrichmentSchema) {
        if (originalRecord == null) {
            return null;
        }
        if (enrichmentRecord == null) {
            return originalRecord;
        }
        RecordPathResult result = this.recordPath.evaluate(originalRecord);
        List fieldValues = result.getSelectedFields().collect(Collectors.toList());
        for (FieldValue fieldValue : fieldValues) {
            Object value = fieldValue.getValue();
            if (!(value instanceof Record)) {
                this.getLogger().debug("Did not find a Record after evaluating RecordPath {} but found {} instead", new Object[]{this.recordPath.getPath(), value});
                continue;
            }
            Record parentRecord = (Record)value;
            if (incorporateEnrichmentSchema) {
                parentRecord.incorporateSchema(enrichmentRecord.getSchema());
            }
            enrichmentRecord.toMap().forEach((arg_0, arg_1) -> ((Record)parentRecord).setValue(arg_0, arg_1));
            parentRecord.incorporateInactiveFields();
        }
        return originalRecord;
    }

    @Override
    protected RecordSchema createResultSchema(Record firstOriginalRecord, Record firstEnrichmentRecord) {
        Record combined = this.combineRecords(firstOriginalRecord, firstEnrichmentRecord, true);
        combined.incorporateInactiveFields();
        return combined.getSchema();
    }
}

