/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.calcite;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.ResultSetRecordSet;

public class RecordResultSetOutputStreamCallback
implements OutputStreamCallback {
    private final ComponentLog logger;
    private final ResultSet rs;
    private final RecordSchema writerSchema;
    private final Integer defaultPrecision;
    private final Integer defaultScale;
    private final RecordSetWriterFactory recordSetWriterFactory;
    private final Map<String, String> originalAttributes;
    private WriteResult writeResult;
    private String mimeType;

    public RecordResultSetOutputStreamCallback(ComponentLog logger, ResultSet rs, RecordSchema writerSchema, Integer defaultPrecision, Integer defaultScale, RecordSetWriterFactory recordSetWriterFactory, Map<String, String> originalAttributes) {
        this.logger = logger;
        this.rs = rs;
        this.writerSchema = writerSchema;
        this.defaultPrecision = defaultPrecision;
        this.defaultScale = defaultScale;
        this.recordSetWriterFactory = recordSetWriterFactory;
        this.originalAttributes = originalAttributes;
    }

    public WriteResult getWriteResult() throws ProcessException {
        return (WriteResult)ObjectUtils.defaultIfNull((Object)this.writeResult, (Object)WriteResult.EMPTY);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void process(OutputStream out) throws IOException {
        try (ResultSetRecordSet recordSet = new ResultSetRecordSet(this.rs, this.writerSchema, this.defaultPrecision.intValue(), this.defaultScale.intValue());){
            RecordSchema resultSetSchema = recordSet.getSchema();
            RecordSchema writeSchema = this.recordSetWriterFactory.getSchema(this.originalAttributes, resultSetSchema);
            try (RecordSetWriter resultSetWriter = this.recordSetWriterFactory.createWriter(this.logger, writeSchema, out, this.originalAttributes);){
                this.writeResult = resultSetWriter.write((RecordSet)recordSet);
                this.mimeType = resultSetWriter.getMimeType();
            }
            catch (Exception e) {
                throw new IOException("Writing result records failed", e);
            }
        }
        catch (SQLException | SchemaNotFoundException e) {
            throw new ProcessException("Reading query result records failed", e);
        }
    }
}

