/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.json.schema.JsonSchema;
import org.apache.nifi.json.schema.SchemaVersion;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.ValidateJson;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.JsonSchemaRegistryComponent;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.JsonSchemaRegistry;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

class TestValidateJson {
    private static final String JSON = TestValidateJson.getFileContent("simple-example.json");
    private static final String SIMPLE_SCHEMA = TestValidateJson.getFileContent("schema-simple-example.json");
    private static final String NON_JSON = "Not JSON";
    private static final String SCHEMA_VERSION = SchemaVersion.DRAFT_7.getValue();
    private TestRunner runner;

    TestValidateJson() {
    }

    @BeforeEach
    public void setUp() {
        this.runner = TestRunners.newTestRunner(ValidateJson.class);
    }

    @ParameterizedTest(name="{2}")
    @MethodSource(value={"customValidateArgs"})
    void testCustomValidateMissingProperty(String strategy) {
        this.runner.setProperty(ValidateJson.SCHEMA_ACCESS_STRATEGY, strategy);
        this.runner.enqueue(JSON);
        Assertions.assertThrows(AssertionFailedError.class, () -> ((TestRunner)this.runner).run());
    }

    @Test
    void testPassSchema() {
        String schemaPath = TestValidateJson.getFilePath("schema-simple-example.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schemaPath);
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
        Assertions.assertEquals((int)1, (int)this.runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.ROUTE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    void testNoSchemaVersionSpecified() {
        String schemaPath = TestValidateJson.getFilePath("schema-simple-example.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schemaPath);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
        Assertions.assertEquals((int)1, (int)this.runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.ROUTE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    void testEmptySchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, "{}");
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
        Assertions.assertEquals((int)1, (int)this.runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.ROUTE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    void testAllUnknownKeywordsSchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, "{\"fruit\": \"Apple\", \"size\": \"Large\", \"color\": \"Red\"}");
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
        Assertions.assertEquals((int)1, (int)this.runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.ROUTE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    void testPatternSchemaCheck() {
        String schemaPath = TestValidateJson.getFilePath("schema-simple-example-unmatched-pattern.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schemaPath);
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 0);
        this.assertValidationErrors(ValidateJson.REL_INVALID, true);
        Assertions.assertEquals((int)1, (int)this.runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.ROUTE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    void testMissingRequiredValue() {
        String schema = TestValidateJson.getFileContent("schema-simple-example-missing-required.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schema);
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 1);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 0);
        this.assertValidationErrors(ValidateJson.REL_INVALID, true);
        Assertions.assertEquals((int)1, (int)this.runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.ROUTE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    void testInvalidJson() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, SIMPLE_SCHEMA);
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(NON_JSON);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 1);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 0);
        this.assertValidationErrors(ValidateJson.REL_FAILURE, false);
        Assertions.assertEquals((int)1, (int)this.runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.ROUTE, (Object)((ProvenanceEventRecord)this.runner.getProvenanceEvents().get(0)).getEventType());
    }

    @Test
    void testNonExistingSchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, "not-found.json");
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        Assertions.assertThrows(AssertionFailedError.class, () -> this.runner.run());
    }

    @Test
    void testBadSchema() {
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, NON_JSON);
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(JSON);
        Assertions.assertThrows(AssertionFailedError.class, () -> this.runner.run());
    }

    @Test
    void testJsonWithComments() {
        String schemaPath = TestValidateJson.getFilePath("schema-simple-example.json");
        this.runner.setProperty(ValidateJson.SCHEMA_CONTENT, schemaPath);
        this.runner.setProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION, SCHEMA_VERSION);
        this.runner.enqueue(TestValidateJson.getFileContent("simple-example-with-comments.json"));
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
        this.assertValidationErrors(ValidateJson.REL_VALID, false);
    }

    @Test
    void testSchemaRetrievalFromRegistry() throws InitializationException {
        String registryIdentifier = "registry";
        String schemaName = "someSchema";
        SampleJsonSchemaRegistry validJsonSchemaRegistry = new SampleJsonSchemaRegistry("registry", "someSchema");
        this.runner.addControllerService("registry", (ControllerService)validJsonSchemaRegistry);
        this.runner.enableControllerService((ControllerService)validJsonSchemaRegistry);
        this.runner.assertValid((ControllerService)validJsonSchemaRegistry);
        this.runner.setProperty(ValidateJson.SCHEMA_ACCESS_STRATEGY, ValidateJson.JsonSchemaStrategy.SCHEMA_NAME_PROPERTY.getValue());
        this.runner.setProperty(ValidateJson.SCHEMA_REGISTRY, "registry");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("schema.name", "someSchema");
        this.runner.enqueue(JSON, attributes);
        this.runner.run();
        this.runner.assertTransferCount(ValidateJson.REL_FAILURE, 0);
        this.runner.assertTransferCount(ValidateJson.REL_INVALID, 0);
        this.runner.assertTransferCount(ValidateJson.REL_VALID, 1);
    }

    private void assertValidationErrors(Relationship relationship, boolean expected) {
        Map attributes = ((MockFlowFile)this.runner.getFlowFilesForRelationship(relationship).get(0)).getAttributes();
        if (expected) {
            Assertions.assertFalse((boolean)((String)attributes.get("json.validation.errors")).isEmpty());
        } else {
            Assertions.assertNull(attributes.get("json.validation.errors"));
        }
    }

    private static Stream<Arguments> customValidateArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{ValidateJson.JsonSchemaStrategy.SCHEMA_NAME_PROPERTY.getValue(), "requires that the JSON Schema Registry property be set"}), Arguments.of((Object[])new Object[]{ValidateJson.JsonSchemaStrategy.SCHEMA_CONTENT_PROPERTY.getValue(), "requires that the JSON Schema property be set"}));
    }

    private static String getFilePath(String filename) {
        String path = TestValidateJson.getRelativeResourcePath(filename);
        URL url = Objects.requireNonNull(TestValidateJson.class.getResource(path), "Resource not found");
        return url.getPath();
    }

    private static String getFileContent(String filename) {
        String string;
        block8: {
            String path = TestValidateJson.getRelativeResourcePath(filename);
            InputStream inputStream = TestValidateJson.class.getResourceAsStream(path);
            try {
                Objects.requireNonNull(inputStream, "Resource not found");
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static String getRelativeResourcePath(String filename) {
        return String.format("/%s/%s", TestValidateJson.class.getSimpleName(), filename);
    }

    private static class SampleJsonSchemaRegistry
    extends AbstractControllerService
    implements JsonSchemaRegistry {
        private final String identifier;
        private final String schemaName;

        public SampleJsonSchemaRegistry(String identifier, String schemaName) {
            this.identifier = identifier;
            this.schemaName = schemaName;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public JsonSchema retrieveSchema(String schemaName) throws SchemaNotFoundException {
            if (this.schemaName.equals(schemaName)) {
                return new JsonSchema(SchemaVersion.DRAFT_2020_12, "{}");
            }
            throw new SchemaNotFoundException("");
        }
    }
}

