/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.standard.PutSFTP;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.processors.standard.util.SSHTestServer;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestPutSFTP {
    private static final String FLOW_FILE_CONTENTS = TestPutSFTP.class.getSimpleName();
    private static final String LOCALHOST = "localhost";
    private static final String REMOTE_DIRECTORY = "nifi_test/";
    private static final String FIRST_FILENAME = "1.txt";
    private static final int BATCH_SIZE = 2;
    private static final byte[] ZERO_BYTES = new byte[0];
    private static final String TRANSIT_URI_FORMAT = "sftp://%s";
    private SSHTestServer sshTestServer;
    private TestRunner runner;

    TestPutSFTP() {
    }

    @BeforeEach
    void setRunner() throws IOException {
        this.sshTestServer = new SSHTestServer();
        this.sshTestServer.startServer();
        this.runner = TestRunners.newTestRunner(PutSFTP.class);
        this.runner.setProperty(SFTPTransfer.HOSTNAME, LOCALHOST);
        this.runner.setProperty(SFTPTransfer.PORT, Integer.toString(this.sshTestServer.getSSHPort()));
        this.runner.setProperty(SFTPTransfer.USERNAME, this.sshTestServer.getUsername());
        this.runner.setProperty(SFTPTransfer.PASSWORD, this.sshTestServer.getPassword());
        this.runner.setProperty(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT, Boolean.FALSE.toString());
        this.runner.setProperty(SFTPTransfer.STRICT_HOST_KEY_CHECKING, Boolean.FALSE.toString());
        this.runner.setProperty(SFTPTransfer.BATCH_SIZE, Integer.toString(2));
        this.runner.setProperty(SFTPTransfer.REMOTE_PATH, REMOTE_DIRECTORY);
        this.runner.setProperty(SFTPTransfer.REJECT_ZERO_BYTE, Boolean.TRUE.toString());
        this.runner.setProperty(SFTPTransfer.CONFLICT_RESOLUTION, "REPLACE");
        this.runner.setProperty(SFTPTransfer.CREATE_DIRECTORY, Boolean.TRUE.toString());
        this.runner.setProperty(SFTPTransfer.DATA_TIMEOUT, "30 sec");
        this.runner.setValidateExpressionUsage(false);
    }

    @AfterEach
    void clearDirectory() throws IOException {
        this.sshTestServer.stopServer();
        Path fileSystemPath = Paths.get(this.sshTestServer.getVirtualFileSystemPath(), new String[0]);
        FileUtils.deleteQuietly((File)fileSystemPath.toFile());
    }

    @Test
    void testRunNewDirectory() {
        this.runner.enqueue(FLOW_FILE_CONTENTS, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 1);
        Path newDirectory = Paths.get(this.sshTestServer.getVirtualFileSystemPath() + REMOTE_DIRECTORY, new String[0]);
        Path newFile = Paths.get(this.sshTestServer.getVirtualFileSystemPath() + "nifi_test/1.txt", new String[0]);
        Assertions.assertTrue((boolean)newDirectory.toAbsolutePath().toFile().exists(), (String)"New Directory not created");
        Assertions.assertTrue((boolean)newFile.toAbsolutePath().toFile().exists(), (String)"New File not created");
        this.runner.clearTransferState();
    }

    @Test
    void testRunZeroByteFileRejected() {
        this.runner.enqueue(ZERO_BYTES, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_REJECT, 1);
    }

    @Test
    void testRunZeroByteFileAllowed() {
        this.runner.setProperty(SFTPTransfer.REJECT_ZERO_BYTE, Boolean.FALSE.toString());
        this.runner.enqueue(ZERO_BYTES, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 1);
    }

    @Test
    void testRunConflictResolutionReplaceStrategy() throws IOException {
        this.createRemoteFile();
        this.runner.setProperty(SFTPTransfer.CONFLICT_RESOLUTION, "REPLACE");
        this.runner.enqueue(FLOW_FILE_CONTENTS, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 1);
        this.runner.assertTransferCount(PutSFTP.REL_REJECT, 0);
        this.runner.assertTransferCount(PutSFTP.REL_FAILURE, 0);
    }

    @Test
    void testRunConflictResolutionRejectStrategy() throws IOException {
        this.createRemoteFile();
        this.runner.setProperty(SFTPTransfer.CONFLICT_RESOLUTION, "REJECT");
        this.runner.enqueue(FLOW_FILE_CONTENTS, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutSFTP.REL_REJECT, 1);
        this.runner.assertTransferCount(PutSFTP.REL_FAILURE, 0);
    }

    @Test
    void testRunConflictResolutionIgnoreStrategy() throws IOException {
        this.createRemoteFile();
        this.runner.setProperty(SFTPTransfer.CONFLICT_RESOLUTION, "IGNORE");
        this.runner.enqueue(FLOW_FILE_CONTENTS, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 1);
        this.runner.assertTransferCount(PutSFTP.REL_REJECT, 0);
        this.runner.assertTransferCount(PutSFTP.REL_FAILURE, 0);
    }

    @Test
    void testRunConflictResolutionFailStrategy() throws IOException {
        this.createRemoteFile();
        this.runner.setProperty(SFTPTransfer.CONFLICT_RESOLUTION, "FAIL");
        this.runner.enqueue(FLOW_FILE_CONTENTS, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 0);
        this.runner.assertTransferCount(PutSFTP.REL_REJECT, 0);
        this.runner.assertTransferCount(PutSFTP.REL_FAILURE, 1);
    }

    @Test
    void testRunBatching() {
        int files = 4;
        for (int fileNumber = 1; fileNumber <= 4; ++fileNumber) {
            String filename = Integer.toString(fileNumber);
            this.runner.enqueue(FLOW_FILE_CONTENTS, Collections.singletonMap(CoreAttributes.FILENAME.key(), filename));
        }
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 2);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 2);
        this.runner.assertQueueEmpty();
    }

    @Test
    void testRunTransitUri() {
        this.runner.enqueue(FLOW_FILE_CONTENTS, Collections.singletonMap(CoreAttributes.FILENAME.key(), FIRST_FILENAME));
        this.runner.run();
        this.runner.assertTransferCount(PutSFTP.REL_SUCCESS, 1);
        List records = this.runner.getProvenanceEvents();
        Assertions.assertFalse((boolean)records.isEmpty());
        ProvenanceEventRecord record = (ProvenanceEventRecord)records.iterator().next();
        String firstTransitUri = String.format(TRANSIT_URI_FORMAT, LOCALHOST);
        Assertions.assertTrue((boolean)record.getTransitUri().startsWith(firstTransitUri), (String)"Transit URI not found");
    }

    private void createRemoteFile() throws IOException {
        Path directory = Paths.get(this.sshTestServer.getVirtualFileSystemPath() + REMOTE_DIRECTORY, new String[0]);
        Path subDirectory = Paths.get(directory.toString(), FIRST_FILENAME);
        Files.createDirectory(directory, new FileAttribute[0]);
        Files.createFile(subDirectory, new FileAttribute[0]);
    }
}

