/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.processors.standard.PutDistributedMapCache;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPutDistributedMapCache {
    private TestRunner runner;
    private MockCacheClient service;

    @BeforeEach
    public void setup() throws InitializationException {
        this.runner = TestRunners.newTestRunner(PutDistributedMapCache.class);
        this.service = new MockCacheClient();
        this.runner.addControllerService("service", (ControllerService)this.service);
        this.runner.enableControllerService((ControllerService)this.service);
        this.runner.setProperty(PutDistributedMapCache.DISTRIBUTED_CACHE_SERVICE, "service");
    }

    @Test
    public void testNoCacheKey() {
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        this.runner.enqueue(new byte[0]);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_FAILURE, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_FAILURE, 1);
        this.runner.clearTransferState();
    }

    @Test
    public void testSingleFlowFile() throws InitializationException, IOException {
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "1");
        String flowFileContent = "content";
        this.runner.enqueue(flowFileContent.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_SUCCESS, 1);
        byte[] value = (byte[])this.service.get("1", new PutDistributedMapCache.StringSerializer(), new PutDistributedMapCache.CacheValueDeserializer());
        Assertions.assertEquals((Object)flowFileContent, (Object)new String(value, "UTF-8"));
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertAttributeEquals("cached", "true");
        outputFlowFile.assertContentEquals(flowFileContent);
        this.runner.clearTransferState();
    }

    @Test
    public void testNothingToCache() throws InitializationException, IOException {
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "2");
        this.runner.enqueue(new byte[0], props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_FAILURE, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_FAILURE, 1);
    }

    @Test
    public void testMaxCacheEntrySize() throws InitializationException, IOException {
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_IDENTIFIER, "${uuid}");
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_MAX_BYTES, "10 B");
        String flowFileContent = "contentwhichistoobig";
        this.runner.enqueue(flowFileContent.getBytes("UTF-8"));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_FAILURE, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_FAILURE, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDistributedMapCache.REL_FAILURE).get(0);
        outputFlowFile.assertAttributeNotExists("cached");
        outputFlowFile.assertContentEquals(flowFileContent);
        this.runner.clearTransferState();
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_MAX_BYTES, "1 MB");
    }

    @Test
    public void testCacheStrategyReplace() throws InitializationException, IOException {
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        this.runner.setProperty(PutDistributedMapCache.CACHE_UPDATE_STRATEGY, PutDistributedMapCache.CACHE_UPDATE_REPLACE.getValue());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "replaceme");
        String original = "original";
        this.runner.enqueue(original.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_SUCCESS, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertAttributeEquals("cached", "true");
        outputFlowFile.assertContentEquals(original);
        this.runner.clearTransferState();
        byte[] value = (byte[])this.service.get("replaceme", new PutDistributedMapCache.StringSerializer(), new PutDistributedMapCache.CacheValueDeserializer());
        Assertions.assertEquals((Object)original, (Object)new String(value, "UTF-8"));
        String replaced = "replaced";
        this.runner.enqueue(replaced.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_SUCCESS, 1);
        outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertAttributeEquals("cached", "true");
        outputFlowFile.assertContentEquals(replaced);
        this.runner.clearTransferState();
        value = (byte[])this.service.get("replaceme", new PutDistributedMapCache.StringSerializer(), new PutDistributedMapCache.CacheValueDeserializer());
        Assertions.assertEquals((Object)replaced, (Object)new String(value, "UTF-8"));
    }

    @Test
    public void testCacheStrategyKeepOriginal() throws InitializationException, IOException {
        this.runner.setProperty(PutDistributedMapCache.CACHE_ENTRY_IDENTIFIER, "${cacheKeyAttribute}");
        this.runner.setProperty(PutDistributedMapCache.CACHE_UPDATE_STRATEGY, PutDistributedMapCache.CACHE_UPDATE_KEEP_ORIGINAL.getValue());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cacheKeyAttribute", "replaceme");
        String original = "original";
        this.runner.enqueue(original.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_SUCCESS, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_SUCCESS, 1);
        MockFlowFile outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDistributedMapCache.REL_SUCCESS).get(0);
        outputFlowFile.assertAttributeEquals("cached", "true");
        outputFlowFile.assertContentEquals(original);
        this.runner.clearTransferState();
        byte[] value = (byte[])this.service.get("replaceme", new PutDistributedMapCache.StringSerializer(), new PutDistributedMapCache.CacheValueDeserializer());
        Assertions.assertEquals((Object)original, (Object)new String(value, "UTF-8"));
        String replaced = "replaced";
        this.runner.enqueue(replaced.getBytes("UTF-8"), props);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(PutDistributedMapCache.REL_FAILURE, 1);
        this.runner.assertTransferCount(PutDistributedMapCache.REL_FAILURE, 1);
        outputFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(PutDistributedMapCache.REL_FAILURE).get(0);
        outputFlowFile.assertAttributeEquals("cached", "false");
        outputFlowFile.assertContentEquals(replaced);
        this.runner.clearTransferState();
        value = (byte[])this.service.get("replaceme", new PutDistributedMapCache.StringSerializer(), new PutDistributedMapCache.CacheValueDeserializer());
        Assertions.assertEquals((Object)original, (Object)new String(value, "UTF-8"));
    }

    private class MockCacheClient
    extends AbstractControllerService
    implements DistributedMapCacheClient {
        private final ConcurrentMap<Object, Object> values = new ConcurrentHashMap<Object, Object>();
        private boolean failOnCalls = false;

        private MockCacheClient() {
        }

        private void verifyNotFail() throws IOException {
            if (this.failOnCalls) {
                throw new IOException("Could not call to remote service because Unit Test marked service unavailable");
            }
        }

        public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            this.verifyNotFail();
            Object retValue = this.values.putIfAbsent(key, value);
            return retValue == null;
        }

        public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
            this.verifyNotFail();
            return (V)this.values.putIfAbsent(key, value);
        }

        public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
            this.verifyNotFail();
            return this.values.containsKey(key);
        }

        public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
            this.verifyNotFail();
            this.values.put(key, value);
        }

        public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
            this.verifyNotFail();
            return this.values.get(key);
        }

        public void close() throws IOException {
        }

        public <K> boolean remove(K key, Serializer<K> serializer) throws IOException {
            this.verifyNotFail();
            this.values.remove(key);
            return true;
        }

        public long removeByPattern(String regex) throws IOException {
            this.verifyNotFail();
            ArrayList removedRecords = new ArrayList();
            Pattern p = Pattern.compile(regex);
            for (Object key : this.values.keySet()) {
                Matcher m = p.matcher(key.toString());
                if (!m.matches()) continue;
                removedRecords.add(this.values.get(key));
            }
            long numRemoved = removedRecords.size();
            removedRecords.forEach(this.values::remove);
            return numRemoved;
        }
    }
}

