/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.HashMap;
import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.LogMessage;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLogMessage {
    private TestableLogMessage testableLogMessage;
    private TestRunner runner;

    @BeforeEach
    public void before() throws InitializationException {
        this.testableLogMessage = new TestableLogMessage();
        this.runner = TestRunners.newTestRunner((Processor)this.testableLogMessage);
    }

    @AfterEach
    public void after() throws InitializationException {
        this.runner.shutdown();
    }

    @Test
    public void testInfoMessageLogged() {
        this.runner.setProperty(LogMessage.LOG_MESSAGE, "This should help the operator to follow the flow: ${foobar}");
        this.runner.setProperty(LogMessage.LOG_LEVEL, LogMessage.MessageLogLevel.info.toString());
        HashMap<String, String> flowAttributes = new HashMap<String, String>();
        flowAttributes.put("foobar", "baz");
        this.runner.enqueue("This is a message!", flowAttributes);
        this.runner.run();
        List successFlowFiles = this.runner.getFlowFilesForRelationship(LogMessage.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFlowFiles.size());
        MockComponentLog mockComponentLog = this.testableLogMessage.getMockComponentLog();
        List infoMessages = mockComponentLog.getInfoMessages();
        Assertions.assertEquals((int)1, (int)infoMessages.size());
        Assertions.assertTrue((boolean)((org.apache.nifi.util.LogMessage)infoMessages.get(0)).getMsg().endsWith("This should help the operator to follow the flow: baz"));
        Assertions.assertTrue((boolean)mockComponentLog.getTraceMessages().isEmpty());
        Assertions.assertTrue((boolean)mockComponentLog.getDebugMessages().isEmpty());
        Assertions.assertTrue((boolean)mockComponentLog.getWarnMessages().isEmpty());
        Assertions.assertTrue((boolean)mockComponentLog.getErrorMessages().isEmpty());
    }

    @Test
    public void testInfoMessageWithPrefixLogged() {
        this.runner.setProperty(LogMessage.LOG_PREFIX, "FOOBAR>>>");
        this.runner.setProperty(LogMessage.LOG_MESSAGE, "This should help the operator to follow the flow: ${foobar}");
        this.runner.setProperty(LogMessage.LOG_LEVEL, LogMessage.MessageLogLevel.info.toString());
        HashMap<String, String> flowAttributes = new HashMap<String, String>();
        flowAttributes.put("foobar", "baz");
        this.runner.enqueue("This is a message!", flowAttributes);
        this.runner.run();
        List successFlowFiles = this.runner.getFlowFilesForRelationship(LogMessage.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)successFlowFiles.size());
        MockComponentLog mockComponentLog = this.testableLogMessage.getMockComponentLog();
        List infoMessages = mockComponentLog.getInfoMessages();
        Assertions.assertEquals((int)1, (int)infoMessages.size());
        Assertions.assertTrue((boolean)((org.apache.nifi.util.LogMessage)infoMessages.get(0)).getMsg().endsWith("FOOBAR>>>This should help the operator to follow the flow: baz"));
        Assertions.assertTrue((boolean)mockComponentLog.getTraceMessages().isEmpty());
        Assertions.assertTrue((boolean)mockComponentLog.getDebugMessages().isEmpty());
        Assertions.assertTrue((boolean)mockComponentLog.getWarnMessages().isEmpty());
        Assertions.assertTrue((boolean)mockComponentLog.getErrorMessages().isEmpty());
    }

    private static class TestableLogMessage
    extends LogMessage {
        private TestableLogMessage() {
        }

        MockComponentLog getMockComponentLog() {
            ComponentLog mockLog = this.getLogger();
            if (!(mockLog instanceof MockComponentLog)) {
                throw new IllegalStateException("Logger is expected to be MockComponentLog, but was: " + mockLog.getClass());
            }
            return (MockComponentLog)mockLog;
        }
    }
}

