/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.http.HttpContextMap;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.HandleHttpResponse;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHandleHttpResponse {
    private static final String CONTEXT_MAP_ID = MockHttpContextMap.class.getSimpleName();
    private static final String HTTP_REQUEST_ID = "HTTP-Request-Identifier";
    private static final int HTTP_STATUS_CREATED = 201;
    private static final String FLOW_FILE_CONTENT = "TESTING";

    @Test
    public void testEnsureCompleted() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(HandleHttpResponse.class);
        MockHttpContextMap contextMap = new MockHttpContextMap(HTTP_REQUEST_ID, null, null);
        runner.addControllerService(CONTEXT_MAP_ID, (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpResponse.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        runner.setProperty(HandleHttpResponse.STATUS_CODE, "${status.code}");
        runner.setProperty("my-attr", "${my-attr}");
        runner.setProperty("no-valid-attr", "${no-valid-attr}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http.context.identifier", HTTP_REQUEST_ID);
        attributes.put("http.request.uri", "/test");
        attributes.put("http.local.name", "server");
        attributes.put("http.server.port", "8443");
        attributes.put("http.remote.host", "client");
        attributes.put("http.subject.dn", "sslDN");
        attributes.put("my-attr", "hello");
        attributes.put("status.code", Integer.toString(201));
        runner.enqueue(FLOW_FILE_CONTENT.getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(HandleHttpResponse.REL_SUCCESS, 1);
        Assertions.assertEquals((int)1, (int)runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.SEND, (Object)((ProvenanceEventRecord)runner.getProvenanceEvents().get(0)).getEventType());
        Assertions.assertEquals((Object)"https://client@server:8443/test", (Object)((ProvenanceEventRecord)runner.getProvenanceEvents().get(0)).getTransitUri());
        Assertions.assertEquals((Object)FLOW_FILE_CONTENT, (Object)contextMap.outputStream.toString());
        Assertions.assertEquals((Object)"hello", contextMap.headersSent.get("my-attr"));
        Assertions.assertNull(contextMap.headersSent.get("no-valid-attr"));
        Assertions.assertEquals((int)201, (int)contextMap.statusCode);
        Assertions.assertEquals((int)1, (int)contextMap.getCompletionCount());
        Assertions.assertTrue((boolean)contextMap.headersWithNoValue.isEmpty());
    }

    @Test
    public void testRegexHeaders() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(HandleHttpResponse.class);
        MockHttpContextMap contextMap = new MockHttpContextMap(HTTP_REQUEST_ID, null, null);
        runner.addControllerService(CONTEXT_MAP_ID, (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpResponse.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        runner.setProperty(HandleHttpResponse.STATUS_CODE, "${status.code}");
        runner.setProperty(HandleHttpResponse.ATTRIBUTES_AS_HEADERS_REGEX, "^(my.*)$");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http.context.identifier", HTTP_REQUEST_ID);
        attributes.put("http.request.uri", "/test");
        attributes.put("http.local.name", "server");
        attributes.put("http.server.port", "8443");
        attributes.put("http.remote.host", "client");
        attributes.put("http.subject.dn", "sslDN");
        attributes.put("my-attr", "hello");
        attributes.put("my-blank-attr", "");
        attributes.put("status.code", Integer.toString(201));
        runner.enqueue(FLOW_FILE_CONTENT.getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(HandleHttpResponse.REL_SUCCESS, 1);
        Assertions.assertEquals((int)1, (int)runner.getProvenanceEvents().size());
        Assertions.assertEquals((Object)ProvenanceEventType.SEND, (Object)((ProvenanceEventRecord)runner.getProvenanceEvents().get(0)).getEventType());
        Assertions.assertEquals((Object)"https://client@server:8443/test", (Object)((ProvenanceEventRecord)runner.getProvenanceEvents().get(0)).getTransitUri());
        Assertions.assertEquals((Object)FLOW_FILE_CONTENT, (Object)contextMap.outputStream.toString());
        Assertions.assertEquals((Object)"hello", contextMap.headersSent.get("my-attr"));
        Assertions.assertNull(contextMap.headersSent.get("my-blank-attr"));
        Assertions.assertEquals((int)201, (int)contextMap.statusCode);
        Assertions.assertEquals((int)1, (int)contextMap.getCompletionCount());
        Assertions.assertTrue((boolean)contextMap.headersWithNoValue.isEmpty());
    }

    @Test
    public void testResponseFlowFileAccessException() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(HandleHttpResponse.class);
        MockHttpContextMap contextMap = new MockHttpContextMap(HTTP_REQUEST_ID, (Exception)new FlowFileAccessException("Access Problem"), null);
        runner.addControllerService(CONTEXT_MAP_ID, (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpResponse.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        runner.setProperty(HandleHttpResponse.STATUS_CODE, "${status.code}");
        runner.setProperty("my-attr", "${my-attr}");
        runner.setProperty("no-valid-attr", "${no-valid-attr}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http.context.identifier", HTTP_REQUEST_ID);
        attributes.put("my-attr", "hello");
        attributes.put("status.code", Integer.toString(201));
        runner.enqueue(FLOW_FILE_CONTENT.getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(HandleHttpResponse.REL_FAILURE, 1);
        Assertions.assertEquals((int)0, (int)contextMap.getCompletionCount());
    }

    @Test
    public void testResponseProcessException() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(HandleHttpResponse.class);
        MockHttpContextMap contextMap = new MockHttpContextMap(HTTP_REQUEST_ID, (Exception)new ProcessException(), null);
        runner.addControllerService(CONTEXT_MAP_ID, (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpResponse.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        runner.setProperty(HandleHttpResponse.STATUS_CODE, "${status.code}");
        runner.setProperty("my-attr", "${my-attr}");
        runner.setProperty("no-valid-attr", "${no-valid-attr}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http.context.identifier", HTTP_REQUEST_ID);
        attributes.put("my-attr", "hello");
        attributes.put("status.code", Integer.toString(201));
        runner.enqueue(FLOW_FILE_CONTENT.getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(HandleHttpResponse.REL_FAILURE, 1);
        Assertions.assertEquals((int)1, (int)contextMap.getCompletionCount());
    }

    @Test
    public void testResponseProcessExceptionThenIllegalStateException() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(HandleHttpResponse.class);
        MockHttpContextMap contextMap = new MockHttpContextMap(HTTP_REQUEST_ID, (Exception)new ProcessException(), new IllegalStateException());
        runner.addControllerService(CONTEXT_MAP_ID, (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpResponse.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        runner.setProperty(HandleHttpResponse.STATUS_CODE, "${status.code}");
        runner.setProperty("my-attr", "${my-attr}");
        runner.setProperty("no-valid-attr", "${no-valid-attr}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http.context.identifier", HTTP_REQUEST_ID);
        attributes.put("my-attr", "hello");
        attributes.put("status.code", Integer.toString(201));
        runner.enqueue(FLOW_FILE_CONTENT.getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(HandleHttpResponse.REL_FAILURE, 1);
        Assertions.assertEquals((int)0, (int)contextMap.getCompletionCount());
    }

    @Test
    public void testStatusCodeEmpty() throws InitializationException {
        TestRunner runner = TestRunners.newTestRunner(HandleHttpResponse.class);
        MockHttpContextMap contextMap = new MockHttpContextMap(HTTP_REQUEST_ID, null, null);
        runner.addControllerService(CONTEXT_MAP_ID, (ControllerService)contextMap);
        runner.enableControllerService((ControllerService)contextMap);
        runner.setProperty(HandleHttpResponse.HTTP_CONTEXT_MAP, CONTEXT_MAP_ID);
        runner.setProperty(HandleHttpResponse.STATUS_CODE, "${status.code}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http.context.identifier", HTTP_REQUEST_ID);
        attributes.put("my-attr", "hello");
        runner.enqueue(FLOW_FILE_CONTENT.getBytes(), attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(HandleHttpResponse.REL_FAILURE, 1);
        Assertions.assertEquals((int)0, (int)contextMap.getCompletionCount());
    }

    private static class MockHttpContextMap
    extends AbstractControllerService
    implements HttpContextMap {
        private final String id;
        private final AtomicInteger completedCount = new AtomicInteger(0);
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final ConcurrentMap<String, String> headersSent = new ConcurrentHashMap<String, String>();
        private final Exception responseException;
        private final RuntimeException completeException;
        private volatile int statusCode = -1;
        private final List<String> headersWithNoValue = new CopyOnWriteArrayList<String>();

        public MockHttpContextMap(String expectedIdentifier, Exception responseException, RuntimeException completeException) {
            this.id = expectedIdentifier;
            this.responseException = responseException;
            this.completeException = completeException;
        }

        public boolean register(String identifier, HttpServletRequest request, HttpServletResponse response, AsyncContext context) {
            return true;
        }

        public HttpServletResponse getResponse(String identifier) {
            if (!this.id.equals(identifier)) {
                Assertions.fail((String)("attempting to respond to wrong request; should have been " + this.id + " but was " + identifier));
            }
            try {
                HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
                if (this.responseException == null) {
                    Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new ServletOutputStream(){

                        public boolean isReady() {
                            return true;
                        }

                        public void setWriteListener(WriteListener writeListener) {
                        }

                        public void write(int b) {
                            outputStream.write(b);
                        }

                        public void write(byte[] b) throws IOException {
                            outputStream.write(b);
                        }

                        public void write(byte[] b, int off, int len) {
                            outputStream.write(b, off, len);
                        }
                    });
                } else {
                    Mockito.when((Object)response.getOutputStream()).thenThrow(new Throwable[]{this.responseException});
                }
                ((HttpServletResponse)Mockito.doAnswer(invocation -> {
                    String key = (String)invocation.getArgument(0);
                    String value = (String)invocation.getArgument(1);
                    if (value == null) {
                        this.headersWithNoValue.add(key);
                    } else {
                        this.headersSent.put(key, value);
                    }
                    return null;
                }).when((Object)response)).setHeader((String)Mockito.any(String.class), (String)Mockito.any(String.class));
                ((HttpServletResponse)Mockito.doAnswer(invocation -> {
                    this.statusCode = (Integer)invocation.getArgument(0);
                    return null;
                }).when((Object)response)).setStatus(Mockito.anyInt());
                return response;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.toString());
                return null;
            }
        }

        public void complete(String identifier) {
            if (!this.id.equals(identifier)) {
                Assertions.fail((String)("attempting to respond to wrong request; should have been " + this.id + " but was " + identifier));
            }
            if (this.completeException != null) {
                throw this.completeException;
            }
            this.completedCount.incrementAndGet();
        }

        public int getCompletionCount() {
            return this.completedCount.get();
        }

        public long getRequestTimeout(TimeUnit timeUnit) {
            return timeUnit.convert(30000L, TimeUnit.MILLISECONDS);
        }
    }
}

