/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.GenerateFlowFile;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestGenerateFlowFile {
    @Test
    public void testGenerateCustomText() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new GenerateFlowFile());
        runner.setProperty(GenerateFlowFile.FILE_SIZE, "100MB");
        runner.setProperty(GenerateFlowFile.DATA_FORMAT, "Text");
        runner.setProperty(GenerateFlowFile.CUSTOM_TEXT, "This is my custom text!");
        runner.run();
        runner.assertTransferCount(GenerateFlowFile.SUCCESS, 1);
        MockFlowFile generatedFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(GenerateFlowFile.SUCCESS).get(0);
        generatedFlowFile.assertContentEquals("This is my custom text!");
        generatedFlowFile.assertAttributeNotExists("mime.type");
    }

    @Test
    public void testInvalidCustomText() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new GenerateFlowFile());
        runner.setProperty(GenerateFlowFile.FILE_SIZE, "100MB");
        runner.setProperty(GenerateFlowFile.DATA_FORMAT, "Binary");
        runner.setProperty(GenerateFlowFile.CUSTOM_TEXT, "This is my custom text!");
        runner.assertNotValid();
        runner.setProperty(GenerateFlowFile.DATA_FORMAT, "Text");
        runner.setProperty(GenerateFlowFile.UNIQUE_FLOWFILES, "true");
        runner.assertNotValid();
    }

    @Test
    public void testDynamicPropertiesToAttributes() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new GenerateFlowFile());
        runner.setProperty(GenerateFlowFile.FILE_SIZE, "1B");
        runner.setProperty(GenerateFlowFile.DATA_FORMAT, "Text");
        runner.setProperty(GenerateFlowFile.MIME_TYPE, "application/text");
        runner.setProperty("plain.dynamic.property", "Plain Value");
        runner.setProperty("expression.dynamic.property", "${literal('Expression Value')}");
        runner.assertValid();
        runner.run();
        runner.assertTransferCount(GenerateFlowFile.SUCCESS, 1);
        MockFlowFile generatedFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(GenerateFlowFile.SUCCESS).get(0);
        generatedFlowFile.assertAttributeEquals("plain.dynamic.property", "Plain Value");
        generatedFlowFile.assertAttributeEquals("expression.dynamic.property", "Expression Value");
        generatedFlowFile.assertAttributeEquals("mime.type", "application/text");
    }
}

