/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.processors.standard.FlattenJson;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFlattenJson {
    private static final ObjectMapper mapper = new ObjectMapper();
    private TestRunner testRunner;

    @BeforeEach
    void setupRunner() {
        this.testRunner = TestRunners.newTestRunner(FlattenJson.class);
    }

    @Test
    void testFlatten() throws JsonProcessingException {
        String json = "{\n    \"test\": {\n        \"msg\": \"Hello, world\"\n    },\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}";
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"test\": {\n        \"msg\": \"Hello, world\"\n    },\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}", 2);
        Assertions.assertEquals(parsed.get("test.msg"), (Object)"Hello, world", (String)"test.msg should exist, but doesn't");
        Assertions.assertEquals(parsed.get("first.second.third"), Arrays.asList("one", "two", "three", "four", "five"), (String)"Three level block doesn't exist.");
    }

    @Test
    void testFlattenRecordSet() throws JsonProcessingException {
        String json = "[\n    {\n        \"first\": {\n            \"second\": \"Hello\"\n        }\n    },\n    {\n        \"first\": {\n            \"second\": \"World\"\n        }\n    }\n]";
        List<String> expected = Arrays.asList("Hello", "World");
        List parsed = (List)this.baseTest(this.testRunner, "[\n    {\n        \"first\": {\n            \"second\": \"Hello\"\n        }\n    },\n    {\n        \"first\": {\n            \"second\": \"World\"\n        }\n    }\n]", 2);
        Assertions.assertTrue((boolean)(parsed instanceof List), (String)"Not a list");
        for (int i = 0; i < parsed.size(); ++i) {
            Map map = (Map)parsed.get(i);
            Assertions.assertEquals(map.get("first.second"), (Object)expected.get(i), (String)"Missing values.");
        }
    }

    @Test
    void testDifferentSeparator() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}";
        this.testRunner.setProperty(FlattenJson.SEPARATOR, "_");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}", 1);
        Assertions.assertEquals(parsed.get("first_second_third"), Arrays.asList("one", "two", "three", "four", "five"), (String)"Separator not applied.");
    }

    @Test
    void testExpressionLanguage() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}";
        this.testRunner.setValidateExpressionUsage(true);
        this.testRunner.setProperty(FlattenJson.SEPARATOR, "${separator.char}");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}", Collections.singletonMap("separator.char", "_"), 1);
        Assertions.assertEquals(parsed.get("first_second_third"), Arrays.asList("one", "two", "three", "four", "five"), (String)"Separator not applied.");
    }

    @Test
    void testFlattenModeNormal() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_NORMAL);
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}", 5);
        Assertions.assertEquals((Object)"one", parsed.get("first.second.third[0]"), (String)"Separator not applied.");
    }

    @Test
    void testFlattenModeKeepArrays() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second\": [\n            {\n                \"x\": 1,\n                \"y\": 2,\n                \"z\": [\n                    3,\n                    4,\n                    5\n                ]\n            },\n            [\n                6,\n                7,\n                8\n            ],\n            [\n                [\n                    9,\n                    10\n                ],\n                11,\n                12\n            ]\n        ],\n        \"third\": {\n            \"a\": \"b\",\n            \"c\": \"d\",\n            \"e\": \"f\"\n        }\n    }\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_KEEP_ARRAYS);
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second\": [\n            {\n                \"x\": 1,\n                \"y\": 2,\n                \"z\": [\n                    3,\n                    4,\n                    5\n                ]\n            },\n            [\n                6,\n                7,\n                8\n            ],\n            [\n                [\n                    9,\n                    10\n                ],\n                11,\n                12\n            ]\n        ],\n        \"third\": {\n            \"a\": \"b\",\n            \"c\": \"d\",\n            \"e\": \"f\"\n        }\n    }\n}", 4);
        Assertions.assertInstanceOf(List.class, parsed.get("first.second"));
        Assertions.assertEquals(Arrays.asList(6, 7, 8), ((List)parsed.get("first.second")).get(1));
        Assertions.assertEquals((Object)"b", parsed.get("first.third.a"), (String)"Separator not applied.");
    }

    @Test
    void testFlattenModeKeepPrimitiveArrays() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second\": [\n            {\n                \"x\": 1,\n                \"y\": 2,\n                \"z\": [\n                    3,\n                    4,\n                    5\n                ]\n            },\n            [\n                6,\n                7,\n                8\n            ],\n            [\n                [\n                    9,\n                    10\n                ],\n                11,\n                12\n            ]\n        ],\n        \"third\": {\n            \"a\": \"b\",\n            \"c\": \"d\",\n            \"e\": \"f\"\n        }\n    }\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_KEEP_PRIMITIVE_ARRAYS);
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second\": [\n            {\n                \"x\": 1,\n                \"y\": 2,\n                \"z\": [\n                    3,\n                    4,\n                    5\n                ]\n            },\n            [\n                6,\n                7,\n                8\n            ],\n            [\n                [\n                    9,\n                    10\n                ],\n                11,\n                12\n            ]\n        ],\n        \"third\": {\n            \"a\": \"b\",\n            \"c\": \"d\",\n            \"e\": \"f\"\n        }\n    }\n}", 10);
        Assertions.assertEquals((Object)1, parsed.get("first.second[0].x"), (String)"Separator not applied.");
        Assertions.assertEquals(Arrays.asList(3, 4, 5), parsed.get("first.second[0].z"), (String)"Separator not applied.");
        Assertions.assertEquals(Arrays.asList(9, 10), parsed.get("first.second[2][0]"), (String)"Separator not applied.");
        Assertions.assertEquals((Object)11, parsed.get("first.second[2][1]"), (String)"Separator not applied.");
        Assertions.assertEquals((Object)12, parsed.get("first.second[2][2]"), (String)"Separator not applied.");
        Assertions.assertEquals((Object)"d", parsed.get("first.third.c"), (String)"Separator not applied.");
    }

    @Test
    void testFlattenModeDotNotation() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_DOT_NOTATION);
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"one\",\n                \"two\",\n                \"three\",\n                \"four\",\n                \"five\"\n            ]\n        }\n    }\n}", 5);
        Assertions.assertEquals((Object)"one", parsed.get("first.second.third.0"), (String)"Separator not applied.");
    }

    @Test
    void testFlattenSlash() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"http://localhost/value1\",\n                \"http://localhost/value2\"\n            ]\n        }\n    }\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_NORMAL);
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second\": {\n            \"third\": [\n                \"http://localhost/value1\",\n                \"http://localhost/value2\"\n            ]\n        }\n    }\n}", 2);
        Assertions.assertEquals((Object)"http://localhost/value1", parsed.get("first.second.third[0]"), (String)"Separator not applied.");
    }

    @Test
    void testEscapeForJson() throws JsonProcessingException {
        String json = "{\n    \"name\": \"Jos\\u00e9\"\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_NORMAL);
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"name\": \"Jos\\u00e9\"\n}", 1);
        Assertions.assertEquals((Object)"Jos\u00e9", parsed.get("name"), (String)"Separator not applied.");
    }

    @Test
    void testUnFlatten() throws JsonProcessingException {
        String json = "{\n    \"test.msg\": \"Hello, world\",\n    \"first.second.third\": [\n        \"one\",\n        \"two\",\n        \"three\",\n        \"four\",\n        \"five\"\n    ]\n}";
        this.testRunner.setProperty(FlattenJson.RETURN_TYPE, "unflatten");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"test.msg\": \"Hello, world\",\n    \"first.second.third\": [\n        \"one\",\n        \"two\",\n        \"three\",\n        \"four\",\n        \"five\"\n    ]\n}", 2);
        Assertions.assertEquals((Object)"Hello, world", ((Map)parsed.get("test")).get("msg"));
        Assertions.assertEquals(Arrays.asList("one", "two", "three", "four", "five"), ((Map)((Map)parsed.get("first")).get("second")).get("third"));
    }

    @Test
    void testUnFlattenWithDifferentSeparator() throws JsonProcessingException {
        String json = "{\n    \"first_second_third\": [\n        \"one\",\n        \"two\",\n        \"three\",\n        \"four\",\n        \"five\"\n    ]\n}";
        this.testRunner.setProperty(FlattenJson.SEPARATOR, "_");
        this.testRunner.setProperty(FlattenJson.RETURN_TYPE, "unflatten");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first_second_third\": [\n        \"one\",\n        \"two\",\n        \"three\",\n        \"four\",\n        \"five\"\n    ]\n}", 1);
        Assertions.assertEquals(Arrays.asList("one", "two", "three", "four", "five"), ((Map)((Map)parsed.get("first")).get("second")).get("third"));
    }

    @Test
    void testUnFlattenForKeepArraysMode() throws JsonProcessingException {
        String json = "{\n    \"a.b\": 1,\n    \"a.c\": [\n        false,\n        {\n            \"i.j\": [\n                false,\n                true,\n                \"xy\"\n            ]\n        }\n    ]\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_KEEP_ARRAYS);
        this.testRunner.setProperty(FlattenJson.RETURN_TYPE, "unflatten");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"a.b\": 1,\n    \"a.c\": [\n        false,\n        {\n            \"i.j\": [\n                false,\n                true,\n                \"xy\"\n            ]\n        }\n    ]\n}", 1);
        Assertions.assertEquals((Object)1, ((Map)parsed.get("a")).get("b"));
        Assertions.assertEquals((Object)false, ((List)((Map)parsed.get("a")).get("c")).get(0));
        Assertions.assertEquals(Arrays.asList(false, true, "xy"), ((Map)((Map)((List)((Map)parsed.get("a")).get("c")).get(1)).get("i")).get("j"));
    }

    @Test
    void testUnFlattenForKeepPrimitiveArraysMode() throws JsonProcessingException {
        String json = "{\n    \"first.second[0].x\": 1,\n    \"first.second[0].y\": 2,\n    \"first.second[0].z\": [\n        3,\n        4,\n        5\n    ],\n    \"first.second[1]\": [\n        6,\n        7,\n        8\n    ],\n    \"first.second[2][0]\": [\n        9,\n        10\n    ],\n    \"first.second[2][1]\": 11,\n    \"first.second[2][2]\": 12,\n    \"first.third.a\": \"b\",\n    \"first.third.c\": \"d\",\n    \"first.third.e\": \"f\"\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_KEEP_PRIMITIVE_ARRAYS);
        this.testRunner.setProperty(FlattenJson.RETURN_TYPE, "unflatten");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first.second[0].x\": 1,\n    \"first.second[0].y\": 2,\n    \"first.second[0].z\": [\n        3,\n        4,\n        5\n    ],\n    \"first.second[1]\": [\n        6,\n        7,\n        8\n    ],\n    \"first.second[2][0]\": [\n        9,\n        10\n    ],\n    \"first.second[2][1]\": 11,\n    \"first.second[2][2]\": 12,\n    \"first.third.a\": \"b\",\n    \"first.third.c\": \"d\",\n    \"first.third.e\": \"f\"\n}", 1);
        Assertions.assertEquals((Object)1, ((Map)((List)((Map)parsed.get("first")).get("second")).get(0)).get("x"));
        Assertions.assertEquals(Arrays.asList(9, 10), ((List)((List)((Map)parsed.get("first")).get("second")).get(2)).get(0));
        Assertions.assertEquals((Object)"d", ((Map)((Map)parsed.get("first")).get("third")).get("c"));
    }

    @Test
    void testUnFlattenForDotNotationMode() throws JsonProcessingException {
        String json = "{\n    \"first.second.third.0\": [\n        \"one\",\n        \"two\",\n        \"three\",\n        \"four\",\n        \"five\"\n    ]\n}";
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_DOT_NOTATION);
        this.testRunner.setProperty(FlattenJson.RETURN_TYPE, "unflatten");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first.second.third.0\": [\n        \"one\",\n        \"two\",\n        \"three\",\n        \"four\",\n        \"five\"\n    ]\n}", 1);
        Assertions.assertEquals(Arrays.asList("one", "two", "three", "four", "five"), ((List)((Map)((Map)parsed.get("first")).get("second")).get("third")).get(0));
    }

    @Test
    void testFlattenWithIgnoreReservedCharacters() throws JsonProcessingException {
        String json = "{\n    \"first\": {\n        \"second.third\": \"Hello\",\n        \"fourth\": \"World\"\n    }\n}";
        this.testRunner.setProperty(FlattenJson.IGNORE_RESERVED_CHARACTERS, "true");
        Map parsed = (Map)this.baseTest(this.testRunner, "{\n    \"first\": {\n        \"second.third\": \"Hello\",\n        \"fourth\": \"World\"\n    }\n}", 2);
        Assertions.assertEquals((Object)"Hello", parsed.get("first.second.third"), (String)"Separator not applied.");
        Assertions.assertEquals((Object)"World", parsed.get("first.fourth"), (String)"Separator not applied.");
    }

    @Test
    void testFlattenRecordSetWithIgnoreReservedCharacters() throws JsonProcessingException {
        String json = "[\n    {\n        \"first\": {\n            \"second_third\": \"Hello\"\n        }\n    },\n    {\n        \"first\": {\n            \"second_third\": \"World\"\n        }\n    }\n]";
        this.testRunner.setProperty(FlattenJson.SEPARATOR, "_");
        this.testRunner.setProperty(FlattenJson.IGNORE_RESERVED_CHARACTERS, "true");
        List<String> expected = Arrays.asList("Hello", "World");
        List parsed = (List)this.baseTest(this.testRunner, "[\n    {\n        \"first\": {\n            \"second_third\": \"Hello\"\n        }\n    },\n    {\n        \"first\": {\n            \"second_third\": \"World\"\n        }\n    }\n]", 2);
        for (int i = 0; i < parsed.size(); ++i) {
            Assertions.assertEquals((Object)expected.get(i), ((Map)parsed.get(i)).get("first_second_third"), (String)"Missing values.");
        }
    }

    @Test
    void testFlattenModeNormalWithIgnoreReservedCharacters() throws JsonProcessingException {
        String json = "[\n    {\n        \"first\": {\n            \"second_third\": \"Hello\"\n        }\n    },\n    {\n        \"first\": {\n            \"second_third\": \"World\"\n        }\n    }\n]";
        this.testRunner.setProperty(FlattenJson.SEPARATOR, "_");
        this.testRunner.setProperty(FlattenJson.IGNORE_RESERVED_CHARACTERS, "true");
        this.testRunner.setProperty(FlattenJson.FLATTEN_MODE, FlattenJson.FLATTEN_MODE_NORMAL);
        Map parsed = (Map)this.baseTest(this.testRunner, "[\n    {\n        \"first\": {\n            \"second_third\": \"Hello\"\n        }\n    },\n    {\n        \"first\": {\n            \"second_third\": \"World\"\n        }\n    }\n]", 2);
        Assertions.assertEquals((Object)"Hello", parsed.get("[0]_first_second_third"), (String)"Separator not applied.");
        Assertions.assertEquals((Object)"World", parsed.get("[1]_first_second_third"), (String)"Separator not applied.");
    }

    private Object baseTest(TestRunner testRunner, String json, int keyCount) throws JsonProcessingException {
        return this.baseTest(testRunner, json, Collections.emptyMap(), keyCount);
    }

    private Object baseTest(TestRunner testRunner, String json, Map attrs, int keyCount) throws JsonProcessingException {
        testRunner.enqueue(json, attrs);
        testRunner.run(1, true);
        testRunner.assertTransferCount(FlattenJson.REL_FAILURE, 0);
        testRunner.assertTransferCount(FlattenJson.REL_SUCCESS, 1);
        List flowFiles = testRunner.getFlowFilesForRelationship(FlattenJson.REL_SUCCESS);
        byte[] content = testRunner.getContentAsByteArray((MockFlowFile)flowFiles.get(0));
        String asJson = new String(content);
        if (asJson.startsWith("[")) {
            List parsed = (List)mapper.readValue(asJson, List.class);
            Assertions.assertEquals((int)keyCount, (int)parsed.size(), (String)"Too many keys");
            return parsed;
        }
        Map parsed = (Map)mapper.readValue(asJson, Map.class);
        Assertions.assertEquals((int)keyCount, (int)parsed.size(), (String)"Too many keys");
        return parsed;
    }
}

