/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.FetchFTP;
import org.apache.nifi.processors.standard.FetchFileTransfer;
import org.apache.nifi.processors.standard.util.FTPTransfer;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.processors.standard.util.PermissionDeniedException;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestFetchFTP {
    private TestableFetchFTP proc;
    private TestRunner runner;

    @BeforeEach
    public void setUp() throws Exception {
        this.proc = new TestableFetchFTP();
        this.runner = TestRunners.newTestRunner((Processor)this.proc);
        this.runner.setValidateExpressionUsage(false);
        this.runner.setProperty(FetchFileTransfer.HOSTNAME, "localhost");
        this.runner.setProperty(FetchFileTransfer.UNDEFAULTED_PORT, "11");
        this.runner.setProperty(FetchFileTransfer.REMOTE_FILENAME, "${filename}");
        MockProcessContext ctx = (MockProcessContext)this.runner.getProcessContext();
        this.setDefaultValues(ctx, FTPTransfer.BUFFER_SIZE, FTPTransfer.DATA_TIMEOUT, FTPTransfer.CONNECTION_TIMEOUT, FTPTransfer.CONNECTION_MODE, FTPTransfer.TRANSFER_MODE);
        ctx.setProperty(FTPTransfer.USERNAME, "foo");
        ctx.setProperty(FTPTransfer.PASSWORD, "bar");
    }

    private void setDefaultValues(MockProcessContext ctx, PropertyDescriptor ... propertyDescriptors) {
        Arrays.stream(propertyDescriptors).forEach(d -> ctx.setProperty(d, d.getDefaultValue()));
    }

    private void addFileAndEnqueue(String filename) {
        this.proc.addContent(filename, "world".getBytes());
        this.runner.enqueue(new byte[0], Collections.singletonMap("filename", filename));
    }

    @Test
    public void testContentFetched() {
        this.addFileAndEnqueue("hello.txt");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        Assertions.assertFalse((boolean)this.proc.isClosed);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(FetchFileTransfer.REL_SUCCESS).get(0)).assertContentEquals("world");
    }

    @Test
    public void testFilenameContainsPath() {
        this.addFileAndEnqueue("./here/is/my/path/hello.txt");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        Assertions.assertFalse((boolean)this.proc.isClosed);
        MockFlowFile transferredFlowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(FetchFileTransfer.REL_SUCCESS).get(0);
        transferredFlowFile.assertContentEquals("world");
        transferredFlowFile.assertAttributeExists(CoreAttributes.PATH.key());
        transferredFlowFile.assertAttributeEquals(CoreAttributes.PATH.key(), "./here/is/my/path");
    }

    @Test
    public void testContentNotFound() {
        this.runner.enqueue(new byte[0], Collections.singletonMap("filename", "hello.txt"));
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_NOT_FOUND, 1);
        this.runner.assertAllFlowFilesContainAttribute("fetch.failure.reason");
        MockFlowFile transferredFlowFile = (MockFlowFile)this.runner.getPenalizedFlowFiles().get(0);
        Assertions.assertEquals((Object)FetchFileTransfer.REL_NOT_FOUND.getName(), (Object)transferredFlowFile.getAttribute("fetch.failure.reason"));
    }

    @Test
    public void testInsufficientPermissions() {
        this.addFileAndEnqueue("hello.txt");
        this.proc.allowAccess = false;
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_PERMISSION_DENIED, 1);
        this.runner.assertAllFlowFilesContainAttribute("fetch.failure.reason");
        MockFlowFile transferredFlowFile = (MockFlowFile)this.runner.getPenalizedFlowFiles().get(0);
        Assertions.assertEquals((Object)FetchFileTransfer.REL_PERMISSION_DENIED.getName(), (Object)transferredFlowFile.getAttribute("fetch.failure.reason"));
    }

    @Test
    public void testInsufficientPermissionsDoesNotCloseConnection() {
        this.addFileAndEnqueue("hello1.txt");
        this.addFileAndEnqueue("hello2.txt");
        this.proc.allowAccess = false;
        this.runner.run(2, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_PERMISSION_DENIED, 2);
        this.runner.assertAllFlowFilesContainAttribute("fetch.failure.reason");
        Assertions.assertEquals((int)1, (int)this.proc.numberOfFileTransfers);
        Assertions.assertFalse((boolean)this.proc.isClosed);
    }

    @Test
    public void testFileNotFoundDoesNotCloseConnection() {
        this.addFileAndEnqueue("hello1.txt");
        this.addFileAndEnqueue("hello2.txt");
        this.proc.isFileNotFound = true;
        this.runner.run(2, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_NOT_FOUND, 2);
        this.runner.assertAllFlowFilesContainAttribute("fetch.failure.reason");
        Assertions.assertEquals((int)1, (int)this.proc.numberOfFileTransfers);
        Assertions.assertFalse((boolean)this.proc.isClosed);
    }

    @Test
    public void testCommunicationFailureClosesConnection() {
        this.addFileAndEnqueue("hello.txt");
        this.proc.isCommFailure = true;
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_COMMS_FAILURE, 1);
        this.runner.assertAllFlowFilesContainAttribute("fetch.failure.reason");
        MockFlowFile transferredFlowFile = (MockFlowFile)this.runner.getPenalizedFlowFiles().get(0);
        Assertions.assertEquals((Object)FetchFileTransfer.REL_COMMS_FAILURE.getName(), (Object)transferredFlowFile.getAttribute("fetch.failure.reason"));
        Assertions.assertTrue((boolean)this.proc.isClosed);
    }

    @Test
    public void testMoveFileWithNoTrailingSlashDirName() {
        this.runner.setProperty(FetchFileTransfer.COMPLETION_STRATEGY, FetchFileTransfer.COMPLETION_MOVE.getValue());
        this.runner.setProperty(FetchFileTransfer.MOVE_DESTINATION_DIR, "/moved");
        this.runner.setProperty(FetchFileTransfer.MOVE_CREATE_DIRECTORY, "true");
        this.addFileAndEnqueue("hello.txt");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        this.proc.fileContents.containsKey("/moved/hello.txt");
        Assertions.assertEquals((int)1, (int)this.proc.fileContents.size());
    }

    @Test
    public void testMoveFileWithTrailingSlashDirName() {
        this.runner.setProperty(FetchFileTransfer.COMPLETION_STRATEGY, FetchFileTransfer.COMPLETION_MOVE.getValue());
        this.runner.setProperty(FetchFileTransfer.MOVE_DESTINATION_DIR, "/moved/");
        this.addFileAndEnqueue("hello.txt");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        this.proc.fileContents.containsKey("/moved/hello.txt");
        Assertions.assertEquals((int)1, (int)this.proc.fileContents.size());
    }

    @Test
    public void testDeleteFile() {
        this.runner.setProperty(FetchFileTransfer.COMPLETION_STRATEGY, FetchFileTransfer.COMPLETION_DELETE.getValue());
        this.addFileAndEnqueue("hello.txt");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        Assertions.assertTrue((boolean)this.proc.fileContents.isEmpty());
    }

    @Test
    public void testDeleteFails() {
        this.runner.setProperty(FetchFileTransfer.COMPLETION_STRATEGY, FetchFileTransfer.COMPLETION_DELETE.getValue());
        this.proc.allowDelete = false;
        this.addFileAndEnqueue("hello.txt");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        Assertions.assertFalse((boolean)this.proc.fileContents.isEmpty());
    }

    @Test
    public void testRenameFails() {
        this.runner.setProperty(FetchFileTransfer.COMPLETION_STRATEGY, FetchFileTransfer.COMPLETION_MOVE.getValue());
        this.runner.setProperty(FetchFileTransfer.MOVE_DESTINATION_DIR, "/moved/");
        this.proc.allowDelete = false;
        this.proc.allowRename = false;
        this.addFileAndEnqueue("hello.txt");
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        Assertions.assertEquals((int)1, (int)this.proc.fileContents.size());
        Assertions.assertTrue((boolean)this.proc.fileContents.containsKey("hello.txt"));
    }

    @Test
    public void testCreateDirFails() {
        this.runner.setProperty(FetchFileTransfer.COMPLETION_STRATEGY, FetchFileTransfer.COMPLETION_MOVE.getValue());
        this.runner.setProperty(FetchFileTransfer.MOVE_DESTINATION_DIR, "/moved/");
        this.runner.setProperty(FetchFileTransfer.MOVE_CREATE_DIRECTORY, "true");
        this.addFileAndEnqueue("hello.txt");
        this.proc.allowCreateDir = false;
        this.runner.run(1, false, false);
        this.runner.assertAllFlowFilesTransferred(FetchFileTransfer.REL_SUCCESS, 1);
        Assertions.assertEquals((int)1, (int)this.proc.fileContents.size());
        Assertions.assertTrue((boolean)this.proc.fileContents.containsKey("hello.txt"));
    }

    private static class TestableFetchFTP
    extends FetchFTP {
        private boolean allowAccess = true;
        private boolean allowDelete = true;
        private boolean allowCreateDir = true;
        private boolean allowRename = true;
        private boolean isClosed = false;
        private boolean isFileNotFound = false;
        private boolean isCommFailure = false;
        private int numberOfFileTransfers = 0;
        private final Map<String, byte[]> fileContents = new HashMap<String, byte[]>();
        private final FTPClient mockFtpClient = (FTPClient)Mockito.mock(FTPClient.class);

        private TestableFetchFTP() throws IOException {
            Mockito.when((Object)this.mockFtpClient.retrieveFileStream(ArgumentMatchers.anyString())).then(invocationOnMock -> {
                byte[] content = this.fileContents.get(invocationOnMock.getArgument(0));
                if (content == null) {
                    throw new FileNotFoundException();
                }
                return new ByteArrayInputStream(content);
            });
            Mockito.when((Object)this.mockFtpClient.login(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
            Mockito.when((Object)this.mockFtpClient.setFileType(ArgumentMatchers.anyInt())).thenReturn((Object)true);
        }

        public void addContent(String filename, byte[] content) {
            this.fileContents.put(filename, content);
        }

        protected FileTransfer createFileTransfer(ProcessContext context) {
            ++this.numberOfFileTransfers;
            return new FTPTransfer(context, this.getLogger()){

                protected FTPClient createClient(PropertyContext context, Map<String, String> attributes) {
                    return mockFtpClient;
                }

                public FlowFile getRemoteFile(String remoteFileName, FlowFile flowFile, ProcessSession session) throws ProcessException, IOException {
                    if (!allowAccess) {
                        throw new PermissionDeniedException("test permission denied");
                    }
                    if (isFileNotFound) {
                        throw new FileNotFoundException("test file not found");
                    }
                    if (isCommFailure) {
                        throw new IOException("test communication failure");
                    }
                    return super.getRemoteFile(remoteFileName, flowFile, session);
                }

                public void deleteFile(FlowFile flowFile, String path, String remoteFileName) throws IOException {
                    if (!allowDelete) {
                        throw new PermissionDeniedException("test permission denied");
                    }
                    if (!fileContents.containsKey(remoteFileName)) {
                        throw new FileNotFoundException();
                    }
                    fileContents.remove(remoteFileName);
                }

                public void rename(FlowFile flowFile, String source, String target) throws IOException {
                    if (!allowRename) {
                        throw new PermissionDeniedException("test permission denied");
                    }
                    if (!fileContents.containsKey(source)) {
                        throw new FileNotFoundException();
                    }
                    byte[] content = fileContents.remove(source);
                    fileContents.put(target, content);
                }

                public void ensureDirectoryExists(FlowFile flowFile, File remoteDirectory) throws IOException {
                    if (!allowCreateDir) {
                        throw new PermissionDeniedException("test permission denied");
                    }
                }

                public void close() throws IOException {
                    super.close();
                    isClosed = true;
                }
            };
        }
    }
}

