/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.EvaluateXPath;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateXPath {
    private static final Path XML_SNIPPET = Paths.get("src/test/resources/TestXml/xml-snippet.xml", new String[0]);
    private static final Path XML_SNIPPET_EMBEDDED_DOCTYPE = Paths.get("src/test/resources/TestXml/xml-snippet-embedded-doctype.xml", new String[0]);
    private static final Path XML_SNIPPET_NONEXISTENT_DOCTYPE = Paths.get("src/test/resources/TestXml/xml-snippet-external-doctype.xml", new String[0]);

    @Test
    public void testAsAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("xpath.result1", "/");
        testRunner.setProperty("xpath.result2", "/*:bundle/node/subNode/value/text()");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXPath.REL_MATCH).get(0);
        out.assertAttributeEquals("xpath.result2", "Hello");
        Assertions.assertTrue((boolean)out.getAttribute("xpath.result1").contains("Hello"));
    }

    @Test
    public void testCheckIfElementExists() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty("xpath.result1", "/");
        testRunner.setProperty("xpath.result.exist.1", "boolean(/*:bundle/node)");
        testRunner.setProperty("xpath.result.exist.2", "boolean(/*:bundle/node2)");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXPath.REL_MATCH).get(0);
        Assertions.assertTrue((boolean)out.getAttribute("xpath.result1").contains("Hello"));
        out.assertAttributeEquals("xpath.result.exist.1", "true");
        out.assertAttributeEquals("xpath.result.exist.2", "false");
    }

    @Test
    public void testUnmatched() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty("xpath.result.exist.2", "/*:bundle/node2");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_NO_MATCH, 1);
        ((MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXPath.REL_NO_MATCH).get(0)).assertContentEquals(XML_SNIPPET);
    }

    @Test
    public void testMultipleXPathForContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXPath.RETURN_TYPE, "auto-detect");
        testRunner.setProperty("some.property.1", "/*:bundle/node/subNode[1]");
        testRunner.setProperty("some.property.2", "/*:bundle/node/subNode[2]");
        testRunner.enqueue(XML_SNIPPET);
        Assertions.assertThrows(AssertionError.class, () -> ((TestRunner)testRunner).run());
    }

    @Test
    public void testWriteToContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXPath.REL_MATCH).get(0);
        byte[] outData = testRunner.getContentAsByteArray(out);
        String outXml = new String(outData, StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)outXml.contains("subNode"));
        Assertions.assertTrue((boolean)outXml.contains("Hello"));
    }

    @Test
    public void testFailureIfContentMatchesMultipleNodes() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_FAILURE, 1);
    }

    @Test
    public void testWriteStringToContent() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXPath.RETURN_TYPE, "string");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXPath.REL_MATCH).get(0);
        out.assertContentEquals("Hello");
    }

    @Test
    public void testWriteNodeSetToAttribute() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-attribute");
        testRunner.setProperty(EvaluateXPath.RETURN_TYPE, "nodeset");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]");
        testRunner.enqueue(XML_SNIPPET);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXPath.REL_MATCH).get(0);
        String outXml = out.getAttribute("some.property");
        Assertions.assertTrue((boolean)outXml.contains("subNode"));
        Assertions.assertTrue((boolean)outXml.contains("Hello"));
    }

    @Test
    public void testSuccessForEmbeddedDocTypeValidation() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXPath.RETURN_TYPE, "string");
        testRunner.setProperty(EvaluateXPath.VALIDATE_DTD, "true");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_EMBEDDED_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(EvaluateXPath.REL_MATCH).get(0);
        out.assertContentEquals("Hello");
    }

    @Test
    public void testFailureForEmbeddedDocTypeValidationDisabled() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXPath.RETURN_TYPE, "string");
        testRunner.setProperty(EvaluateXPath.VALIDATE_DTD, "false");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_EMBEDDED_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_FAILURE, 1);
    }

    @Test
    public void testFailureForExternalDocTypeWithDocTypeValidationEnabled() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXPath.RETURN_TYPE, "string");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_NONEXISTENT_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_FAILURE, 1);
    }

    @Test
    public void testFailureForExternalDocTypeWithDocTypeValidationDisabled() throws IOException {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new EvaluateXPath());
        testRunner.setProperty(EvaluateXPath.DESTINATION, "flowfile-content");
        testRunner.setProperty(EvaluateXPath.RETURN_TYPE, "string");
        testRunner.setProperty(EvaluateXPath.VALIDATE_DTD, "false");
        testRunner.setProperty("some.property", "/*:bundle/node/subNode[1]/value/text()");
        testRunner.enqueue(XML_SNIPPET_NONEXISTENT_DOCTYPE);
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(EvaluateXPath.REL_FAILURE, 1);
    }
}

