/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractDatabaseFetchProcessor;
import org.apache.nifi.processors.standard.QueryDatabaseTable;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.db.impl.GenericDatabaseAdapter;
import org.apache.nifi.processors.standard.db.impl.MSSQLDatabaseAdapter;
import org.apache.nifi.processors.standard.db.impl.MySQLDatabaseAdapter;
import org.apache.nifi.processors.standard.db.impl.OracleDatabaseAdapter;
import org.apache.nifi.processors.standard.db.impl.PhoenixDatabaseAdapter;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.util.file.FileUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueryDatabaseTableTest {
    MockQueryDatabaseTable processor;
    protected TestRunner runner;
    private static final String DB_LOCATION = "target/db_qdt";
    private DatabaseAdapter dbAdapter;
    private HashMap<String, DatabaseAdapter> origDbAdapters;
    private static final String TABLE_NAME_KEY = "tableName";
    private static final String MAX_ROWS_KEY = "maxRows";

    @BeforeAll
    public static void setupBeforeClass() {
        System.setProperty("derby.stream.error.file", "target/derby.log");
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterAll
    public static void cleanUpAfterClass() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:target/db_qdt;shutdown=true");
        }
        catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
            // empty catch block
        }
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.clearProperty("derby.stream.error.file");
    }

    public DatabaseAdapter createDatabaseAdapter() {
        return new GenericDatabaseAdapter();
    }

    public void createDbcpControllerService() throws InitializationException {
        DBCPServiceSimpleImpl dbcp = new DBCPServiceSimpleImpl();
        HashMap dbcpProperties = new HashMap();
        this.runner.addControllerService("dbcp", (ControllerService)dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)dbcp);
    }

    @BeforeEach
    public void setup() throws InitializationException, IOException {
        this.origDbAdapters = new HashMap(QueryDatabaseTable.dbAdapters);
        this.dbAdapter = this.createDatabaseAdapter();
        QueryDatabaseTable.dbAdapters.put(this.dbAdapter.getName(), this.dbAdapter);
        this.processor = new MockQueryDatabaseTable();
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        this.createDbcpControllerService();
        this.runner.setProperty(QueryDatabaseTable.DBCP_SERVICE, "dbcp");
        this.runner.setProperty(QueryDatabaseTable.DB_TYPE, this.dbAdapter.getName());
        this.runner.getStateManager().clear(Scope.CLUSTER);
    }

    @AfterEach
    public void teardown() throws IOException {
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner = null;
        QueryDatabaseTable.dbAdapters.clear();
        QueryDatabaseTable.dbAdapters.putAll(this.origDbAdapters);
    }

    @Test
    public void testGetQuery() throws Exception {
        String query = this.processor.getQuery(this.dbAdapter, "myTable", null, null, null, null);
        Assertions.assertEquals((Object)"SELECT * FROM myTable", (Object)query);
        query = this.processor.getQuery(this.dbAdapter, "myTable", "col1,col2", null, null, null);
        Assertions.assertEquals((Object)"SELECT col1,col2 FROM myTable", (Object)query);
        query = this.processor.getQuery(this.dbAdapter, "myTable", null, Collections.singletonList("id"), null, null);
        Assertions.assertEquals((Object)"SELECT * FROM myTable", (Object)query);
        HashMap<String, String> maxValues = new HashMap<String, String>();
        maxValues.put("id", "509");
        MockStateManager stateManager = this.runner.getStateManager();
        stateManager.setState(maxValues, Scope.CLUSTER);
        this.processor.putColumnType(MockQueryDatabaseTable.getStateKey((String)"mytable", (String)"id", (DatabaseAdapter)this.dbAdapter), 4);
        query = this.processor.getQuery(this.dbAdapter, "myTable", null, Collections.singletonList("id"), null, stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM myTable WHERE id > 509", (Object)query);
        maxValues.put("date_created", "2016-03-07 12:34:56");
        stateManager.setState(maxValues, Scope.CLUSTER);
        this.processor.putColumnType(MockQueryDatabaseTable.getStateKey((String)"mytable", (String)"date_created", (DatabaseAdapter)this.dbAdapter), 93);
        query = this.processor.getQuery(this.dbAdapter, "myTable", null, Arrays.asList("id", "DATE_CREATED"), null, stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM myTable WHERE id > 509 AND DATE_CREATED >= '2016-03-07 12:34:56'", (Object)query);
        maxValues.put("mytable@!@date-created", "2016-03-07 12:34:56");
        stateManager.setState(maxValues, Scope.CLUSTER);
        this.processor.putColumnType(MockQueryDatabaseTable.getStateKey((String)"\"myTable\"", (String)"\"DATE-CREATED\"", (DatabaseAdapter)this.dbAdapter), 93);
        query = this.processor.getQuery(this.dbAdapter, "\"myTable\"", null, Arrays.asList("id", "\"DATE-CREATED\""), null, stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM \"myTable\" WHERE id > 509 AND \"DATE-CREATED\" >= '2016-03-07 12:34:56'", (Object)query);
        this.dbAdapter = new MySQLDatabaseAdapter();
        this.processor.putColumnType(MockQueryDatabaseTable.getStateKey((String)"`myTable`", (String)"`DATE-CREATED`", (DatabaseAdapter)this.dbAdapter), 93);
        query = this.processor.getQuery(this.dbAdapter, "`myTable`", null, Arrays.asList("id", "`DATE-CREATED`"), null, stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM `myTable` WHERE id > 509 AND `DATE-CREATED` >= '2016-03-07 12:34:56'", (Object)query);
        this.dbAdapter = new MSSQLDatabaseAdapter();
        this.processor.putColumnType(MockQueryDatabaseTable.getStateKey((String)"[myTable]", (String)"[DATE-CREATED]", (DatabaseAdapter)this.dbAdapter), 93);
        query = this.processor.getQuery(this.dbAdapter, "[myTable]", null, Arrays.asList("id", "[DATE-CREATED]"), null, stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM [myTable] WHERE id > 509 AND [DATE-CREATED] >= '2016-03-07 12:34:56'", (Object)query);
        this.dbAdapter = new OracleDatabaseAdapter();
        query = this.processor.getQuery(this.dbAdapter, "myTable", null, Arrays.asList("id", "DATE_CREATED"), "type = \"CUSTOMER\"", stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM myTable WHERE id > 509 AND DATE_CREATED >= timestamp '2016-03-07 12:34:56' AND (type = \"CUSTOMER\")", (Object)query);
        this.processor.putColumnType("mytable@!@time_created", 92);
        maxValues.clear();
        maxValues.put("id", "509");
        maxValues.put("time_created", "12:34:57");
        maxValues.put("date_created", "2016-03-07 12:34:56");
        stateManager = this.runner.getStateManager();
        stateManager.clear(Scope.CLUSTER);
        stateManager.setState(maxValues, Scope.CLUSTER);
        query = this.processor.getQuery(this.dbAdapter, "myTable", null, Arrays.asList("id", "DATE_CREATED", "TIME_CREATED"), "type = \"CUSTOMER\"", stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM myTable WHERE id > 509 AND DATE_CREATED >= timestamp '2016-03-07 12:34:56' AND TIME_CREATED >= timestamp '12:34:57' AND (type = \"CUSTOMER\")", (Object)query);
        this.dbAdapter = new GenericDatabaseAdapter();
        query = this.processor.getQuery(this.dbAdapter, "myTable", null, Arrays.asList("id", "DATE_CREATED", "TIME_CREATED"), "type = \"CUSTOMER\"", stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM myTable WHERE id > 509 AND DATE_CREATED >= '2016-03-07 12:34:56' AND TIME_CREATED >= '12:34:57' AND (type = \"CUSTOMER\")", (Object)query);
    }

    @Test
    public void testGetQueryUsingPhoenixAdapter() throws Exception {
        HashMap<String, String> maxValues = new HashMap<String, String>();
        MockStateManager stateManager = this.runner.getStateManager();
        this.processor.putColumnType("mytable@!@id", 4);
        this.processor.putColumnType("mytable@!@time_created", 92);
        this.processor.putColumnType("mytable@!@date_created", 93);
        maxValues.put("id", "509");
        maxValues.put("time_created", "12:34:57");
        maxValues.put("date_created", "2016-03-07 12:34:56");
        stateManager.setState(maxValues, Scope.CLUSTER);
        this.dbAdapter = new PhoenixDatabaseAdapter();
        String query = this.processor.getQuery(this.dbAdapter, "myTable", null, Arrays.asList("id", "DATE_CREATED", "TIME_CREATED"), "type = \"CUSTOMER\"", stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM myTable WHERE id > 509 AND DATE_CREATED >= timestamp '2016-03-07 12:34:56' AND TIME_CREATED >= time '12:34:57' AND (type = \"CUSTOMER\")", (Object)query);
        this.dbAdapter = new GenericDatabaseAdapter();
        query = this.processor.getQuery(this.dbAdapter, "myTable", null, Arrays.asList("id", "DATE_CREATED", "TIME_CREATED"), "type = \"CUSTOMER\"", stateManager.getState(Scope.CLUSTER).toMap());
        Assertions.assertEquals((Object)"SELECT * FROM myTable WHERE id > 509 AND DATE_CREATED >= '2016-03-07 12:34:56' AND TIME_CREATED >= '12:34:57' AND (type = \"CUSTOMER\")", (Object)query);
    }

    @Test
    public void testGetQueryNoTable() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.processor.getQuery(this.dbAdapter, null, null, null, null, null));
    }

    @Test
    public void testAddedRows() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 2);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("tablename"));
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        ByteArrayInputStream in = new ByteArrayInputStream(flowFile.toByteArray());
        this.runner.setProperty(QueryDatabaseTable.FETCH_SIZE, "2");
        Assertions.assertEquals((long)2L, (long)this.getNumberOfRecordsFromStream(in));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(1);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "0");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"3");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "id, created_on");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (4, 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"4");
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.created_on"), (Object)"2011-01-01 03:23:34.234");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (5, 'NO NAME', 15.0, '2001-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (6, 'Mr. NiFi', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "name");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)7L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (7, 'NULK', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "scale");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)8L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (8, 'NULK', 100.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "bignum");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)9L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on, bignum) VALUES (9, 'Alice Bob', 100.0, '2012-01-01 03:23:34.234', 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
    }

    @Test
    public void testAddedRowsAutoCommitTrue() throws SQLException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "2");
        this.runner.setProperty(QueryDatabaseTable.FETCH_SIZE, "2");
        this.runner.setProperty(QueryDatabaseTable.AUTO_COMMIT, "true");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 2);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("tablename"));
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        ByteArrayInputStream in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)2L, (long)this.getNumberOfRecordsFromStream(in));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(1);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
    }

    @Test
    public void testAddedRowsAutoCommitFalse() throws SQLException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "2");
        this.runner.setProperty(QueryDatabaseTable.FETCH_SIZE, "2");
        this.runner.setProperty(QueryDatabaseTable.AUTO_COMMIT, "false");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 2);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("tablename"));
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        ByteArrayInputStream in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)2L, (long)this.getNumberOfRecordsFromStream(in));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(1);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
    }

    @Test
    public void testAddedRowsTwoTables() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 2);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("tablename"));
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        ByteArrayInputStream in = new ByteArrayInputStream(flowFile.toByteArray());
        this.runner.setProperty(QueryDatabaseTable.FETCH_SIZE, "2");
        Assertions.assertEquals((long)2L, (long)this.getNumberOfRecordsFromStream(in));
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(1);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("create table TEST_QUERY_DB_TABLE2 (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (0, 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (2, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE2");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "0");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE2", (Object)flowFile.getAttribute("tablename"));
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"2");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)3L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE2 (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"3");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testMultiplePartitions() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, bucket integer not null)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (0, 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (1, 0)");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID, BUCKET");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        Assertions.assertEquals((Object)"2", (Object)((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).getAttribute("querydbtable.row.count"));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (2, 0)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        Assertions.assertEquals((Object)"1", (Object)((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).getAttribute("querydbtable.row.count"));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (3, 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        Assertions.assertEquals((Object)"1", (Object)((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).getAttribute("querydbtable.row.count"));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (4, 0)");
        this.runner.run();
        this.runner.assertTransferCount(QueryDatabaseTable.REL_SUCCESS, 0);
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, bucket) VALUES (5, 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        Assertions.assertEquals((Object)"1", (Object)((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).getAttribute("querydbtable.row.count"));
        this.runner.clearTransferState();
    }

    @Test
    public void testTimestampNanos() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (1, 'Carrie Jones', 5.0, '2000-01-01 03:23:34.000123456')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "created_on");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        ByteArrayInputStream in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.000')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (3, 'Mary West', 15.0, '2000-01-01 03:23:34.0003')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testWithNullIntColumn() throws SQLException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (1, 1, 1)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_NULL_INT");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).assertAttributeEquals("querydbtable.row.count", "2");
    }

    @Test
    public void testWithRuntimeException() throws SQLException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (1, 1, 1)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_NULL_INT");
        this.runner.setProperty(AbstractDatabaseFetchProcessor.MAX_VALUE_COLUMN_NAMES, "id");
        QueryDatabaseTable.dbAdapters.put(this.dbAdapter.getName(), new GenericDatabaseAdapter(){

            public String getName() {
                throw new DataFileWriter.AppendWriteException(null);
            }
        });
        this.runner.run();
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).isEmpty());
    }

    @Test
    public void testWithSqlException() throws SQLException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NO_ROWS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NO_ROWS (id integer)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_NO_ROWS");
        this.runner.setProperty(QueryDatabaseTable.COLUMN_NAMES, "val1");
        this.runner.run();
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).isEmpty());
    }

    @Test
    public void testOutputBatchSize() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        ByteArrayInputStream in;
        MockFlowFile mff;
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        int rowCount = 0;
        for (int batch = 0; batch < 100; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
            ++rowCount;
        }
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "${maxRows}");
        this.runner.setVariable(MAX_ROWS_KEY, "7");
        this.runner.setProperty(QueryDatabaseTable.OUTPUT_BATCH_SIZE, "${outputBatchSize}");
        this.runner.setVariable("outputBatchSize", "4");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 15);
        for (int ff = 0; ff < 14; ++ff) {
            mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(ff);
            in = new ByteArrayInputStream(mff.toByteArray());
            Assertions.assertEquals((long)7L, (long)this.getNumberOfRecordsFromStream(in));
            mff.assertAttributeExists("fragment.identifier");
            Assertions.assertEquals((Object)Integer.toString(ff), (Object)mff.getAttribute("fragment.index"));
            Assertions.assertNull((Object)mff.getAttribute("fragment.count"));
        }
        mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(14);
        in = new ByteArrayInputStream(mff.toByteArray());
        Assertions.assertEquals((long)2L, (long)this.getNumberOfRecordsFromStream(in));
        mff.assertAttributeExists("fragment.identifier");
        Assertions.assertEquals((Object)Integer.toString(14), (Object)mff.getAttribute("fragment.index"));
        Assertions.assertNull((Object)mff.getAttribute("fragment.count"));
    }

    @Test
    public void testMaxRowsPerFlowFile() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        ByteArrayInputStream in;
        MockFlowFile mff;
        int batch;
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        int rowCount = 0;
        for (batch = 0; batch < 100; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
            ++rowCount;
        }
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "${maxRows}");
        this.runner.setVariable(MAX_ROWS_KEY, "9");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 12);
        for (int ff = 0; ff < 11; ++ff) {
            mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(ff);
            in = new ByteArrayInputStream(mff.toByteArray());
            Assertions.assertEquals((long)9L, (long)this.getNumberOfRecordsFromStream(in));
            mff.assertAttributeExists("fragment.identifier");
            Assertions.assertEquals((Object)Integer.toString(ff), (Object)mff.getAttribute("fragment.index"));
            Assertions.assertEquals((Object)"12", (Object)mff.getAttribute("fragment.count"));
        }
        mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(11);
        in = new ByteArrayInputStream(mff.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        mff.assertAttributeExists("fragment.identifier");
        Assertions.assertEquals((Object)Integer.toString(11), (Object)mff.getAttribute("fragment.index"));
        Assertions.assertEquals((Object)"12", (Object)mff.getAttribute("fragment.count"));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        for (batch = 0; batch < 5; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
            ++rowCount;
        }
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        in = new ByteArrayInputStream(mff.toByteArray());
        mff.assertAttributeExists("fragment.identifier");
        Assertions.assertEquals((Object)Integer.toString(0), (Object)mff.getAttribute("fragment.index"));
        Assertions.assertEquals((Object)"1", (Object)mff.getAttribute("fragment.count"));
        Assertions.assertEquals((long)5L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        for (batch = 0; batch < 14; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
            ++rowCount;
        }
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 2);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)9L, (long)this.getNumberOfRecordsFromStream(in));
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(1)).toByteArray());
        Assertions.assertEquals((long)5L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        int ffCount = (int)Math.ceil((double)rowCount / 9.0);
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, ffCount);
        for (int ff = 0; ff < ffCount - 1; ++ff) {
            in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(ff)).toByteArray());
            Assertions.assertEquals((long)9L, (long)this.getNumberOfRecordsFromStream(in));
        }
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(ffCount - 1)).toByteArray());
        Assertions.assertEquals((long)(rowCount % 9), (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
    }

    @Test
    public void testMaxRowsPerFlowFileWithMaxFragments() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        int rowCount = 0;
        for (int batch = 0; batch < 100; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
            ++rowCount;
        }
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "9");
        Integer maxFragments = 3;
        this.runner.setProperty(QueryDatabaseTable.MAX_FRAGMENTS, maxFragments.toString());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, maxFragments.intValue());
        for (int i = 0; i < maxFragments; ++i) {
            MockFlowFile mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(i);
            ByteArrayInputStream in = new ByteArrayInputStream(mff.toByteArray());
            Assertions.assertEquals((long)9L, (long)this.getNumberOfRecordsFromStream(in));
            mff.assertAttributeExists("fragment.identifier");
            Assertions.assertEquals((Object)Integer.toString(i), (Object)mff.getAttribute("fragment.index"));
            Assertions.assertEquals((Object)maxFragments.toString(), (Object)mff.getAttribute("fragment.count"));
        }
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialMaxValue() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(0L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int rowCount = 0;
        for (int batch = 0; batch < 10; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '" + dateFormat.format(cal.getTime().getTime()) + "')");
            ++rowCount;
            cal.add(12, 1);
        }
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "${tableName}");
        this.runner.setVariable(TABLE_NAME_KEY, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "created_on");
        cal.setTimeInMillis(0L);
        cal.add(12, 5);
        this.runner.setProperty("initial.maxvalue.CREATED_ON", dateFormat.format(cal.getTime().getTime()));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        ByteArrayInputStream in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)4L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialMaxValueWithEL() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(0L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int rowCount = 0;
        for (int batch = 0; batch < 10; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '" + dateFormat.format(cal.getTime().getTime()) + "')");
            ++rowCount;
            cal.add(12, 1);
        }
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "${tableName}");
        this.runner.setVariable(TABLE_NAME_KEY, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "created_on");
        cal.setTimeInMillis(0L);
        cal.add(12, 5);
        this.runner.setProperty("initial.maxvalue.CREATED_ON", "${created.on}");
        this.runner.setVariable("created.on", dateFormat.format(cal.getTime().getTime()));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        ByteArrayInputStream in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)4L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
        cal.setTimeInMillis(0L);
        cal.add(12, rowCount);
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '" + dateFormat.format(cal.getTime().getTime()) + "')");
        ++rowCount;
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:10:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialLoadStrategyStartAtBeginning() throws SQLException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(0L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int rowCount = 0;
        for (int batch = 0; batch < 10; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '" + dateFormat.format(cal.getTime().getTime()) + "')");
            ++rowCount;
            cal.add(12, 1);
        }
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "${tableName}");
        this.runner.setVariable(TABLE_NAME_KEY, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "created_on");
        this.runner.setProperty(QueryDatabaseTable.INITIAL_LOAD_STRATEGY, QueryDatabaseTable.INITIAL_LOAD_STRATEGY_ALL_ROWS.getValue());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        ByteArrayInputStream in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)10L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
    }

    @Test
    public void testInitialLoadStrategyStartAtCurrentMaximumValues() throws SQLException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(0L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int rowCount = 0;
        for (int batch = 0; batch < 10; ++batch) {
            stmt.execute("insert into TEST_QUERY_DB_TABLE (id, name, scale, created_on) VALUES (" + rowCount + ", 'Joe Smith', 1.0, '" + dateFormat.format(cal.getTime().getTime()) + "')");
            ++rowCount;
            cal.add(12, 1);
        }
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "${tableName}");
        this.runner.setVariable(TABLE_NAME_KEY, "TEST_QUERY_DB_TABLE");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "created_on");
        this.runner.setProperty(QueryDatabaseTable.INITIAL_LOAD_STRATEGY, QueryDatabaseTable.INITIAL_LOAD_STRATEGY_NEW_ROWS.getValue());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.getStateManager().assertStateEquals("test_query_db_table@!@created_on", "1970-01-01 00:09:00.0", Scope.CLUSTER);
        this.runner.clearTransferState();
    }

    @Test
    public void testAddedRowsCustomWhereClause() throws ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, type varchar(20), name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (0, 'male', 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (1, 'female', 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (2, NULL, NULL, 2.0, '2010-01-01 00:00:00')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setProperty(QueryDatabaseTable.WHERE_CLAUSE, "type = 'male'");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("tablename"));
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"0");
        ByteArrayInputStream in = new ByteArrayInputStream(flowFile.toByteArray());
        this.runner.setProperty(QueryDatabaseTable.FETCH_SIZE, "2");
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "0");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (3, 'female', 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "id, created_on");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (4, 'male', 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"4");
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.created_on"), (Object)"2011-01-01 03:23:34.234");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (5, 'male', 'NO NAME', 15.0, '2001-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (6, 'male', 'Mr. NiFi', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "name");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)4L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (7, 'male', 'NULK', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "scale");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)5L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (8, 'male', 'NULK', 100.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "bignum");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)6L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on, bignum) VALUES (9, 'female', 'Alice Bob', 100.0, '2012-01-01 03:23:34.234', 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testCustomSQL() throws SQLException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.execute("drop table TYPE_LIST");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, type varchar(20), name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (0, 'male', 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (1, 'female', 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (2, NULL, NULL, 2.0, '2010-01-01 00:00:00')");
        stmt.execute("create table TYPE_LIST (type_id integer not null, type varchar(20), descr varchar(255))");
        stmt.execute("insert into TYPE_LIST (type_id, type,descr) VALUES (0, 'male', 'Man')");
        stmt.execute("insert into TYPE_LIST (type_id, type,descr) VALUES (1, 'female', 'Woman')");
        stmt.execute("insert into TYPE_LIST (type_id, type,descr) VALUES (2, '', 'Unspecified')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_QUERY_DB_TABLE");
        this.runner.setProperty(QueryDatabaseTable.SQL_QUERY, "SELECT id, b.type as gender, b.descr, name, scale, created_on, bignum FROM TEST_QUERY_DB_TABLE a INNER JOIN TYPE_LIST b ON (a.type=b.type)");
        this.runner.setProperty(QueryDatabaseTable.WHERE_CLAUSE, "gender = 'male'");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "2");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)"TEST_QUERY_DB_TABLE", (Object)flowFile.getAttribute("tablename"));
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"0");
        ByteArrayInputStream in = new ByteArrayInputStream(flowFile.toByteArray());
        this.runner.setProperty(QueryDatabaseTable.FETCH_SIZE, "2");
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "0");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (3, 'female', 'Mary West', 15.0, '2000-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "id, created_on");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (4, 'male', 'Marty Johnson', 15.0, '2011-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0);
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.id"), (Object)"4");
        Assertions.assertEquals((Object)flowFile.getAttribute("maxvalue.created_on"), (Object)"2011-01-01 03:23:34.234");
        in = new ByteArrayInputStream(flowFile.toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (5, 'male', 'NO NAME', 15.0, '2001-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (6, 'male', 'Mr. NiFi', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "name");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)4L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (7, 'male', 'NULK', 1.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "scale");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)5L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (8, 'male', 'NULK', 100.0, '2012-01-01 03:23:34.234')");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)1L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        this.runner.getStateManager().clear(Scope.CLUSTER);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "bignum");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 1);
        in = new ByteArrayInputStream(((MockFlowFile)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertEquals((long)6L, (long)this.getNumberOfRecordsFromStream(in));
        this.runner.clearTransferState();
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on, bignum) VALUES (9, 'female', 'Alice Bob', 100.0, '2012-01-01 03:23:34.234', 1)");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(QueryDatabaseTable.REL_SUCCESS, 0);
        this.runner.clearTransferState();
    }

    @Test
    public void testMissingColumn() throws ProcessException, ClassNotFoundException, SQLException, InitializationException, IOException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_QUERY_DB_TABLE");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmt.execute("drop table TYPE_LIST");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_QUERY_DB_TABLE (id integer not null, type varchar(20), name varchar(100), scale float, created_on timestamp, bignum bigint default 0)");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (0, 'male', 'Joe Smith', 1.0, '1962-09-23 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (1, 'female', 'Carrie Jones', 5.0, '2000-01-01 03:23:34.234')");
        stmt.execute("insert into TEST_QUERY_DB_TABLE (id, type, name, scale, created_on) VALUES (2, NULL, NULL, 2.0, '2010-01-01 00:00:00')");
        stmt.execute("create table TYPE_LIST (type_id integer not null, type varchar(20), descr varchar(255))");
        stmt.execute("insert into TYPE_LIST (type_id, type,descr) VALUES (0, 'male', 'Man')");
        stmt.execute("insert into TYPE_LIST (type_id, type,descr) VALUES (1, 'female', 'Woman')");
        stmt.execute("insert into TYPE_LIST (type_id, type,descr) VALUES (2, '', 'Unspecified')");
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TYPE_LIST");
        this.runner.setProperty(QueryDatabaseTable.SQL_QUERY, "SELECT b.type, b.descr, name, scale, created_on, bignum FROM TEST_QUERY_DB_TABLE a INNER JOIN TYPE_LIST b ON (a.type=b.type)");
        this.runner.setProperty(QueryDatabaseTable.WHERE_CLAUSE, "type = 'male'");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.MAX_VALUE_COLUMN_NAMES, "ID");
        this.runner.setProperty(QueryDatabaseTable.MAX_ROWS_PER_FLOW_FILE, "2");
        Assertions.assertThrows(AssertionError.class, () -> this.runner.run());
    }

    @Test
    public void testWithExceptionAfterSomeRowsProcessed() throws SQLException {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_NULL_INT");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_NULL_INT (id integer not null, val1 integer, val2 integer, constraint my_pk primary key (id))");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (1, NULL, 1)");
        stmt.execute("insert into TEST_NULL_INT (id, val1, val2) VALUES (2, 1, 1)");
        this.runner.setIncomingConnection(false);
        this.runner.setProperty(QueryDatabaseTable.TABLE_NAME, "TEST_NULL_INT");
        this.runner.setProperty(AbstractDatabaseFetchProcessor.MAX_VALUE_COLUMN_NAMES, "id");
        QueryDatabaseTable.dbAdapters.put(this.dbAdapter.getName(), new GenericDatabaseAdapter(){
            boolean fail = false;

            public String getName() {
                if (!this.fail) {
                    this.fail = true;
                    return super.getName();
                }
                throw new DataFileWriter.AppendWriteException(null);
            }
        });
        this.runner.run();
        Assertions.assertTrue((boolean)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).isEmpty());
        this.runner.getStateManager().assertStateNotSet("test_null_int@!@id", Scope.CLUSTER);
        QueryDatabaseTable.dbAdapters.put(this.dbAdapter.getName(), this.dbAdapter);
        this.runner.run();
        Assertions.assertFalse((boolean)this.runner.getFlowFilesForRelationship(QueryDatabaseTable.REL_SUCCESS).isEmpty());
        this.runner.getStateManager().assertStateEquals("test_null_int@!@id", "2", Scope.CLUSTER);
    }

    private long getNumberOfRecordsFromStream(InputStream in) throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader();
        try (DataFileStream dataFileReader = new DataFileStream(in, (DatumReader)datumReader);){
            GenericRecord record = null;
            long recordsFromStream = 0L;
            while (dataFileReader.hasNext()) {
                record = (GenericRecord)dataFileReader.next(record);
                ++recordsFromStream;
            }
            long l = recordsFromStream;
            return l;
        }
    }

    @Stateful(scopes={Scope.CLUSTER}, description="Mock for QueryDatabaseTable processor")
    protected static class MockQueryDatabaseTable
    extends QueryDatabaseTable {
        protected MockQueryDatabaseTable() {
        }

        void putColumnType(String colName, Integer colType) {
            this.columnTypeMap.put(colName, colType);
        }
    }

    private class DBCPServiceSimpleImpl
    extends AbstractControllerService
    implements DBCPService {
        private DBCPServiceSimpleImpl() {
        }

        public String getIdentifier() {
            return "dbcp";
        }

        public Connection getConnection() throws ProcessException {
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                return DriverManager.getConnection("jdbc:derby:target/db_qdt;create=true");
            }
            catch (Exception e) {
                throw new ProcessException("getConnection failed: " + e);
            }
        }
    }
}

