/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.DefaultRunDuration;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@SupportsBatching(defaultDuration=DefaultRunDuration.TWENTY_FIVE_MILLIS)
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"file", "remove", "delete", "local", "files", "filesystem"})
@CapabilityDescription(value="Deletes a file from the filesystem.")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.READ_FILESYSTEM, explanation="Provides operator the ability to read from any file that NiFi has access to."), @Restriction(requiredPermission=RequiredPermission.WRITE_FILESYSTEM, explanation="Provides operator the ability to delete any file that NiFi has access to.")})
public class DeleteFile
extends AbstractProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles, for which an existing file has been deleted, are routed to this relationship").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("All FlowFiles, for which the file to delete did not exist, are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles, for which an existing file could not be deleted, are routed to this relationship").build();
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_NOT_FOUND, REL_FAILURE)));
    public static final PropertyDescriptor DIRECTORY_PATH = new PropertyDescriptor.Builder().name("Directory Path").description("The path to the directory the file to delete is located in.").required(true).defaultValue("${" + CoreAttributes.ABSOLUTE_PATH.key() + "}").addValidator(StandardValidators.createDirectoryExistsValidator((boolean)true, (boolean)false)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").description("The name of the file to delete.").required(true).defaultValue("${" + CoreAttributes.FILENAME.key() + "}").addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    private static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(DIRECTORY_PATH, FILENAME));

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String directoryPathProperty = context.getProperty(DIRECTORY_PATH).evaluateAttributeExpressions(flowFile).getValue();
        String filename = context.getProperty(FILENAME).evaluateAttributeExpressions(flowFile).getValue();
        try {
            Path directoryPath = Paths.get(directoryPathProperty, new String[0]).toRealPath(new LinkOption[0]);
            Path filePath = directoryPath.resolve(filename).toRealPath(new LinkOption[0]);
            if (!directoryPath.equals(filePath.getParent())) {
                String errorMessage = String.format("Attempting to delete file at path '%s' which is not a direct child of the directory '%s'", filePath, directoryPath);
                this.handleFailure(session, flowFile, errorMessage, null);
                return;
            }
            Files.delete(filePath);
            session.transfer(flowFile, REL_SUCCESS);
            String transitUri = String.format("file://%s", filePath);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            this.getLogger().debug("Successfully deleted file at path {} in {} millis; routing to success", new Object[]{flowFile, transferMillis});
            session.getProvenanceReporter().invokeRemoteProcess(flowFile, transitUri, "Object deleted");
        }
        catch (NoSuchFileException noSuchFileException) {
            session.transfer(flowFile, REL_NOT_FOUND);
        }
        catch (IOException ioException) {
            String errorMessage = String.format("Failed to delete file '%s' in directory '%s'", filename, directoryPathProperty);
            this.handleFailure(session, flowFile, errorMessage, ioException);
        }
    }

    private void handleFailure(ProcessSession session, FlowFile flowFile, String errorMessage, Throwable throwable) {
        this.getLogger().error(errorMessage, throwable);
        session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }
}

